(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    380742,      10859]*)
(*NotebookOutlinePosition[    384222,      10951]*)
(*  CellTagsIndexPosition[    384071,      10943]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
Chapter 4
Forced Oscillations of the Duffing Equation\
\>", "Title",
  TextAlignment->Left,
  TextJustification->0],

Cell[BoxData[
    \(Off[General::spell1]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
In contrast with the preceding chapters, which deal with free oscillations, \
this chapter and the next two deal with forced oscillations. We consider\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(FDuffingEq = 
      \(u\^\[DoublePrime]\)[t] + \[Omega]\^2\ u[t] + 
          2  \[Mu]\&^\ \(u\^\[Prime]\)[t] + \[Delta]\ u[t]\^2 + 
          \[Alpha]\ u[t]\^3 == F\ Cos[\[CapitalOmega]\ t]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\&^\)]],
  " is a positive constant. In this chapter, we determine second-order \
solutions to ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " beginning with the straightforward expansion in the next section. We \
investigate this straightforward expansion and determine under what \
conditions it breaks down. This leads to the so-called resonance values of \
\[CapitalOmega]. In Section 4.2, we use the method of multiple scales to \
determine second-order uniform expansions of the solutions of ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " for all resonance cases, including the effect of light viscous damping. \
In Sections 4.3 and 4.4, we use the generalized method of averaging and the \
method of normal forms, respectively, to determine second-order uniform \
expansions for the case of subharmonic resonance of order one-half; that is, \
",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] 2  \[Omega]\)]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["4.1 Straightforward Expansion", "Section",
  CellMargins->{{Inherited, 17.4375}, {Inherited, Inherited}},
  Evaluatable->False,
  TextAlignment->Left,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],

Cell[TextData[{
  "We seek a straightforward expansion for the solutions of ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(uSol = u -> \((Sum[\[Epsilon]\^i\ u\_i[#], {i, 3}]\ &)\); \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["uSol",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["FDuffingEq ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[", ",
    FontSlant->"Italic"],
  "letting ",
  Cell[BoxData[
      \(TraditionalForm
      \`F = \(\[Epsilon]\ f\ \ and\ \ \(\ \[Mu]\)\&^ = 
          \[Epsilon]\ \[Mu]\)\)]],
  ", expanding the result for small \[Epsilon], and discarding terms of order \
higher than ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\^3\)]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq41a = 
      \((\(FDuffingEq /. uSol\) /. {F -> \[Epsilon]\ f, 
                \[Mu]\&^ -> \[Epsilon]\ \[Mu]} // ExpandAll)\) /. 
        \[Epsilon]\^\(n_ /; n > 3\) -> 0\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\[Epsilon]\ \[Omega]\^2\ u\_1[t]\), "+", 
        \(\[Delta]\ \[Epsilon]\^2\ u\_1[t]\^2\), "+", 
        \(\[Alpha]\ \[Epsilon]\^3\ u\_1[t]\^3\), "+", 
        \(\[Epsilon]\^2\ \[Omega]\^2\ u\_2[t]\), "+", 
        \(2\ \[Delta]\ \[Epsilon]\^3\ u\_1[t]\ u\_2[t]\), "+", 
        \(\[Epsilon]\^3\ \[Omega]\^2\ u\_3[t]\), "+", 
        RowBox[{"2", " ", \(\[Epsilon]\^2\), " ", "\[Mu]", " ", 
          RowBox[{
            SubsuperscriptBox["u", "1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}], "+", 
        RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", "\[Mu]", " ", 
          RowBox[{
            SubsuperscriptBox["u", "2", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}], "+", 
        RowBox[{"\[Epsilon]", " ", 
          RowBox[{
            SubsuperscriptBox["u", "1", "\[DoublePrime]",
              MultilineFunction->None], "[", "t", "]"}]}], "+", 
        RowBox[{\(\[Epsilon]\^2\), " ", 
          RowBox[{
            SubsuperscriptBox["u", "2", "\[DoublePrime]",
              MultilineFunction->None], "[", "t", "]"}]}], "+", 
        RowBox[{\(\[Epsilon]\^3\), " ", 
          RowBox[{
            SubsuperscriptBox["u", "3", "\[DoublePrime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], "==", 
      \(f\ \[Epsilon]\ Cos[t\ \[CapitalOmega]]\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[
"Equating coefficients of like powers of \[Epsilon] on both sides yields"], 
  "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqEpsa = 
      \(CoefficientList[Subtract\ @@\ eq41a, \[Epsilon]] == 0 // Thread\) // 
        Rest\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
          \(\(-f\)\ Cos[t\ \[CapitalOmega]]\), "+", \(\[Omega]\^2\ u\_1[t]\), 
            "+", 
            RowBox[{
              SubsuperscriptBox["u", "1", "\[DoublePrime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\[Delta]\ u\_1[t]\^2\), "+", \(\[Omega]\^2\ u\_2[t]\), "+", 
            RowBox[{"2", " ", "\[Mu]", " ", 
              RowBox[{
                SubsuperscriptBox["u", "1", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{
              SubsuperscriptBox["u", "2", "\[DoublePrime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\[Alpha]\ u\_1[t]\^3\), "+", \(2\ \[Delta]\ u\_1[t]\ u\_2[t]\), 
            "+", \(\[Omega]\^2\ u\_3[t]\), "+", 
            RowBox[{"2", " ", "\[Mu]", " ", 
              RowBox[{
                SubsuperscriptBox["u", "2", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{
              SubsuperscriptBox["u", "3", "\[DoublePrime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
The particular solution of the first-order equation, linear and undamped \
problem, can be expressed as\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1p = 
      \(\(DSolve[eqEpsa[\([1]\)], u\_1[t], t]\)[\([1]\)] /. C[_] -> 0 // 
          TrigToExp\) // Simplify\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[t] \[Rule] 
        \(-\(\(E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ 
                \((1 + E\^\(2\ I\ t\ \[CapitalOmega]\))\)\ f\)\/\(2\ 
                \((\(-\[Omega]\^2\) + \[CapitalOmega]\^2)\)\)\)\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "We note that ",
  StyleBox["sol1p",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " consists of a term whose denominator is very small when ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] \[Omega]\)]],
  ". Such a term is called a ",
  StyleBox["small-divisor term",
    FontColor->RGBColor[0, 0, 1]],
  ". Moreover, ",
  Cell[BoxData[
      \(TraditionalForm\`u[t]\)]],
  " tends to infinity as ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[RightArrow] \[Omega]\)]],
  ", and the excitation is referred to as a ",
  StyleBox["resonance excitation",
    FontColor->RGBColor[0, 0, 1]],
  ". Because the small-divisor term appears in the first-order problem, we \
speak of a ",
  StyleBox["primary ",
    FontColor->RGBColor[0, 0, 1]],
  "or",
  StyleBox[" main resonance",
    FontColor->RGBColor[0, 0, 1]],
  ". When the small-divisor terms appear in the higher-order problems, we \
speak of",
  StyleBox[" secondary resonances",
    FontColor->RGBColor[0, 0, 1]],
  ". In the case of primary resonance, the scaling ",
  Cell[BoxData[
      \(TraditionalForm\`F \[RightArrow] \[Epsilon]\ f\)]],
  " is not valid. Physically, as soon as the motion becomes large, the \
damping and nonlinearity are activated to counter the effect of the \
resonance. Consequently, to obtain a uniform expansion in this case, we \
rescale ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\&^\)]],
  ", as discussed in Section 4.2, so that the influence of the damping and \
nonlinearity balances the influence of the primary resonance."
}], "Text",
  CellMargins->{{13, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "When \[CapitalOmega] is away from \[Omega], we add the homogeneous \
solution to ",
  StyleBox["sol1p",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and obtain the general solution of the first-order problem as"
}], "Text",
  CellMargins->{{13, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(fRule = {
        f -> 2  \[CapitalLambda]\ \((\[CapitalOmega]\^2 - \[Omega]\^2)\)}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = 
      u\_1 -> Function[t, 
          \(A\ E\^\(I\ \[Omega]\ t\) + A\&_\ E\^\(\(-I\)\ \[Omega]\ t\) + 
                  sol1p[\([1, 2]\)] /. fRule // Expand\) // Evaluate]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(u\_1 \[Rule] 
      Function[t, 
        A\ E\^\(I\ t\ \[Omega]\) - 
          E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[CapitalLambda] - 
          E\^\(I\ t\ \[CapitalOmega]\)\ \[CapitalLambda] + 
          E\^\(\(-I\)\ t\ \[Omega]\)\ A\&_]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " is a complex-valued constant. Substituting ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the second-order equation, ",
  StyleBox["eqEpsa[[2]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eqa = 
      \(\(\(u\_2\^\[DoublePrime]\)[t] + \[Omega]\^2\ u\_2[t] - #\ &\)\ /@\ 
              eqEpsa[\([2]\)] /. sol1 // ExpandAll\) // Reverse\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{\(\[Omega]\^2\ u\_2[t]\), "+", 
        RowBox[{
          SubsuperscriptBox["u", "2", "\[DoublePrime]",
            MultilineFunction->None], "[", "t", "]"}]}], "==", 
      \(\(-A\^2\)\ E\^\(2\ I\ t\ \[Omega]\)\ \[Delta] + 
        2\ A\ E\^\(I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda] + 
        2\ A\ E\^\(I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda] - 2\ \[Delta]\ \[CapitalLambda]\^2 - 
        E\^\(\(-2\)\ I\ t\ \[CapitalOmega]\)\ \[Delta]\ \[CapitalLambda]\^2 - 
        E\^\(2\ I\ t\ \[CapitalOmega]\)\ \[Delta]\ \[CapitalLambda]\^2 - 
        2\ I\ A\ E\^\(I\ t\ \[Omega]\)\ \[Mu]\ \[Omega] - 
        2\ I\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
          \[CapitalOmega] + 
        2\ I\ E\^\(I\ t\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
          \[CapitalOmega] - 2\ A\ \[Delta]\ A\&_ + 
        2\ E\^\(\(-I\)\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\ A\&_ + 
        2\ E\^\(\(-I\)\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\ A\&_ + 
        2\ I\ E\^\(\(-I\)\ t\ \[Omega]\)\ \[Mu]\ \[Omega]\ A\&_ - 
        E\^\(\(-2\)\ I\ t\ \[Omega]\)\ \[Delta]\ A\&_\^2\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Solving for the particular solution of ",
  StyleBox["order2Eqa",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2p = 
      \(\((\(\(u\_2[t] /. 
                    \(DSolve[order2Eqa[\([1]\)] == #, u\_2[t], t]\)[\([1]\)]
                      \) /. C[_] -> 0 // TrigToExp\) // Simplify)\)\ &\)\ /@\ 
        order2Eqa[\([2]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(A\^2\ E\^\(2\ I\ t\ \[Omega]\)\ \[Delta]\)\/\(3\ \[Omega]\^2\) - 
      \(2\ \[Delta]\ \[CapitalLambda]\^2\)\/\[Omega]\^2 - 
      \(A\ E\^\(I\ t\ \[Omega]\)\ \[Mu]\ \((I + 2\ t\ \[Omega])\)\)\/\(2\ 
          \[Omega]\) + 
      \(2\ A\ E\^\(I\ t\ \((\[Omega] - \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
          \[CapitalOmega]\) - 
      \(2\ A\ E\^\(I\ t\ \((\[Omega] + \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\)\/\(\[CapitalOmega]\ 
          \((2\ \[Omega] + \[CapitalOmega])\)\) + 
      \(2\ I\ E\^\(I\ t\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
          \[CapitalOmega]\)\/\(\[Omega]\^2 - \[CapitalOmega]\^2\) + 
      \(2\ I\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
          \[CapitalOmega]\)\/\(\(-\[Omega]\^2\) + \[CapitalOmega]\^2\) + 
      \(E\^\(\(-2\)\ I\ t\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2\)\/\(\(-\[Omega]\^2\) + 
          4\ \[CapitalOmega]\^2\) + 
      \(E\^\(2\ I\ t\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2\)\/\(\(-\[Omega]\^2\) + 
          4\ \[CapitalOmega]\^2\) - \(2\ A\ \[Delta]\ A\&_\)\/\[Omega]\^2 - 
      \(E\^\(\(-I\)\ t\ \[Omega]\)\ \[Mu]\ \((\(-I\) + 2\ t\ \[Omega])\)\ 
          A\&_\)\/\(2\ \[Omega]\) + 
      \(2\ E\^\(\(-I\)\ t\ \((\[Omega] - \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\ A\&_\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
          \[CapitalOmega]\) - 
      \(2\ E\^\(\(-I\)\ t\ \((\[Omega] + \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\ A\&_\)\/\(\[CapitalOmega]\ 
          \((2\ \[Omega] + \[CapitalOmega])\)\) + 
      \(E\^\(\(-2\)\ I\ t\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
          \[Omega]\^2\)\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Clearly, ",
  StyleBox["sol2p",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " breaks down because it contains secular terms proportional to the damping \
coefficient \[Mu]. Moreover, ",
  StyleBox["sol2p",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " breaks down when ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] 2  \[Omega]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] \[Omega]/2\)]],
  ", or ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalOmega] \[TildeTilde] 0\ \ \)\)]],
  "because they produce small-divisor terms and hence secondary resonances. \
As discussed in Section 4.2, the case ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] 2  \[Omega]\)]],
  " is called ",
  StyleBox["subharmonic resonance of order one-half ",
    FontColor->RGBColor[0, 0, 1]],
  "and the case ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] \[Omega]/2\)]],
  " is called ",
  StyleBox["superharmonic resonance of order two",
    FontColor->RGBColor[0, 0, 1]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "When \[CapitalOmega] is away from \[Omega], ",
  Cell[BoxData[
      \(TraditionalForm\`2\ \[Omega]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]/2\)]],
  ", or 0, ",
  StyleBox["sol2p",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is valid only if we rescale the damping term so that it first appears in \
the third-order equation; that is, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\&^ -> \(\[Epsilon]\^2\) \[Mu]\)]],
  ". Using this scaling, we rewrite ",
  StyleBox["eq41a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq41b = 
      \(eq41a /. \[Mu] -> \[Epsilon]\ \[Mu]\) /. \[Epsilon]\^4 -> 0\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\[Epsilon]\ \[Omega]\^2\ u\_1[t]\), "+", 
        \(\[Delta]\ \[Epsilon]\^2\ u\_1[t]\^2\), "+", 
        \(\[Alpha]\ \[Epsilon]\^3\ u\_1[t]\^3\), "+", 
        \(\[Epsilon]\^2\ \[Omega]\^2\ u\_2[t]\), "+", 
        \(2\ \[Delta]\ \[Epsilon]\^3\ u\_1[t]\ u\_2[t]\), "+", 
        \(\[Epsilon]\^3\ \[Omega]\^2\ u\_3[t]\), "+", 
        RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", "\[Mu]", " ", 
          RowBox[{
            SubsuperscriptBox["u", "1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}], "+", 
        RowBox[{"\[Epsilon]", " ", 
          RowBox[{
            SubsuperscriptBox["u", "1", "\[DoublePrime]",
              MultilineFunction->None], "[", "t", "]"}]}], "+", 
        RowBox[{\(\[Epsilon]\^2\), " ", 
          RowBox[{
            SubsuperscriptBox["u", "2", "\[DoublePrime]",
              MultilineFunction->None], "[", "t", "]"}]}], "+", 
        RowBox[{\(\[Epsilon]\^3\), " ", 
          RowBox[{
            SubsuperscriptBox["u", "3", "\[DoublePrime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], "==", 
      \(f\ \[Epsilon]\ Cos[t\ \[CapitalOmega]]\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqEpsb = 
      \(CoefficientList[Subtract\ @@\ eq41b, \[Epsilon]] == 0 // Thread\) // 
        Rest\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
          \(\(-f\)\ Cos[t\ \[CapitalOmega]]\), "+", \(\[Omega]\^2\ u\_1[t]\), 
            "+", 
            RowBox[{
              SubsuperscriptBox["u", "1", "\[DoublePrime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\[Delta]\ u\_1[t]\^2\), "+", \(\[Omega]\^2\ u\_2[t]\), "+", 
            RowBox[{
              SubsuperscriptBox["u", "2", "\[DoublePrime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\[Alpha]\ u\_1[t]\^3\), "+", \(2\ \[Delta]\ u\_1[t]\ u\_2[t]\), 
            "+", \(\[Omega]\^2\ u\_3[t]\), "+", 
            RowBox[{"2", " ", "\[Mu]", " ", 
              RowBox[{
                SubsuperscriptBox["u", "1", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{
              SubsuperscriptBox["u", "3", "\[DoublePrime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Comparing ",
  StyleBox["eqEpsb",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " to ",
  StyleBox["eqEpsa",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we immediately obtain its solution from ",
  StyleBox["sol2p",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2pNew = sol2p /. \[Mu] -> 0\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(A\^2\ E\^\(2\ I\ t\ \[Omega]\)\ \[Delta]\)\/\(3\ \[Omega]\^2\) - 
      \(2\ \[Delta]\ \[CapitalLambda]\^2\)\/\[Omega]\^2 + 
      \(2\ A\ E\^\(I\ t\ \((\[Omega] - \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
          \[CapitalOmega]\) - 
      \(2\ A\ E\^\(I\ t\ \((\[Omega] + \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\)\/\(\[CapitalOmega]\ 
          \((2\ \[Omega] + \[CapitalOmega])\)\) + 
      \(E\^\(\(-2\)\ I\ t\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2\)\/\(\(-\[Omega]\^2\) + 
          4\ \[CapitalOmega]\^2\) + 
      \(E\^\(2\ I\ t\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2\)\/\(\(-\[Omega]\^2\) + 
          4\ \[CapitalOmega]\^2\) - \(2\ A\ \[Delta]\ A\&_\)\/\[Omega]\^2 + 
      \(2\ E\^\(\(-I\)\ t\ \((\[Omega] - \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\ A\&_\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
          \[CapitalOmega]\) - 
      \(2\ E\^\(\(-I\)\ t\ \((\[Omega] + \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\ A\&_\)\/\(\[CapitalOmega]\ 
          \((2\ \[Omega] + \[CapitalOmega])\)\) + 
      \(E\^\(\(-2\)\ I\ t\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
          \[Omega]\^2\)\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Hence, the general solution of ",
  StyleBox["eqEpsb[[2]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be written as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2New = 
      u\_2 -> Function[t, 
          B\ E\^\(I\ \[Omega]\ t\) + B\&_\ E\^\(\(-I\)\ \[Omega]\ t\) + 
              sol2pNew // Evaluate]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(u\_2 \[Rule] 
      Function[t, 
        B\ E\^\(I\ t\ \[Omega]\) + 
          \(A\^2\ E\^\(2\ I\ t\ \[Omega]\)\ \[Delta]\)\/\(3\ \[Omega]\^2\) - 
          \(2\ \[Delta]\ \[CapitalLambda]\^2\)\/\[Omega]\^2 + 
          \(2\ A\ E\^\(I\ t\ \((\[Omega] - \[CapitalOmega])\)\)\ \[Delta]\ 
              \[CapitalLambda]\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
              \[CapitalOmega]\) - 
          \(2\ A\ E\^\(I\ t\ \((\[Omega] + \[CapitalOmega])\)\)\ \[Delta]\ 
              \[CapitalLambda]\)\/\(\[CapitalOmega]\ 
              \((2\ \[Omega] + \[CapitalOmega])\)\) + 
          \(E\^\(\(-2\)\ I\ t\ \[CapitalOmega]\)\ \[Delta]\ 
              \[CapitalLambda]\^2\)\/\(\(-\[Omega]\^2\) + 
              4\ \[CapitalOmega]\^2\) + 
          \(E\^\(2\ I\ t\ \[CapitalOmega]\)\ \[Delta]\ 
              \[CapitalLambda]\^2\)\/\(\(-\[Omega]\^2\) + 
              4\ \[CapitalOmega]\^2\) - 
          \(2\ A\ \[Delta]\ A\&_\)\/\[Omega]\^2 + 
          \(2\ E\^\(\(-I\)\ t\ \((\[Omega] - \[CapitalOmega])\)\)\ \[Delta]\ 
              \[CapitalLambda]\ 
              A\&_\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
              \[CapitalOmega]\) - 
          \(2\ E\^\(\(-I\)\ t\ \((\[Omega] + \[CapitalOmega])\)\)\ \[Delta]\ 
              \[CapitalLambda]\ A\&_\)\/\(\[CapitalOmega]\ 
              \((2\ \[Omega] + \[CapitalOmega])\)\) + 
          \(E\^\(\(-2\)\ I\ t\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
              \[Omega]\^2\) + E\^\(\(-I\)\ t\ \[Omega]\)\ B\&_]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " is a complex-valued constant."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["sol2New",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eqEpsb[[3]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order3Eqb = 
      \(\(\(\(u\_3\^\[DoublePrime]\)[t] + \[Omega]\^2\ u\_3[t] - #\ &\)\ /@\ 
                eqEpsb[\([3]\)] /. sol1\) /. sol2New // ExpandAll\) // Reverse
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{\(\[Omega]\^2\ u\_3[t]\), "+", 
        RowBox[{
          SubsuperscriptBox["u", "3", "\[DoublePrime]",
            MultilineFunction->None], "[", "t", "]"}]}], "==", 
      \(\(-A\^3\)\ E\^\(3\ I\ t\ \[Omega]\)\ \[Alpha] - 
        2\ A\ B\ E\^\(2\ I\ t\ \[Omega]\)\ \[Delta] + 
        3\ A\^2\ E\^\(2\ I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
          \[CapitalLambda] + 
        3\ A\^2\ E\^\(2\ I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
          \[CapitalLambda] + 
        2\ B\ E\^\(I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda] + 
        2\ B\ E\^\(I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda] - 
        6\ A\ E\^\(I\ t\ \[Omega]\)\ \[Alpha]\ \[CapitalLambda]\^2 - 
        3\ A\ E\^\(I\ t\ \[Omega] - 2\ I\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
          \[CapitalLambda]\^2 - 
        3\ A\ E\^\(I\ t\ \[Omega] + 2\ I\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
          \[CapitalLambda]\^2 + 
        3\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Alpha]\ \[CapitalLambda]\^3 + 
        3\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Alpha]\ \[CapitalLambda]\^3 + 
        E\^\(\(-3\)\ I\ t\ \[CapitalOmega]\)\ \[Alpha]\ \[CapitalLambda]\^3 + 
        E\^\(3\ I\ t\ \[CapitalOmega]\)\ \[Alpha]\ \[CapitalLambda]\^3 - 
        \(2\ A\^3\ E\^\(3\ I\ t\ \[Omega]\)\ \[Delta]\^2\)\/\(3\ 
            \[Omega]\^2\) + 
        \(2\ A\^2\ E\^\(2\ I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ 
            \[Delta]\^2\ \[CapitalLambda]\)\/\(3\ \[Omega]\^2\) + 
        \(2\ A\^2\ E\^\(2\ I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ 
            \[Delta]\^2\ \[CapitalLambda]\)\/\(3\ \[Omega]\^2\) + 
        \(4\ A\ E\^\(I\ t\ \[Omega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^2\)\/\[Omega]\^2 - 
        \(4\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^3\)\/\[Omega]\^2 - 
        \(4\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^3\)\/\[Omega]\^2 - 
        2\ I\ A\ E\^\(I\ t\ \[Omega]\)\ \[Mu]\ \[Omega] - 
        2\ I\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
          \[CapitalOmega] + 
        2\ I\ E\^\(I\ t\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
          \[CapitalOmega] - 
        \(4\ A\^2\ E\^\(2\ I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ 
            \[Delta]\^2\ \[CapitalLambda]\)\/\(2\ \[Omega]\ \[CapitalOmega] - 
            \[CapitalOmega]\^2\) + 
        \(4\ A\ E\^\(I\ t\ \[Omega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^2\)\/\(2\ \[Omega]\ \[CapitalOmega] - 
            \[CapitalOmega]\^2\) + 
        \(4\ A\ E\^\(I\ t\ \[Omega] - 2\ I\ t\ \[CapitalOmega]\)\ 
            \[Delta]\^2\ 
            \[CapitalLambda]\^2\)\/\(2\ \[Omega]\ \[CapitalOmega] - 
            \[CapitalOmega]\^2\) + 
        \(4\ A\^2\ E\^\(2\ I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ 
            \[Delta]\^2\ \[CapitalLambda]\)\/\(2\ \[Omega]\ \[CapitalOmega] + 
            \[CapitalOmega]\^2\) - 
        \(4\ A\ E\^\(I\ t\ \[Omega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^2\)\/\(2\ \[Omega]\ \[CapitalOmega] + 
            \[CapitalOmega]\^2\) - 
        \(4\ A\ E\^\(I\ t\ \[Omega] + 2\ I\ t\ \[CapitalOmega]\)\ 
            \[Delta]\^2\ 
            \[CapitalLambda]\^2\)\/\(2\ \[Omega]\ \[CapitalOmega] + 
            \[CapitalOmega]\^2\) - 
        \(2\ A\ E\^\(I\ t\ \[Omega] + 2\ I\ t\ \[CapitalOmega]\)\ 
            \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(\(-\[Omega]\^2\) + 
            4\ \[CapitalOmega]\^2\) + 
        \(2\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^3\)\/\(\(-\[Omega]\^2\) + 
            4\ \[CapitalOmega]\^2\) + 
        \(2\ E\^\(3\ I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^3\)\/\(\(-\[Omega]\^2\) + 
            4\ \[CapitalOmega]\^2\) - 
        \(2\ A\ E\^\(I\ t\ \[Omega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^2\)\/\(\(-E\^\(2\ I\ t\ \[CapitalOmega]\)\)\ 
              \[Omega]\^2 + 
            4\ E\^\(2\ I\ t\ \[CapitalOmega]\)\ \[CapitalOmega]\^2\) + 
        \(2\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^3\)\/\(\(-E\^\(2\ I\ t\ \[CapitalOmega]\)\)\ 
              \[Omega]\^2 + 
            4\ E\^\(2\ I\ t\ \[CapitalOmega]\)\ \[CapitalOmega]\^2\) + 
        \(2\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^3\)\/\(\(-E\^\(2\ I\ t\ \[CapitalOmega]\)\)\ 
              \[Omega]\^2 + 
            4\ E\^\(2\ I\ t\ \[CapitalOmega]\)\ \[CapitalOmega]\^2\) - 
        3\ A\^2\ E\^\(I\ t\ \[Omega]\)\ \[Alpha]\ A\&_ - 
        2\ B\ \[Delta]\ A\&_ + 
        6\ A\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Alpha]\ \[CapitalLambda]\ 
          A\&_ + 6\ A\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
          \[CapitalLambda]\ A\&_ - 
        6\ E\^\(\(-I\)\ t\ \[Omega]\)\ \[Alpha]\ \[CapitalLambda]\^2\ A\&_ - 
        3\ E\^\(\(-I\)\ t\ \[Omega] - 2\ I\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
          \[CapitalLambda]\^2\ A\&_ - 
        3\ E\^\(\(-I\)\ t\ \[Omega] + 2\ I\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
          \[CapitalLambda]\^2\ A\&_ + 
        \(10\ A\^2\ E\^\(I\ t\ \[Omega]\)\ \[Delta]\^2\ A\&_\)\/\(3\ 
            \[Omega]\^2\) - 
        \(4\ A\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\ A\&_\)\/\[Omega]\^2 - 
        \(4\ A\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ \[CapitalLambda]\ 
            A\&_\)\/\[Omega]\^2 + 
        \(4\ E\^\(\(-I\)\ t\ \[Omega]\)\ \[Delta]\^2\ \[CapitalLambda]\^2\ 
            A\&_\)\/\[Omega]\^2 + 
        2\ I\ E\^\(\(-I\)\ t\ \[Omega]\)\ \[Mu]\ \[Omega]\ A\&_ - 
        \(4\ A\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\ A\&_\)\/\(2\ \[Omega]\ \[CapitalOmega] - 
            \[CapitalOmega]\^2\) + 
        \(4\ A\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ \[CapitalLambda]\ 
            A\&_\)\/\(2\ \[Omega]\ \[CapitalOmega] + \[CapitalOmega]\^2\) - 
        \(2\ E\^\(\(-I\)\ t\ \[Omega] + 2\ I\ t\ \[CapitalOmega]\)\ 
            \[Delta]\^2\ \[CapitalLambda]\^2\ A\&_\)\/\(\(-\[Omega]\^2\) + 
            4\ \[CapitalOmega]\^2\) - 
        \(2\ E\^\(\(-I\)\ t\ \[Omega]\)\ \[Delta]\^2\ \[CapitalLambda]\^2\ 
            A\&_\)\/\(\(-E\^\(2\ I\ t\ \[CapitalOmega]\)\)\ \[Omega]\^2 + 
            4\ E\^\(2\ I\ t\ \[CapitalOmega]\)\ \[CapitalOmega]\^2\) - 
        \(4\ A\ E\^\(I\ t\ \[Omega]\)\ \[Delta]\^2\ \[CapitalLambda]\ 
            A\&_\)\/\(2\ E\^\(I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ 
              \[Omega]\ \[CapitalOmega] - 
            E\^\(I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ 
              \[CapitalOmega]\^2\) + 
        \(4\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^2\ 
            A\&_\)\/\(2\ E\^\(I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ 
              \[Omega]\ \[CapitalOmega] - 
            E\^\(I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ 
              \[CapitalOmega]\^2\) + 
        \(4\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ \[CapitalLambda]\^2\ 
            A\&_\)\/\(2\ E\^\(I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ 
              \[Omega]\ \[CapitalOmega] - 
            E\^\(I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ 
              \[CapitalOmega]\^2\) + 
        \(4\ A\ E\^\(I\ t\ \[Omega]\)\ \[Delta]\^2\ \[CapitalLambda]\ 
            A\&_\)\/\(2\ E\^\(I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ 
              \[Omega]\ \[CapitalOmega] + 
            E\^\(I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ 
              \[CapitalOmega]\^2\) - 
        \(4\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^2\ 
            A\&_\)\/\(2\ E\^\(I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ 
              \[Omega]\ \[CapitalOmega] + 
            E\^\(I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ 
              \[CapitalOmega]\^2\) - 
        \(4\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ \[CapitalLambda]\^2\ 
            A\&_\)\/\(2\ E\^\(I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ 
              \[Omega]\ \[CapitalOmega] + 
            E\^\(I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ 
              \[CapitalOmega]\^2\) - 
        3\ A\ E\^\(\(-I\)\ t\ \[Omega]\)\ \[Alpha]\ A\&_\^2 + 
        3\ E\^\(\(-2\)\ I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
          \[CapitalLambda]\ A\&_\^2 + 
        3\ E\^\(\(-2\)\ I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
          \[CapitalLambda]\ A\&_\^2 + 
        \(10\ A\ E\^\(\(-I\)\ t\ \[Omega]\)\ \[Delta]\^2\ A\&_\^2\)\/\(3\ 
            \[Omega]\^2\) + 
        \(2\ E\^\(\(-2\)\ I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ 
            \[Delta]\^2\ \[CapitalLambda]\ A\&_\^2\)\/\(3\ \[Omega]\^2\) + 
        \(2\ E\^\(\(-2\)\ I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ 
            \[Delta]\^2\ \[CapitalLambda]\ A\&_\^2\)\/\(3\ \[Omega]\^2\) - 
        \(4\ E\^\(\(-I\)\ t\ \[Omega]\)\ \[Delta]\^2\ \[CapitalLambda]\ 
            A\&_\^2\)\/\(2\ E\^\(I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ 
              \[Omega]\ \[CapitalOmega] - 
            E\^\(I\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ 
              \[CapitalOmega]\^2\) + 
        \(4\ E\^\(\(-I\)\ t\ \[Omega]\)\ \[Delta]\^2\ \[CapitalLambda]\ 
            A\&_\^2\)\/\(2\ E\^\(I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ 
              \[Omega]\ \[CapitalOmega] + 
            E\^\(I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ 
              \[CapitalOmega]\^2\) - 
        E\^\(\(-3\)\ I\ t\ \[Omega]\)\ \[Alpha]\ A\&_\^3 - 
        \(2\ E\^\(\(-3\)\ I\ t\ \[Omega]\)\ \[Delta]\^2\ A\&_\^3\)\/\(3\ 
            \[Omega]\^2\) - 2\ A\ \[Delta]\ B\&_ + 
        2\ E\^\(\(-I\)\ t\ \[Omega] - I\ t\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\ B\&_ + 
        2\ E\^\(\(-I\)\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\ B\&_ - 
        2\ E\^\(\(-2\)\ I\ t\ \[Omega]\)\ \[Delta]\ A\&_\ B\&_\)}]], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The particular solution of ",
  StyleBox["order3Eqb",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is given by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((sol3p = 
          \(\((\(\(u\_3[t] /. 
                        \(DSolve[order3Eqb[\([1]\)] == #, u\_3[t], t]\)[
                          \([1]\)]\) /. C[_] -> 0 // TrigToExp\) // Simplify)
                \)\ &\)\ /@\ order3Eqb[\([2]\)])\) // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({64.8029999999998906`\ Second, 
      \(A\^3\ E\^\(3\ I\ t\ \[Omega]\)\ \[Delta]\^2\)\/\(12\ \[Omega]\^4\) + 
        \(A\^3\ E\^\(3\ I\ t\ \[Omega]\)\ \[Alpha]\)\/\(8\ \[Omega]\^2\) + 
        \(2\ A\ B\ E\^\(2\ I\ t\ \[Omega]\)\ \[Delta]\)\/\(3\ \[Omega]\^2\) + 
        \(A\ E\^\(I\ t\ \[Omega]\)\ \[Delta]\^2\ \[CapitalLambda]\^2\ 
            \((1 - 2\ I\ t\ \[Omega])\)\)\/\[Omega]\^4 + 
        \(3\ I\ A\ E\^\(I\ t\ \[Omega]\)\ \[Alpha]\ \[CapitalLambda]\^2\ 
            \((I + 2\ t\ \[Omega])\)\)\/\(2\ \[Omega]\^2\) - 
        \(A\ E\^\(I\ t\ \[Omega]\)\ \[Mu]\ \((I + 2\ t\ \[Omega])\)\)\/\(2\ 
            \[Omega]\) - 
        \(3\ A\ E\^\(I\ t\ \((\[Omega] - 2\ \[CapitalOmega])\)\)\ \[Alpha]\ 
            \[CapitalLambda]\^2\)\/\(4\ \((\[Omega] - \[CapitalOmega])\)\ 
            \[CapitalOmega]\) + 
        \(2\ B\ E\^\(I\ t\ \((\[Omega] - \[CapitalOmega])\)\)\ \[Delta]\ 
            \[CapitalLambda]\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
            \[CapitalOmega]\) + 
        \(A\ E\^\(I\ t\ \[Omega]\)\ \[Delta]\^2\ \[CapitalLambda]\^2\ 
            \((1 - 2\ I\ t\ \[Omega])\)\)\/\(\[Omega]\^2\ 
            \((2\ \[Omega] - \[CapitalOmega])\)\ \[CapitalOmega]\) + 
        \(3\ A\ E\^\(I\ t\ \((\[Omega] + 2\ \[CapitalOmega])\)\)\ \[Alpha]\ 
            \[CapitalLambda]\^2\)\/\(4\ \[CapitalOmega]\ 
            \((\[Omega] + \[CapitalOmega])\)\) - 
        \(2\ B\ E\^\(I\ t\ \((\[Omega] + \[CapitalOmega])\)\)\ \[Delta]\ 
            \[CapitalLambda]\)\/\(\[CapitalOmega]\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\) + 
        \(I\ A\ E\^\(I\ t\ \[Omega]\)\ \[Delta]\^2\ \[CapitalLambda]\^2\ 
            \((I + 2\ t\ \[Omega])\)\)\/\(\[Omega]\^2\ \[CapitalOmega]\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\) + 
        \(A\ E\^\(I\ t\ \((\[Omega] + 2\ \[CapitalOmega])\)\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^2\)\/\(\[CapitalOmega]\^2\ 
            \((\[Omega] + \[CapitalOmega])\)\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\) - 
        \(3\ A\^2\ E\^\(I\ t\ \((2\ \[Omega] + \[CapitalOmega])\)\)\ 
            \[Alpha]\ \[CapitalLambda]\)\/\(\((\[Omega] + \[CapitalOmega])\)\ 
            \((3\ \[Omega] + \[CapitalOmega])\)\) - 
        \(2\ A\^2\ E\^\(I\ t\ \((2\ \[Omega] + \[CapitalOmega])\)\)\ 
            \[Delta]\^2\ \[CapitalLambda]\)\/\(3\ \[Omega]\^2\ 
            \((\[Omega] + \[CapitalOmega])\)\ 
            \((3\ \[Omega] + \[CapitalOmega])\)\) - 
        \(4\ A\^2\ E\^\(I\ t\ \((2\ \[Omega] + \[CapitalOmega])\)\)\ 
            \[Delta]\^2\ \[CapitalLambda]\)\/\(\[CapitalOmega]\ 
            \((\[Omega] + \[CapitalOmega])\)\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\ 
            \((3\ \[Omega] + \[CapitalOmega])\)\) + 
        \(E\^\(\(-3\)\ I\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
            \[CapitalLambda]\^3\)\/\(\[Omega]\^2 - 9\ \[CapitalOmega]\^2\) + 
        \(E\^\(3\ I\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
            \[CapitalLambda]\^3\)\/\(\[Omega]\^2 - 9\ \[CapitalOmega]\^2\) + 
        \(A\ E\^\(I\ t\ \((\[Omega] - 2\ \[CapitalOmega])\)\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^2\)\/\(2\ \((\[Omega] - \[CapitalOmega])\)\ 
            \[CapitalOmega]\ \((\[Omega]\^2 - 4\ \[CapitalOmega]\^2)\)\) - 
        \(A\ E\^\(I\ t\ \((\[Omega] + 2\ \[CapitalOmega])\)\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^2\)\/\(2\ \[CapitalOmega]\ 
            \((\[Omega] + \[CapitalOmega])\)\ 
            \((\[Omega]\^2 - 4\ \[CapitalOmega]\^2)\)\) + 
        \(3\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
            \[CapitalLambda]\^3\)\/\(\[Omega]\^2 - \[CapitalOmega]\^2\) + 
        \(3\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
            \[CapitalLambda]\^3\)\/\(\[Omega]\^2 - \[CapitalOmega]\^2\) + 
        \(2\ I\ E\^\(I\ t\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
            \[CapitalOmega]\)\/\(\[Omega]\^2 - \[CapitalOmega]\^2\) + 
        \(4\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^3\)\/\(\[Omega]\^2\ 
            \((\(-\[Omega]\^2\) + \[CapitalOmega]\^2)\)\) + 
        \(4\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^3\)\/\(\[Omega]\^2\ 
            \((\(-\[Omega]\^2\) + \[CapitalOmega]\^2)\)\) + 
        \(2\ I\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
            \[CapitalOmega]\)\/\(\(-\[Omega]\^2\) + \[CapitalOmega]\^2\) - 
        \(3\ A\^2\ E\^\(I\ t\ \((2\ \[Omega] - \[CapitalOmega])\)\)\ 
            \[Alpha]\ \[CapitalLambda]\)\/\(3\ \[Omega]\^2 - 
            4\ \[Omega]\ \[CapitalOmega] + \[CapitalOmega]\^2\) - 
        \(2\ A\^2\ E\^\(I\ t\ \((2\ \[Omega] - \[CapitalOmega])\)\)\ 
            \[Delta]\^2\ \[CapitalLambda]\)\/\(3\ \[Omega]\^2\ 
            \((3\ \[Omega]\^2 - 4\ \[Omega]\ \[CapitalOmega] + 
                \[CapitalOmega]\^2)\)\) + 
        \(A\ E\^\(I\ t\ \((\[Omega] - 2\ \[CapitalOmega])\)\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^2\)\/\(\[CapitalOmega]\^2\ 
            \((2\ \[Omega]\^2 - 3\ \[Omega]\ \[CapitalOmega] + 
                \[CapitalOmega]\^2)\)\) - 
        \(4\ A\^2\ E\^\(I\ t\ \((2\ \[Omega] - \[CapitalOmega])\)\)\ 
            \[Delta]\^2\ \[CapitalLambda]\)\/\(\[CapitalOmega]\ 
            \((\(-6\)\ \[Omega]\^3 + 11\ \[Omega]\^2\ \[CapitalOmega] - 
                6\ \[Omega]\ \[CapitalOmega]\^2 + \[CapitalOmega]\^3)\)\) - 
        \(2\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^3\)\/\(\[Omega]\^4 - 
            5\ \[Omega]\^2\ \[CapitalOmega]\^2 + 4\ \[CapitalOmega]\^4\) - 
        \(2\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^3\)\/\(\[Omega]\^4 - 
            5\ \[Omega]\^2\ \[CapitalOmega]\^2 + 4\ \[CapitalOmega]\^4\) - 
        \(2\ E\^\(\(-3\)\ I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^3\)\/\(\[Omega]\^4 - 
            13\ \[Omega]\^2\ \[CapitalOmega]\^2 + 36\ \[CapitalOmega]\^4\) - 
        \(2\ E\^\(3\ I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^3\)\/\(\[Omega]\^4 - 
            13\ \[Omega]\^2\ \[CapitalOmega]\^2 + 36\ \[CapitalOmega]\^4\) - 
        \(2\ B\ \[Delta]\ A\&_\)\/\[Omega]\^2 + 
        \(5\ A\^2\ E\^\(I\ t\ \[Omega]\)\ \[Delta]\^2\ 
            \((1 - 2\ I\ t\ \[Omega])\)\ A\&_\)\/\(6\ \[Omega]\^4\) + 
        \(E\^\(\(-I\)\ t\ \[Omega]\)\ \[Delta]\^2\ \[CapitalLambda]\^2\ 
            \((1 + 2\ I\ t\ \[Omega])\)\ A\&_\)\/\[Omega]\^4 - 
        \(3\ I\ E\^\(\(-I\)\ t\ \[Omega]\)\ \[Alpha]\ \[CapitalLambda]\^2\ 
            \((\(-I\) + 2\ t\ \[Omega])\)\ A\&_\)\/\(2\ \[Omega]\^2\) - 
        \(E\^\(\(-I\)\ t\ \[Omega]\)\ \[Mu]\ \((\(-I\) + 2\ t\ \[Omega])\)\ 
            A\&_\)\/\(2\ \[Omega]\) + 
        \(3\ I\ A\^2\ E\^\(I\ t\ \[Omega]\)\ \[Alpha]\ 
            \((I + 2\ t\ \[Omega])\)\ A\&_\)\/\(4\ \[Omega]\^2\) + 
        \(E\^\(\(-I\)\ t\ \[Omega]\)\ \[Delta]\^2\ \[CapitalLambda]\^2\ 
            \((1 + 2\ I\ t\ \[Omega])\)\ A\&_\)\/\(\[Omega]\^2\ 
            \((2\ \[Omega] - \[CapitalOmega])\)\ \[CapitalOmega]\) + 
        \(3\ E\^\(\(-I\)\ t\ \((\[Omega] + 2\ \[CapitalOmega])\)\)\ \[Alpha]\ 
            \[CapitalLambda]\^2\ A\&_\)\/\(4\ \[CapitalOmega]\ 
            \((\[Omega] + \[CapitalOmega])\)\) - 
        \(4\ A\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\ A\&_\)\/\(\[CapitalOmega]\ 
            \((\(-2\)\ \[Omega] + \[CapitalOmega])\)\ 
            \((\(-\[Omega]\) + \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\) - 
        \(4\ A\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ \[CapitalLambda]\ 
            A\&_\)\/\(\[CapitalOmega]\ 
            \((\(-2\)\ \[Omega] + \[CapitalOmega])\)\ 
            \((\(-\[Omega]\) + \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\) - 
        \(I\ E\^\(\(-I\)\ t\ \[Omega]\)\ \[Delta]\^2\ \[CapitalLambda]\^2\ 
            \((\(-I\) + 2\ t\ \[Omega])\)\ A\&_\)\/\(\[Omega]\^2\ 
            \[CapitalOmega]\ \((2\ \[Omega] + \[CapitalOmega])\)\) + 
        \(E\^\(\(-I\)\ t\ \((\[Omega] + 2\ \[CapitalOmega])\)\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^2\ A\&_\)\/\(\[CapitalOmega]\^2\ 
            \((\[Omega] + \[CapitalOmega])\)\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\) - 
        \(4\ A\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\ A\&_\)\/\(\[CapitalOmega]\ 
            \((\(-\[Omega]\) + \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\) - 
        \(4\ A\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ \[CapitalLambda]\ 
            A\&_\)\/\(\[CapitalOmega]\ \((\(-\[Omega]\) + \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\) + 
        \(E\^\(\(-I\)\ t\ \((\[Omega] - 2\ \[CapitalOmega])\)\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^2\ A\&_\)\/\(2\ 
            \((\[Omega] - \[CapitalOmega])\)\ \[CapitalOmega]\ 
            \((\[Omega]\^2 - 4\ \[CapitalOmega]\^2)\)\) - 
        \(E\^\(\(-I\)\ t\ \((\[Omega] + 2\ \[CapitalOmega])\)\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^2\ A\&_\)\/\(2\ \[CapitalOmega]\ 
            \((\[Omega] + \[CapitalOmega])\)\ 
            \((\[Omega]\^2 - 4\ \[CapitalOmega]\^2)\)\) + 
        \(6\ A\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
            \[CapitalLambda]\ A\&_\)\/\(\[Omega]\^2 - \[CapitalOmega]\^2\) + 
        \(6\ A\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Alpha]\ \[CapitalLambda]\ 
            A\&_\)\/\(\[Omega]\^2 - \[CapitalOmega]\^2\) + 
        \(4\ A\ E\^\(\(-I\)\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ 
            \[CapitalLambda]\ A\&_\)\/\(\[Omega]\^2\ 
            \((\(-\[Omega]\^2\) + \[CapitalOmega]\^2)\)\) + 
        \(4\ A\ E\^\(I\ t\ \[CapitalOmega]\)\ \[Delta]\^2\ \[CapitalLambda]\ 
            A\&_\)\/\(\[Omega]\^2\ 
            \((\(-\[Omega]\^2\) + \[CapitalOmega]\^2)\)\) + 
        \(E\^\(\(-I\)\ t\ \((\[Omega] - 2\ \[CapitalOmega])\)\)\ \[Delta]\^2\ 
            \[CapitalLambda]\^2\ A\&_\)\/\(\[CapitalOmega]\^2\ 
            \((2\ \[Omega]\^2 - 3\ \[Omega]\ \[CapitalOmega] + 
                \[CapitalOmega]\^2)\)\) + 
        \(3\ E\^\(\(-I\)\ t\ \[Omega] + 2\ I\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
            \[CapitalLambda]\^2\ 
            A\&_\)\/\(\(-4\)\ \[Omega]\ \[CapitalOmega] + 
            4\ \[CapitalOmega]\^2\) + 
        \(5\ A\ E\^\(\(-I\)\ t\ \[Omega]\)\ \[Delta]\^2\ 
            \((1 + 2\ I\ t\ \[Omega])\)\ A\&_\^2\)\/\(6\ \[Omega]\^4\) - 
        \(3\ I\ A\ E\^\(\(-I\)\ t\ \[Omega]\)\ \[Alpha]\ 
            \((\(-I\) + 2\ t\ \[Omega])\)\ A\&_\^2\)\/\(4\ \[Omega]\^2\) - 
        \(3\ E\^\(\(-I\)\ t\ \((2\ \[Omega] + \[CapitalOmega])\)\)\ \[Alpha]\ 
            \[CapitalLambda]\ A\&_\^2\)\/\(\((\[Omega] + \[CapitalOmega])\)\ 
            \((3\ \[Omega] + \[CapitalOmega])\)\) - 
        \(2\ E\^\(\(-I\)\ t\ \((2\ \[Omega] + \[CapitalOmega])\)\)\ 
            \[Delta]\^2\ \[CapitalLambda]\ A\&_\^2\)\/\(3\ \[Omega]\^2\ 
            \((\[Omega] + \[CapitalOmega])\)\ 
            \((3\ \[Omega] + \[CapitalOmega])\)\) - 
        \(4\ E\^\(\(-I\)\ t\ \((2\ \[Omega] + \[CapitalOmega])\)\)\ 
            \[Delta]\^2\ \[CapitalLambda]\ A\&_\^2\)\/\(\[CapitalOmega]\ 
            \((\[Omega] + \[CapitalOmega])\)\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\ 
            \((3\ \[Omega] + \[CapitalOmega])\)\) - 
        \(3\ E\^\(\(-2\)\ I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ \[Alpha]\ 
            \[CapitalLambda]\ A\&_\^2\)\/\(3\ \[Omega]\^2 - 
            4\ \[Omega]\ \[CapitalOmega] + \[CapitalOmega]\^2\) - 
        \(2\ E\^\(\(-2\)\ I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ 
            \[Delta]\^2\ \[CapitalLambda]\ A\&_\^2\)\/\(3\ \[Omega]\^2\ 
            \((3\ \[Omega]\^2 - 4\ \[Omega]\ \[CapitalOmega] + 
                \[CapitalOmega]\^2)\)\) - 
        \(4\ E\^\(\(-2\)\ I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ 
            \[Delta]\^2\ \[CapitalLambda]\ A\&_\^2\)\/\(\[CapitalOmega]\ 
            \((\(-6\)\ \[Omega]\^3 + 11\ \[Omega]\^2\ \[CapitalOmega] - 
                6\ \[Omega]\ \[CapitalOmega]\^2 + \[CapitalOmega]\^3)\)\) + 
        \(E\^\(\(-3\)\ I\ t\ \[Omega]\)\ \[Delta]\^2\ A\&_\^3\)\/\(12\ 
            \[Omega]\^4\) + 
        \(E\^\(\(-3\)\ I\ t\ \[Omega]\)\ \[Alpha]\ A\&_\^3\)\/\(8\ 
            \[Omega]\^2\) - \(2\ A\ \[Delta]\ B\&_\)\/\[Omega]\^2 + 
        \(2\ E\^\(\(-I\)\ t\ \((\[Omega] - \[CapitalOmega])\)\)\ \[Delta]\ 
            \[CapitalLambda]\ B\&_\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
            \[CapitalOmega]\) - 
        \(2\ E\^\(\(-I\)\ t\ \((\[Omega] + \[CapitalOmega])\)\)\ \[Delta]\ 
            \[CapitalLambda]\ B\&_\)\/\(\[CapitalOmega]\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\) + 
        \(2\ E\^\(\(-2\)\ I\ t\ \[Omega]\)\ \[Delta]\ A\&_\ B\&_\)\/\(3\ 
            \[Omega]\^2\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Clearly, ",
  StyleBox["sol3p",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " breaks down because it contains secular terms and small-divisor terms \
when ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] \[Omega]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] 0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] 2  \[Omega]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] \[Omega]/2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] 3  \[Omega]\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] \[Omega]/3\)]],
  ". As shown in the next section, the small-divisor terms arising from ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] 3  \[Omega]\)]],
  " produce a",
  StyleBox[" subharmonic reosonance of order one-third",
    FontColor->RGBColor[0, 0, 1]],
  " and those arising from ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] \[TildeTilde] \[Omega]/3\)]],
  " produce a ",
  StyleBox["superharmonic resonance of order three",
    FontColor->RGBColor[0, 0, 1]],
  ". Carrying out the expansion to higher order, one finds that other \
resonances may occur."
}], "Text",
  CellMargins->{{13, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
We note that the resonances that occur depend on the order of the \
nonlinearity. Quadratic nonlinearities produce (a) subharmonic resonances of \
order one-half and superharmonic resonances of order two at second order and \
(b) subharmonic resonances of order one-third and superharmonic resonances of \
order three at third order. On the other hand, cubic nonlinearities produce \
subharmonic resonances of order one-third and superharmonic resonances of \
order three at third order. For a given system and order of approximation, \
the resonances produced can be easily identified by carrying out a \
straightforward expansion as done above.\
\>", "Text",
  CellMargins->{{13, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In the next three sections, we use the method of multiple scales, \
generalized method of averaging, and method of normal forms to determine \
second-order uniform expansions for the solutions of ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " that do not contain secular or small-divisor terms."
}], "Text",
  CellMargins->{{13, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.2 The Method of Multiple Scales", "Section",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["4.2.1 Preliminaries", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
For a uniform second-order expansion, we need three time scales, which we \
symbolize and list as follows:\
\>", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Needs["\<Utilities`Notation`\>"]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"Symbolize", "[", 
        TagBox[\(T\_0\),
          NotationBoxTag,
          Editable->True], "]"}], ";", 
      RowBox[{"Symbolize", "[", 
        TagBox[\(T\_1\),
          NotationBoxTag,
          Editable->True], "]"}], ";", 
      RowBox[{"Symbolize", "[", 
        TagBox[\(T\_2\),
          NotationBoxTag,
          Editable->True], "]"}], ";"}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(timeScales = {T\_0, T\_1, T\_2}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
The maximum order of the expansion is related, in general, to the number of \
time scales by \
\>", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(maxOrder = Length[timeScales] - 1; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In what follows, we need the complex conjugates of ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ", \[Zeta], and \[CapitalGamma], which we define by"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(conjugateRule = {Complex[0, n_] -> Complex[0, \(-n\)], A -> A\&_, 
        A\&_ -> A, \[Zeta] -> \[Zeta]\&_, \[Zeta]\&_ -> \[Zeta], 
        \[CapitalGamma] -> \[CapitalGamma]\&_, 
        \[CapitalGamma]\&_ -> \[CapitalGamma]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In terms of the time scales ",
  Cell[BoxData[
      \(TraditionalForm\`T\_n\)]],
  ", the time derivatives become"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(\ \(dt[1]\)[expr_] := 
      Sum[\[Epsilon]\^i\ D[expr, timeScales[\([i + 1]\)]], {i, 0, maxOrder}]; 
    \n\ \(dt[2]\)[expr_] := 
      \((\(dt[1]\)[\(dt[1]\)[expr]] // Expand)\) /. 
        \[Epsilon]\^\(i_ /; i > maxOrder\) -> 0; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
To represent some of the expressions in a more concise way, we introduce the \
following display rule:\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(displayRule = {
        \(\(Derivative[a__]\)[\[Zeta]_\_i_]\)[__] :> 
          SequenceForm[
            Times\ @@\ MapIndexed[D\_\(#2[\([1]\)] - 1\)\%#1\ &, {a}], 
            \[Zeta]\_i], 
        \(\(Derivative[a__]\)[A]\)[__] :> 
          SequenceForm[Times\ @@\ MapIndexed[D\_\(#2[\([1]\)]\)\%#1\ &, {a}], 
            A], \(\(Derivative[a__]\)[A\&_]\)[__] :> 
          SequenceForm[Times\ @@\ MapIndexed[D\_\(#2[\([1]\)]\)\%#1\ &, {a}], 
            A\&_], \[Zeta]_\_i_[__] -> \[Zeta]\_i, A[__] -> A, 
        A\&_[__] -> A\&_}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using the time scales ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0, T\_1, \)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2\)]],
  ", we transform ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " from an ordinary-differential equation into a partial-differential \
equation according to the rule"
}], "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(multiScalesRule = {u[t] -> u[T\_0, T\_1, T\_2], 
        \(\(Derivative[n_]\)[u]\)[t] :> \(dt[n]\)[u[T\_0, T\_1, T\_2]], 
        t -> T\_0}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We seek a second-order uniform expansion of the solution of ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(solRule = 
      u -> \((Sum[\[Epsilon]\^i\ u\_i[#1, #2, #3], {i, maxOrder + 1}]\ &)\); 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
For a uniform expansion, we need to eliminate the secular and small-divisor \
terms. To accomplish this, we need to distinguish between primary and \
secondary resonances. They are treated separately beginning with the case of \
primary resonance.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.2.2 Primary Resonance", "Subsection",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[TextData[{
  "We scale the damping ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\&^\)]],
  " and forcing ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " so that the damping term and resonance terms appear at the same order at \
which the secular and / or small-divisor terms generated by the \
nonlinearities appear. In this case, they appear at order ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Epsilon]\^3, \)\)]],
  " and hence we scale the forcing and damping as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[BoxData[
    \(\(scaling = {F -> \[Epsilon]\^3\ f, \[Mu]\&^ -> \[Epsilon]\^2\ \[Mu]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[TextData[{
  "Substituting the ",
  StyleBox["solRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", using the ",
  StyleBox["scaling",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["multiScalesRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expanding the result for small \[Epsilon], and discarding terms of order \
higher than ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\^3\)]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq422a = 
      \((\(\(FDuffingEq /. scaling\) /. multiScalesRule\) /. solRule // 
            ExpandAll)\) /. \[Epsilon]\^\(n_ /; n > maxOrder + 1\) -> 0; \n
    eq422a /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", "\[Mu]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        RowBox[{"\[Epsilon]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        RowBox[{\(\[Epsilon]\^2\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_2\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 2]],
              Editable->False], ")"}]}], "+", 
        RowBox[{\(\[Epsilon]\^3\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_3\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 3]],
              Editable->False], ")"}]}], "+", 
        RowBox[{"2", " ", \(\[Epsilon]\^2\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(\(D\_0\ D\_1\)\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(\(D\_0\ D\_1\)\[InvisibleSpace]u\_2\),
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 2]],
              Editable->False], ")"}]}], "+", 
        RowBox[{\(\[Epsilon]\^3\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\%2\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 1], 2], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(\(D\_0\ D\_2\)\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 2]], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        \(\[Epsilon]\ \[Omega]\^2\ u\_1\), "+", 
        \(\[Delta]\ \[Epsilon]\^2\ u\_1\%2\), "+", 
        \(\[Alpha]\ \[Epsilon]\^3\ u\_1\%3\), "+", 
        \(\[Epsilon]\^2\ \[Omega]\^2\ u\_2\), "+", 
        \(2\ \[Delta]\ \[Epsilon]\^3\ u\_1\ u\_2\), "+", 
        \(\[Epsilon]\^3\ \[Omega]\^2\ u\_3\)}], "==", 
      \(f\ \[Epsilon]\^3\ Cos[T\_0\ \[CapitalOmega]]\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Equating coefficients of like powers of \[Epsilon] in ",
  StyleBox["eq422a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[BoxData[
    \(\(eqEps = 
      \(\(CoefficientList[Subtract\ @@\ eq422a, \[Epsilon]] == 0 // Thread
            \) // Rest\) // TrigToExp; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell["\<\
To place the linear operator on one side and the nonhomogeneous terms on the \
other side, we define\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(eqOrder[i_] := 
      \(\((eqEps[\([1, 1]\)] /. u\_1 -> u\_i)\) - #\ &\)\ /@\ \ 
          eqEps[\([i]\)] // Reverse\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["eqOrder[i]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and the ",
  StyleBox["displayRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we rewrite ",
  StyleBox["eqEps",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in a concise way as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[eqOrder, 3] /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 1]],
              Editable->False], "+", \(\[Omega]\^2\ u\_1\)}], "==", "0"}], 
        ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_2\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 2]],
              Editable->False], "+", \(\[Omega]\^2\ u\_2\)}], "==", 
          RowBox[{
            RowBox[{\(-2\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(\(D\_0\ D\_1\)\[InvisibleSpace]u\_1\),
                  SequenceForm[ 
                    Times[ 
                      Subscript[ D, 0], 
                      Subscript[ D, 1]], 
                    Subscript[ u, 1]],
                  Editable->False], ")"}]}], "-", \(\[Delta]\ u\_1\%2\)}]}], 
        ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_3\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 3]],
              Editable->False], "+", \(\[Omega]\^2\ u\_3\)}], "==", 
          RowBox[{
          \(1\/2\ \((
                E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\) + 
                  E\^\(I\ T\_0\ \[CapitalOmega]\))\)\ f\), "-", 
            RowBox[{"2", " ", "\[Mu]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_0\[InvisibleSpace]u\_1\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ u, 1]],
                  Editable->False], ")"}]}], "-", 
            RowBox[{"2", " ", 
              RowBox[{"(", 
                InterpretationBox[\(\(D\_0\ D\_1\)\[InvisibleSpace]u\_2\),
                  SequenceForm[ 
                    Times[ 
                      Subscript[ D, 0], 
                      Subscript[ D, 1]], 
                    Subscript[ u, 2]],
                  Editable->False], ")"}]}], "-", 
            InterpretationBox[\(D\_1\%2\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 1], 2], 
                Subscript[ u, 1]],
              Editable->False], "-", 
            RowBox[{"2", " ", 
              RowBox[{"(", 
                InterpretationBox[\(\(D\_0\ D\_2\)\[InvisibleSpace]u\_1\),
                  SequenceForm[ 
                    Times[ 
                      Subscript[ D, 0], 
                      Subscript[ D, 2]], 
                    Subscript[ u, 1]],
                  Editable->False], ")"}]}], "-", \(\[Alpha]\ u\_1\%3\), "-", 
            \(2\ \[Delta]\ u\_1\ u\_2\)}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The general solution of ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be expressed as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[BoxData[
    \(\(sol1 = 
      u\_1 -> Function[{T\_0, T\_1, T\_2}, 
          A[T\_1, T\_2]\ Exp[I\ \[Omega]\ T\_0] + 
            A\&_[T\_1, T\_2]\ Exp[\(-I\)\ \[Omega]\ T\_0]]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[TextData[{
  "Using ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we rewrite ",
  StyleBox["eqOrder[2]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eq = eqOrder[2] /. sol1 // ExpandAll; \n
    order2Eq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
        InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_2\),
          SequenceForm[ 
            Power[ 
              Subscript[ D, 0], 2], 
            Subscript[ u, 2]],
          Editable->False], "+", \(\[Omega]\^2\ u\_2\)}], "==", 
      RowBox[{
      \(\(-A\^2\)\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\), "-", 
        \(2\ A\ \[Delta]\ A\&_\), "-", 
        \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\), "-", 
        RowBox[{
        "2", " ", "I", " ", \(E\^\(I\ T\_0\ \[Omega]\)\), " ", "\[Omega]", 
          " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]A\),
              SequenceForm[ 
                Subscript[ D, 1], A],
              Editable->False], ")"}]}], "+", 
        RowBox[{
        "2", " ", "I", " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\)\), " ", 
          "\[Omega]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\),
              SequenceForm[ 
                Subscript[ D, 1], 
                OverBar[ A]],
              Editable->False], ")"}]}]}]}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Eliminating the terms that produce secular terms in ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " demands that"
}], "Text",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond1 = 
      Coefficient[order2Eq[\([2]\)], Exp[I\ \[Omega]\ T\_0]] == 0\)], "Input",\

  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[BoxData[
    RowBox[{
      RowBox[{\(-2\), " ", "I", " ", "\[Omega]", " ", 
        RowBox[{
          SuperscriptBox["A", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], "==", 
      "0"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Solving ",
  StyleBox["SCond1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 1]],
  "for ",
  Cell[BoxData[
      RowBox[{
        SuperscriptBox["A", 
          TagBox[\((1, 0)\),
            Derivative],
          MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SCond1Rule", "=", 
      RowBox[{
        RowBox[{"Solve", "[", 
          RowBox[{"SCond1", ",", 
            RowBox[{
              SuperscriptBox["A", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
          "]"}], "[", \([1]\), "]"}]}]], "Input",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox["A", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], "\[Rule]", 
        "0"}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Hence,",
  Cell[BoxData[
      \(TraditionalForm\`\(\ A = A[T\_2]\)\)]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the solvability condition into ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eqm = 
      \(order2Eq /. SCond1Rule\) /. \((SCond1Rule /. conjugateRule)\); \n
    order2Eqm /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[BoxData[
    RowBox[{
      RowBox[{
        InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_2\),
          SequenceForm[ 
            Power[ 
              Subscript[ D, 0], 2], 
            Subscript[ u, 2]],
          Editable->False], "+", \(\[Omega]\^2\ u\_2\)}], "==", 
      \(\(-A\^2\)\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta] - 
        2\ A\ \[Delta]\ A\&_ - 
        E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The particular solution of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be obtained by using ",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  "; the result is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2p = 
      \(\(DSolve[order2Eqm, u\_2\ @@\ timeScales, timeScales]\)[\([1]\)] /. 
            C[_] -> \((0\ &)\) // TrigToExp\) // ExpandAll; \n
    sol2p /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_2 \[Rule] 
        \(A\^2\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\)\/\(3\ \[Omega]\^2\) - 
          \(2\ A\ \[Delta]\ A\&_\)\/\[Omega]\^2 + 
          \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
              \[Omega]\^2\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Next, we use ",
  StyleBox["sol2p[[1,2]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " directly to express ",
  Cell[BoxData[
      \(TraditionalForm\`u\_2\)]],
  " in a pure function form as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol2 = 
      u\_2 -> Function[{T\_0, T\_1, T\_2}, sol2p[\([1, 2]\)] // Evaluate]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[TextData[{
  "Substituting the first- and second-order solutions, ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["sol2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", into the third-order equation, ",
  StyleBox["eqOrder[3]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order3Eq = \(eqOrder[3] /. sol1\) /. sol2 // ExpandAll; \n
    order3Eq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
        InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_3\),
          SequenceForm[ 
            Power[ 
              Subscript[ D, 0], 2], 
            Subscript[ u, 3]],
          Editable->False], "+", \(\[Omega]\^2\ u\_3\)}], "==", 
      RowBox[{
      \(1\/2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ f\), "+", 
        \(1\/2\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ f\), "-", 
        \(A\^3\ E\^\(3\ I\ T\_0\ \[Omega]\)\ \[Alpha]\), "-", 
        \(\(2\ A\^3\ E\^\(3\ I\ T\_0\ \[Omega]\)\ \[Delta]\^2\)\/\(3\ 
              \[Omega]\^2\)\), "-", 
        \(2\ I\ A\ E\^\(I\ T\_0\ \[Omega]\)\ \[Mu]\ \[Omega]\), "-", 
        \(3\ A\^2\ E\^\(I\ T\_0\ \[Omega]\)\ \[Alpha]\ A\&_\), "+", 
        \(\(10\ A\^2\ E\^\(I\ T\_0\ \[Omega]\)\ \[Delta]\^2\ A\&_\)\/\(3\ 
              \[Omega]\^2\)\), "+", 
        \(2\ I\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ \[Omega]\ A\&_\), "-", 
        \(3\ A\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Alpha]\ A\&_\^2\), "+", 
        \(\(10\ A\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Delta]\^2\ A\&_\^2\)\/\(3
              \ \[Omega]\^2\)\), "-", 
        \(E\^\(\(-3\)\ I\ T\_0\ \[Omega]\)\ \[Alpha]\ A\&_\^3\), "-", 
        \(\(2\ E\^\(\(-3\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\^2\ A\&_\^3\)\/\(3\ 
              \[Omega]\^2\)\), "-", 
        FractionBox[
          RowBox[{
          "8", " ", "I", " ", "A", " ", \(E\^\(2\ I\ T\_0\ \[Omega]\)\), " ", 
            "\[Delta]", " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_1\[InvisibleSpace]A\),
                SequenceForm[ 
                  Subscript[ D, 1], A],
                Editable->False], ")"}]}], \(3\ \[Omega]\)], "+", 
        FractionBox[
          RowBox[{
          "8", " ", "I", " ", \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\), " ", 
            "\[Delta]", " ", \(A\&_\), " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\),
                SequenceForm[ 
                  Subscript[ D, 1], 
                  OverBar[ A]],
                Editable->False], ")"}]}], \(3\ \[Omega]\)], "-", 
        RowBox[{\(E\^\(I\ T\_0\ \[Omega]\)\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\%2\[InvisibleSpace]A\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 1], 2], A],
              Editable->False], ")"}]}], "-", 
        RowBox[{\(E\^\(\(-I\)\ T\_0\ \[Omega]\)\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\%2\[InvisibleSpace]A\&_\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 1], 2], 
                OverBar[ A]],
              Editable->False], ")"}]}], "-", 
        RowBox[{
        "2", " ", "I", " ", \(E\^\(I\ T\_0\ \[Omega]\)\), " ", "\[Omega]", 
          " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_2\[InvisibleSpace]A\),
              SequenceForm[ 
                Subscript[ D, 2], A],
              Editable->False], ")"}]}], "+", 
        RowBox[{
        "2", " ", "I", " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\)\), " ", 
          "\[Omega]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_2\[InvisibleSpace]A\&_\),
              SequenceForm[ 
                Subscript[ D, 2], 
                OverBar[ A]],
              Editable->False], ")"}]}]}]}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "To express the nearness of \[CapitalOmega] to \[Omega], we introduce a \
detuning parameter ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma] = O(1)\)]],
  " defined by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[BoxData[
    \(\(OmgRule = {\[CapitalOmega] -> \[Omega] + \[Epsilon]\^2\ \[Sigma]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[TextData[{
  "Using the ",
  StyleBox["OmgRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we convert the small-divisor term arising from the excitation into a \
secular term. Then, eliminating the secular terms from ",
  Cell[BoxData[
      StyleBox[\(u\_3\),
        FontSlant->"Italic"]]],
  " demands that"
}], "Text",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[BoxData[
    \(\(expRule1 = 
      Exp[a_] :> Exp[Expand[a /. OmgRule] /. \[Epsilon]\^2\ T\_0 -> T\_2]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond2 = 
      Coefficient[order3Eq[\([2]\)] /. expRule1, Exp[I\ \[Omega]\ T\_0]] == 
        0; \nSCond2 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(1\/2\ E\^\(I\ T\_2\ \[Sigma]\)\ f\), "-", 
        \(2\ I\ A\ \[Mu]\ \[Omega]\), "-", \(3\ A\^2\ \[Alpha]\ A\&_\), "+", 
        \(\(10\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^2\)\), "-", 
        InterpretationBox[\(D\_1\%2\[InvisibleSpace]A\),
          SequenceForm[ 
            Power[ 
              Subscript[ D, 1], 2], A],
          Editable->False], "-", 
        RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_2\[InvisibleSpace]A\),
              SequenceForm[ 
                Subscript[ D, 2], A],
              Editable->False], ")"}]}]}], "==", "0"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Using the fact that ",
  Cell[BoxData[
      \(TraditionalForm\`\(A = A[T\_2]\ \)\)]],
  " from ",
  StyleBox["SCond1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we rewrite ",
  StyleBox["SCond2 ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond = 
      \(SCond2 /. D[SCond1Rule, T\_1]\) /. {A -> \((A[#2]\ &)\), 
          A\&_ -> \((A\&_[#2]\ &)\)}\)], "Input",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(1\/2\ E\^\(I\ T\_2\ \[Sigma]\)\ f\), "-", 
        \(2\ I\ \[Mu]\ \[Omega]\ A[T\_2]\), "-", 
        \(3\ \[Alpha]\ A[T\_2]\^2\ A\&_[T\_2]\), "+", 
        \(\(10\ \[Delta]\^2\ A[T\_2]\^2\ A\&_[T\_2]\)\/\(3\ \[Omega]\^2\)\), 
        "-", 
        RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
          RowBox[{
            SuperscriptBox["A", "\[Prime]",
              MultilineFunction->None], "[", \(T\_2\), "]"}]}]}], "==", 
      "0"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.2.3 Secondary Resonances Due to Cubic Nonlinearities", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In this case \[CapitalOmega] is away from \[Omega], ",
  Cell[BoxData[
      \(TraditionalForm\`2  \[Omega]\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]/2\)]],
  " and small-divisor terms first appear at ",
  Cell[BoxData[
      \(TraditionalForm\`O(\[Epsilon]\^3)\)]],
  ". We scale the damping ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\&^\)]],
  " and forcing ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " so that the damping term and resonance terms appear at the same order as \
the cubic nonlinearity according to"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling = {F -> \[Epsilon]\ f, \[Mu]\&^ -> \[Epsilon]\^2\ \[Mu]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq423a = 
      \((\(\(FDuffingEq /. scaling\) /. multiScalesRule\) /. solRule // 
            ExpandAll)\) /. \[Epsilon]\^\(n_ /; n > maxOrder + 1\) -> 0; \n
    eq423a /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", "\[Mu]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        RowBox[{"\[Epsilon]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        RowBox[{\(\[Epsilon]\^2\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_2\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 2]],
              Editable->False], ")"}]}], "+", 
        RowBox[{\(\[Epsilon]\^3\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_3\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 3]],
              Editable->False], ")"}]}], "+", 
        RowBox[{"2", " ", \(\[Epsilon]\^2\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(\(D\_0\ D\_1\)\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(\(D\_0\ D\_1\)\[InvisibleSpace]u\_2\),
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 2]],
              Editable->False], ")"}]}], "+", 
        RowBox[{\(\[Epsilon]\^3\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\%2\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 1], 2], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(\(D\_0\ D\_2\)\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 2]], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        \(\[Epsilon]\ \[Omega]\^2\ u\_1\), "+", 
        \(\[Delta]\ \[Epsilon]\^2\ u\_1\%2\), "+", 
        \(\[Alpha]\ \[Epsilon]\^3\ u\_1\%3\), "+", 
        \(\[Epsilon]\^2\ \[Omega]\^2\ u\_2\), "+", 
        \(2\ \[Delta]\ \[Epsilon]\^3\ u\_1\ u\_2\), "+", 
        \(\[Epsilon]\^3\ \[Omega]\^2\ u\_3\)}], "==", 
      \(f\ \[Epsilon]\ Cos[T\_0\ \[CapitalOmega]]\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[
"Equating coefficients of like powers of \[Epsilon], we obtain"], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eqEps = 
      \(\(CoefficientList[Subtract\ @@\ eq423a, \[Epsilon]] == 0 // Thread
            \) // Rest\) // TrigToExp; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
To place the linear operator on one side and the nonhomogeneous terms on the \
other side, we define\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(eqOrder[i_] := 
      \(\((\(eqEps[\([1, 1]\)] /. f -> 0\) /. u\_1 -> u\_i)\) - #\ &\)\ /@\ \ 
          eqEps[\([i]\)] // Reverse\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["eqOrder[i]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["displayRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we rewrite ",
  StyleBox["eqEps",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in a concise way as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[eqOrder, 3] /. displayRule // TableForm\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_1\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 1]],
                  Editable->False], "+", \(\[Omega]\^2\ u\_1\)}], "==", 
              \(1\/2\ \((
                  E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\) + 
                    E\^\(I\ T\_0\ \[CapitalOmega]\))\)\ f\)}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_2\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 2]],
                  Editable->False], "+", \(\[Omega]\^2\ u\_2\)}], "==", 
              RowBox[{
                RowBox[{\(-2\), " ", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(\(D\_0\ D\_1\)\[InvisibleSpace]u\_1\),
                      SequenceForm[ 
                        Times[ 
                          Subscript[ D, 0], 
                          Subscript[ D, 1]], 
                        Subscript[ u, 1]],
                      Editable->False], ")"}]}], "-", 
                \(\[Delta]\ u\_1\%2\)}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_3\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 3]],
                  Editable->False], "+", \(\[Omega]\^2\ u\_3\)}], "==", 
              RowBox[{
                RowBox[{\(-2\), " ", "\[Mu]", " ", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_0\[InvisibleSpace]u\_1\),
                      SequenceForm[ 
                        Subscript[ D, 0], 
                        Subscript[ u, 1]],
                      Editable->False], ")"}]}], "-", 
                RowBox[{"2", " ", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(\(D\_0\ D\_1\)\[InvisibleSpace]u\_2\),
                      SequenceForm[ 
                        Times[ 
                          Subscript[ D, 0], 
                          Subscript[ D, 1]], 
                        Subscript[ u, 2]],
                      Editable->False], ")"}]}], "-", 
                InterpretationBox[\(D\_1\%2\[InvisibleSpace]u\_1\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 1], 2], 
                    Subscript[ u, 1]],
                  Editable->False], "-", 
                RowBox[{"2", " ", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(\(D\_0\ D\_2\)\[InvisibleSpace]u\_1\),
                      SequenceForm[ 
                        Times[ 
                          Subscript[ D, 0], 
                          Subscript[ D, 2]], 
                        Subscript[ u, 1]],
                      Editable->False], ")"}]}], "-", \(\[Alpha]\ u\_1\%3\), 
                "-", \(2\ \[Delta]\ u\_1\ u\_2\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Power[ 
                Subscript[ D, 0], 2], 
              Subscript[ u, 1]], 
            Times[ 
              Power[ \[Omega], 2], 
              Subscript[ u, 1]]], 
          Times[ 
            Rational[ 1, 2], 
            Plus[ 
              Power[ E, 
                Times[ 
                  Complex[ 0, -1], T\[UnderBracket]Subscript\[UnderBracket]0, 
                  \[CapitalOmega]]], 
              Power[ E, 
                Times[ 
                  Complex[ 0, 1], T\[UnderBracket]Subscript\[UnderBracket]0, 
                  \[CapitalOmega]]]], f]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Power[ 
                Subscript[ D, 0], 2], 
              Subscript[ u, 2]], 
            Times[ 
              Power[ \[Omega], 2], 
              Subscript[ u, 2]]], 
          Plus[ 
            Times[ -2, 
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 1]]], 
            Times[ -1, \[Delta], 
              Power[ 
                Subscript[ u, 1], 2]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Power[ 
                Subscript[ D, 0], 2], 
              Subscript[ u, 3]], 
            Times[ 
              Power[ \[Omega], 2], 
              Subscript[ u, 3]]], 
          Plus[ 
            Times[ -2, \[Mu], 
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 1]]], 
            Times[ -2, 
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 2]]], 
            Times[ -1, 
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 1], 2], 
                Subscript[ u, 1]]], 
            Times[ -2, 
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 2]], 
                Subscript[ u, 1]]], 
            Times[ -1, \[Alpha], 
              Power[ 
                Subscript[ u, 1], 3]], 
            Times[ -2, \[Delta], 
              Subscript[ u, 1], 
              Subscript[ u, 2]]]]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The particular solution of ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be expressed as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1p = 
      \(DSolve[eqOrder[1], u\_1\ @@\ timeScales, timeScales]\)[\([1]\)] /. 
          C[_] -> \((0&)\) // Simplify\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[T\_0, T\_1, T\_2] \[Rule] 
        \(-\(\(E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ 
                \((1 + E\^\(2\ I\ T\_0\ \[CapitalOmega]\))\)\ f\)\/\(2\ 
                \((\(-\[Omega]\^2\) + \[CapitalOmega]\^2)\)\)\)\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The general solution of ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be written as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(fRule = {
        f \[Rule] 
          \(-2\)\ \[CapitalLambda]\ 
            \((\(-\[Omega]\^2\) + \[CapitalOmega]\^2)\)}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = 
      u\_1 -> Function[{T\_0, T\_1, T\_2}, 
          \(A[T\_1, T\_2]\ Exp[I\ \[Omega]\ T\_0] + 
                  A\&_[T\_1, T\_2]\ Exp[\(-I\)\ \[Omega]\ T\_0] + 
                  sol1p[\([1, 2]\)] /. fRule // Expand\) // Evaluate]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(u\_1 \[Rule] 
      Function[{T\_0, T\_1, T\_2}, 
        E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
          E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
          E\^\(I\ T\_0\ \[Omega]\)\ A[T\_1, T\_2] + 
          E\^\(\(-I\)\ T\_0\ \[Omega]\)\ A\&_[T\_1, T\_2]]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eqOrder[2]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eq = eqOrder[2] /. sol1 // ExpandAll; \n
    order2Eq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
        InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_2\),
          SequenceForm[ 
            Power[ 
              Subscript[ D, 0], 2], 
            Subscript[ u, 2]],
          Editable->False], "+", \(\[Omega]\^2\ u\_2\)}], "==", 
      RowBox[{
      \(\(-A\^2\)\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\), "-", 
        \(2\ A\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
          \[Delta]\ \[CapitalLambda]\), "-", 
        \(2\ A\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
          \[Delta]\ \[CapitalLambda]\), "-", 
        \(2\ \[Delta]\ \[CapitalLambda]\^2\), "-", 
        \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2\), "-", 
        \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2\), "-", \(2\ A\ \[Delta]\ A\&_\), "-", 
        \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
          \[Delta]\ \[CapitalLambda]\ A\&_\), "-", 
        \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
          \[Delta]\ \[CapitalLambda]\ A\&_\), "-", 
        \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\), "-", 
        RowBox[{
        "2", " ", "I", " ", \(E\^\(I\ T\_0\ \[Omega]\)\), " ", "\[Omega]", 
          " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]A\),
              SequenceForm[ 
                Subscript[ D, 1], A],
              Editable->False], ")"}]}], "+", 
        RowBox[{
        "2", " ", "I", " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\)\), " ", 
          "\[Omega]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\),
              SequenceForm[ 
                Subscript[ D, 1], 
                OverBar[ A]],
              Editable->False], ")"}]}]}]}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"The Case \[CapitalOmega] \[TildeTilde] 3 \[Omega] "], "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To express the nearness of \[CapitalOmega] to ",
  Cell[BoxData[
      \(TraditionalForm\`3  \[Omega]\)]],
  ", we introduce a detuning parameter ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma] = O(1)\)]],
  " defined by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(OmgRule = {\[CapitalOmega] -> 3  \[Omega] + \[Epsilon]\^2\ \[Sigma]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(expRule1 = {
        Exp[arg_] :> 
          Exp[Expand[arg /. OmgRule] /. \[Epsilon]\^2\ T\_0 -> T\_2]}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Eliminating the secular terms from ",
  Cell[BoxData[
      \(TraditionalForm\`u\_2\)]],
  " demands that"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond1 = 
      Coefficient[order2Eq[\([2]\)] /. expRule1, Exp[I\ \[Omega]\ T\_0]] == 0
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{\(-2\), " ", "I", " ", "\[Omega]", " ", 
        RowBox[{
          SuperscriptBox["A", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], "==", 
      "0"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SCond1Rule", "=", 
      RowBox[{
        RowBox[{"Solve", "[", 
          RowBox[{"SCond1", ",", 
            RowBox[{
              SuperscriptBox["A", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
          "]"}], "[", \([1]\), "]"}]}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox["A", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], "\[Rule]", 
        "0"}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whose complex conjugate is", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ccSCond1Rule = SCond1Rule /. conjugateRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox[\(A\&_\), 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], "\[Rule]", 
        "0"}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting the solvability condition, ",
  StyleBox["SCond1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and its complex conjugate, into ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((order2Eqm = \(order2Eq /. SCond1Rule\) /. ccSCond1Rule)\) /. 
      displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
        InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_2\),
          SequenceForm[ 
            Power[ 
              Subscript[ D, 0], 2], 
            Subscript[ u, 2]],
          Editable->False], "+", \(\[Omega]\^2\ u\_2\)}], "==", 
      \(\(-A\^2\)\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta] - 
        2\ A\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda] - 
        2\ A\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda] - 2\ \[Delta]\ \[CapitalLambda]\^2 - 
        E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2 - 
        E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ \[CapitalLambda]\^2 - 
        2\ A\ \[Delta]\ A\&_ - 
        2\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
          \[Delta]\ \[CapitalLambda]\ A\&_ - 
        2\ E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
          \[Delta]\ \[CapitalLambda]\ A\&_ - 
        E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "In order to efficiently use ",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  " to determine the particular solution of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we first transform the partial-differential equation to an \
ordinary-differential equation. Then we solve for the particular solution of \
the resulting equation and obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2p = 
      \(\((\(\(u\_2[T\_0] /. 
                    \(DSolve[
                        \((order2Eqm[\([1]\)] /. u\_2 -> \((u\_2[#1]\ &)\))
                            \) == #, u\_2[T\_0], T\_0]\)[\([1]\)]\) /. 
                  C[_] -> 0 // TrigToExp\) // Expand)\)\ &\)\ /@\ 
        order2Eqm[\([2]\)]; \nsol2p /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(A\^2\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\)\/\(3\ \[Omega]\^2\) - 
      \(2\ \[Delta]\ \[CapitalLambda]\^2\)\/\[Omega]\^2 - 
      \(2\ A\ E\^\(I\ T\_0\ \((\[Omega] - \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
          \[CapitalOmega]\) + 
      \(2\ A\ E\^\(I\ T\_0\ \((\[Omega] + \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\)\/\(\[CapitalOmega]\ 
          \((2\ \[Omega] + \[CapitalOmega])\)\) + 
      \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2\)\/\(\((\(-\[Omega]\) + 2\ \[CapitalOmega])\)\ 
          \((\[Omega] + 2\ \[CapitalOmega])\)\) + 
      \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2\)\/\(\((\(-\[Omega]\) + 2\ \[CapitalOmega])\)\ 
          \((\[Omega] + 2\ \[CapitalOmega])\)\) - 
      \(2\ A\ \[Delta]\ A\&_\)\/\[Omega]\^2 - 
      \(2\ E\^\(\(-I\)\ T\_0\ \((\[Omega] - \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\ A\&_\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
          \[CapitalOmega]\) + 
      \(2\ E\^\(\(-I\)\ T\_0\ \((\[Omega] + \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\ A\&_\)\/\(\[CapitalOmega]\ 
          \((2\ \[Omega] + \[CapitalOmega])\)\) + 
      \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
          \[Omega]\^2\)\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "which can be used directly to express ",
  Cell[BoxData[
      \(TraditionalForm\`u\_2\)]],
  " in a pure function form as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol2 = u\_2 -> Function[{T\_0, T\_1, T\_2}, sol2p // Evaluate]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol1 ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "and ",
  StyleBox["sol2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the third-order equation, ",
  StyleBox["eqOrder[3]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order3Eq = \(eqOrder[3] /. sol1\) /. sol2 // ExpandAll; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Eliminating the secular terms from ",
  Cell[BoxData[
      StyleBox[\(u\_3\),
        FontSlant->"Italic"]]],
  " demands that"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond2 = 
      Coefficient[
            \(order3Eq[\([2]\)] /. expRule1\) /. 
              \[CapitalOmega] -> 3  \[Omega], Exp[I\ \[Omega]\ T\_0]] == 0 /. 
        D[SCond1Rule, T\_1]; \nSCond2 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\(-6\)\ A\ \[Alpha]\ \[CapitalLambda]\^2\), "+", 
        \(\(12\ A\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(5\ \[Omega]\^2\)\), 
        "-", \(2\ I\ A\ \[Mu]\ \[Omega]\), "-", \(3\ A\^2\ \[Alpha]\ A\&_\), 
        "+", \(\(10\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^2\)\), "-", 
        \(3\ E\^\(I\ T\_2\ \[Sigma]\)\ \[Alpha]\ \[CapitalLambda]\ A\&_\^2\), 
        "-", \(\(2\ E\^\(I\ T\_2\ \[Sigma]\)\ \[Delta]\^2\ \[CapitalLambda]\ 
              A\&_\^2\)\/\[Omega]\^2\), "-", 
        RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_2\[InvisibleSpace]A\),
              SequenceForm[ 
                Subscript[ D, 2], A],
              Editable->False], ")"}]}]}], "==", "0"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The Case \[CapitalOmega] \[TildeTilde] ",
  Cell[BoxData[
      \(TraditionalForm\`1\/3\)]],
  "\[Omega] "
}], "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To express the nearness of \[CapitalOmega] to ",
  Cell[BoxData[
      \(TraditionalForm\`\(1\/3\) \[Omega]\)]],
  ", we introduce a detuning parameter ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma] = O(1)\)]],
  " defined by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(OmgRule = {
        \[CapitalOmega] -> 
          \(1\/3\) \((\[Omega] + \[Epsilon]\^2\ \[Sigma])\)}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(expRule1 = {
        Exp[arg_] :> 
          Exp[Expand[arg /. OmgRule] /. \[Epsilon]\^2\ T\_0 -> T\_2]}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Eliminating the secular terms from ",
  Cell[BoxData[
      StyleBox[\(u\_2\),
        FontSlant->"Italic"]]],
  " demands that"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond1 = 
      Coefficient[order2Eq[\([2]\)] /. expRule1, Exp[I\ \[Omega]\ T\_0]] == 0
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{\(-2\), " ", "I", " ", "\[Omega]", " ", 
        RowBox[{
          SuperscriptBox["A", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], "==", 
      "0"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["or ", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SCond1Rule", "=", 
      RowBox[{
        RowBox[{"Solve", "[", 
          RowBox[{"SCond1", ",", 
            RowBox[{
              SuperscriptBox["A", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
          "]"}], "[", \([1]\), "]"}]}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox["A", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], "\[Rule]", 
        "0"}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whose complex conjugate is", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ccSCond1Rule = SCond1Rule /. conjugateRule; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the solvability condition, ",
  StyleBox["SCond1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and its complex conjugate, into ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eqm = \(order2Eq /. SCond1Rule\) /. ccSCond1Rule; \n
    order2Eqm /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
        InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_2\),
          SequenceForm[ 
            Power[ 
              Subscript[ D, 0], 2], 
            Subscript[ u, 2]],
          Editable->False], "+", \(\[Omega]\^2\ u\_2\)}], "==", 
      \(\(-A\^2\)\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta] - 
        2\ A\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda] - 
        2\ A\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda] - 2\ \[Delta]\ \[CapitalLambda]\^2 - 
        E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2 - 
        E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ \[CapitalLambda]\^2 - 
        2\ A\ \[Delta]\ A\&_ - 
        2\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
          \[Delta]\ \[CapitalLambda]\ A\&_ - 
        2\ E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
          \[Delta]\ \[CapitalLambda]\ A\&_ - 
        E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Again, we first transform the partial-differential equation into an \
ordinary-differential equation and then use ",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  " to obtain the particular solution of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((sol2p = 
          \(\((\(u\_2[T\_0] /. 
                      \(DSolve[
                          \((order2Eqm[\([1]\)] /. u\_2 -> \((u\_2[#1]\ &)\))
                              \) == #, u\_2[T\_0], T\_0]\)[\([1]\)]\) /. 
                    C[_] -> 0 // TrigToExp)\)\ &\)\ /@\ order2Eqm[\([2]\)])
        \) /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(A\^2\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\)\/\(3\ \[Omega]\^2\) - 
      \(2\ \[Delta]\ \[CapitalLambda]\^2\)\/\[Omega]\^2 - 
      \(2\ A\ E\^\(I\ T\_0\ \((\[Omega] - \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
          \[CapitalOmega]\) + 
      \(2\ A\ E\^\(I\ T\_0\ \((\[Omega] + \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\)\/\(\[CapitalOmega]\ 
          \((2\ \[Omega] + \[CapitalOmega])\)\) + 
      \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2\)\/\(\((\(-\[Omega]\) + 2\ \[CapitalOmega])\)\ 
          \((\[Omega] + 2\ \[CapitalOmega])\)\) + 
      \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2\)\/\(\((\(-\[Omega]\) + 2\ \[CapitalOmega])\)\ 
          \((\[Omega] + 2\ \[CapitalOmega])\)\) - 
      \(2\ A\ \[Delta]\ A\&_\)\/\[Omega]\^2 - 
      \(2\ E\^\(\(-I\)\ T\_0\ \((\[Omega] - \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\ A\&_\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
          \[CapitalOmega]\) + 
      \(2\ E\^\(\(-I\)\ T\_0\ \((\[Omega] + \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\ A\&_\)\/\(\[CapitalOmega]\ 
          \((2\ \[Omega] + \[CapitalOmega])\)\) + 
      \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
          \[Omega]\^2\)\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(sol2 = u\_2 -> Function[{T\_0, T\_1, T\_2}, sol2p // Evaluate]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol1 ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "and ",
  StyleBox["sol2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the third-order equation, ",
  StyleBox["eqOrder[3]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order3Eq = \(eqOrder[3] /. sol1\) /. sol2 // ExpandAll; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Converting the terms that produce small-divisor terms into terms that \
produce secular terms and then eliminating the secular terms from ",
  Cell[BoxData[
      StyleBox[\(u\_3\),
        FontSlant->"Italic"]]],
  " demands that"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond2 = 
      Coefficient[
            \(order3Eq[\([2]\)] /. expRule1\) /. 
              \[CapitalOmega] -> \(1\/3\) \[Omega], 
            Exp[I\ \[Omega]\ T\_0]] == 0 /. D[SCond1Rule, T\_1]; \n
    SCond2 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\(-6\)\ A\ \[Alpha]\ \[CapitalLambda]\^2\), "-", 
        \(E\^\(I\ T\_2\ \[Sigma]\)\ \[Alpha]\ \[CapitalLambda]\^3\), "+", 
        \(\(212\ A\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(35\ 
              \[Omega]\^2\)\), "+", 
        \(\(18\ E\^\(I\ T\_2\ \[Sigma]\)\ \[Delta]\^2\ 
              \[CapitalLambda]\^3\)\/\(5\ \[Omega]\^2\)\), "-", 
        \(2\ I\ A\ \[Mu]\ \[Omega]\), "-", \(3\ A\^2\ \[Alpha]\ A\&_\), "+", 
        \(\(10\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^2\)\), "-", 
        RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_2\[InvisibleSpace]A\),
              SequenceForm[ 
                Subscript[ D, 2], A],
              Editable->False], ")"}]}]}], "==", "0"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.2.4 Secondary Resonances Due to Quadratic Nonlinearities", 
  "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In this case \[CapitalOmega] is away from \[Omega] and small-divisor terms \
first appear at ",
  Cell[BoxData[
      \(TraditionalForm\`O(\[Epsilon]\^2)\)]],
  ". We scale the damping ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\&^\)]],
  " and forcing ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " so that the damping term and resonance terms appear at the same order as \
the quadratic nonlinearity; that is,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling = {F -> \[Epsilon]\ f, \[Mu]\&^ -> \[Epsilon]\ \[Mu]}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq424a = 
      \((\(\(FDuffingEq /. scaling\) /. multiScalesRule\) /. solRule // 
            ExpandAll)\) /. \[Epsilon]\^\(n_ /; n > maxOrder + 1\) -> 0; \n
    eq424a /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"2", " ", \(\[Epsilon]\^2\), " ", "\[Mu]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", "\[Mu]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_2\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 2]],
              Editable->False], ")"}]}], "+", 
        RowBox[{"\[Epsilon]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        RowBox[{\(\[Epsilon]\^2\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_2\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 2]],
              Editable->False], ")"}]}], "+", 
        RowBox[{\(\[Epsilon]\^3\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_3\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 0], 2], 
                Subscript[ u, 3]],
              Editable->False], ")"}]}], "+", 
        RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", "\[Mu]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        RowBox[{"2", " ", \(\[Epsilon]\^2\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(\(D\_0\ D\_1\)\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(\(D\_0\ D\_1\)\[InvisibleSpace]u\_2\),
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 2]],
              Editable->False], ")"}]}], "+", 
        RowBox[{\(\[Epsilon]\^3\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\%2\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 1], 2], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        RowBox[{"2", " ", \(\[Epsilon]\^3\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(\(D\_0\ D\_2\)\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 2]], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "+", 
        \(\[Epsilon]\ \[Omega]\^2\ u\_1\), "+", 
        \(\[Delta]\ \[Epsilon]\^2\ u\_1\%2\), "+", 
        \(\[Alpha]\ \[Epsilon]\^3\ u\_1\%3\), "+", 
        \(\[Epsilon]\^2\ \[Omega]\^2\ u\_2\), "+", 
        \(2\ \[Delta]\ \[Epsilon]\^3\ u\_1\ u\_2\), "+", 
        \(\[Epsilon]\^3\ \[Omega]\^2\ u\_3\)}], "==", 
      \(f\ \[Epsilon]\ Cos[T\_0\ \[CapitalOmega]]\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[
"Equating coefficients of like powers of \[Epsilon], we obtain"], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eqEps = 
      \(\(CoefficientList[Subtract\ @@\ eq424a, \[Epsilon]] == 0 // Thread
            \) // Rest\) // TrigToExp; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1,
  Background->None],

Cell["\<\
To place the linear operator on one side and the nonhomogeneous terms on the \
other side, we define\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(eqOrder[i_] := 
      \(\((\(eqEps[\([1, 1]\)] /. f -> 0\) /. u\_1 -> u\_i)\) - #\ &\)\ /@\ \ 
          eqEps[\([i]\)] // Reverse\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["eqOrder[i]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["displayRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we rewrite ",
  StyleBox["eqEps",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in a concise way as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[eqOrder, 3] /. displayRule // TableForm\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_1\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 1]],
                  Editable->False], "+", \(\[Omega]\^2\ u\_1\)}], "==", 
              \(1\/2\ \((
                  E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\) + 
                    E\^\(I\ T\_0\ \[CapitalOmega]\))\)\ f\)}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_2\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 2]],
                  Editable->False], "+", \(\[Omega]\^2\ u\_2\)}], "==", 
              RowBox[{
                RowBox[{\(-2\), " ", "\[Mu]", " ", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_0\[InvisibleSpace]u\_1\),
                      SequenceForm[ 
                        Subscript[ D, 0], 
                        Subscript[ u, 1]],
                      Editable->False], ")"}]}], "-", 
                RowBox[{"2", " ", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(\(D\_0\ D\_1\)\[InvisibleSpace]u\_1\),
                      SequenceForm[ 
                        Times[ 
                          Subscript[ D, 0], 
                          Subscript[ D, 1]], 
                        Subscript[ u, 1]],
                      Editable->False], ")"}]}], "-", 
                \(\[Delta]\ u\_1\%2\)}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_3\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 0], 2], 
                    Subscript[ u, 3]],
                  Editable->False], "+", \(\[Omega]\^2\ u\_3\)}], "==", 
              RowBox[{
                RowBox[{\(-2\), " ", "\[Mu]", " ", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_0\[InvisibleSpace]u\_2\),
                      SequenceForm[ 
                        Subscript[ D, 0], 
                        Subscript[ u, 2]],
                      Editable->False], ")"}]}], "-", 
                RowBox[{"2", " ", "\[Mu]", " ", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_1\[InvisibleSpace]u\_1\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ u, 1]],
                      Editable->False], ")"}]}], "-", 
                RowBox[{"2", " ", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(\(D\_0\ D\_1\)\[InvisibleSpace]u\_2\),
                      SequenceForm[ 
                        Times[ 
                          Subscript[ D, 0], 
                          Subscript[ D, 1]], 
                        Subscript[ u, 2]],
                      Editable->False], ")"}]}], "-", 
                InterpretationBox[\(D\_1\%2\[InvisibleSpace]u\_1\),
                  SequenceForm[ 
                    Power[ 
                      Subscript[ D, 1], 2], 
                    Subscript[ u, 1]],
                  Editable->False], "-", 
                RowBox[{"2", " ", 
                  RowBox[{"(", 
                    
                    InterpretationBox[
                      \(\(D\_0\ D\_2\)\[InvisibleSpace]u\_1\),
                      SequenceForm[ 
                        Times[ 
                          Subscript[ D, 0], 
                          Subscript[ D, 2]], 
                        Subscript[ u, 1]],
                      Editable->False], ")"}]}], "-", \(\[Alpha]\ u\_1\%3\), 
                "-", \(2\ \[Delta]\ u\_1\ u\_2\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Power[ 
                Subscript[ D, 0], 2], 
              Subscript[ u, 1]], 
            Times[ 
              Power[ \[Omega], 2], 
              Subscript[ u, 1]]], 
          Times[ 
            Rational[ 1, 2], 
            Plus[ 
              Power[ E, 
                Times[ 
                  Complex[ 0, -1], T\[UnderBracket]Subscript\[UnderBracket]0, 
                  \[CapitalOmega]]], 
              Power[ E, 
                Times[ 
                  Complex[ 0, 1], T\[UnderBracket]Subscript\[UnderBracket]0, 
                  \[CapitalOmega]]]], f]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Power[ 
                Subscript[ D, 0], 2], 
              Subscript[ u, 2]], 
            Times[ 
              Power[ \[Omega], 2], 
              Subscript[ u, 2]]], 
          Plus[ 
            Times[ -2, \[Mu], 
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 1]]], 
            Times[ -2, 
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 1]]], 
            Times[ -1, \[Delta], 
              Power[ 
                Subscript[ u, 1], 2]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Power[ 
                Subscript[ D, 0], 2], 
              Subscript[ u, 3]], 
            Times[ 
              Power[ \[Omega], 2], 
              Subscript[ u, 3]]], 
          Plus[ 
            Times[ -2, \[Mu], 
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 2]]], 
            Times[ -2, \[Mu], 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ u, 1]]], 
            Times[ -2, 
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 2]]], 
            Times[ -1, 
              SequenceForm[ 
                Power[ 
                  Subscript[ D, 1], 2], 
                Subscript[ u, 1]]], 
            Times[ -2, 
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 2]], 
                Subscript[ u, 1]]], 
            Times[ -1, \[Alpha], 
              Power[ 
                Subscript[ u, 1], 3]], 
            Times[ -2, \[Delta], 
              Subscript[ u, 1], 
              Subscript[ u, 2]]]]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The particular solution of ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be expressed as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1p = 
      \(DSolve[eqOrder[1], u\_1\ @@\ timeScales, timeScales]\)[\([1]\)] /. 
          C[_] -> \((0&)\) // Simplify\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[T\_0, T\_1, T\_2] \[Rule] 
        \(-\(\(E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ 
                \((1 + E\^\(2\ I\ T\_0\ \[CapitalOmega]\))\)\ f\)\/\(2\ 
                \((\(-\[Omega]\^2\) + \[CapitalOmega]\^2)\)\)\)\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(fRule = 
      f -> \(-2\) \((\(-\[Omega]\^2\) + \[CapitalOmega]\^2)\)\ 
          \[CapitalLambda]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The general solution of ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be written in pur function form as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = 
      u\_1 -> Function[{T\_0, T\_1, T\_2}, 
          \(A[T\_1, T\_2]\ Exp[I\ \[Omega]\ T\_0] + 
                  A\&_[T\_1, T\_2]\ Exp[\(-I\)\ \[Omega]\ T\_0] + 
                  sol1p[\([1, 2]\)] /. fRule // Expand\) // Evaluate]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(u\_1 \[Rule] 
      Function[{T\_0, T\_1, T\_2}, 
        E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
          E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
          E\^\(I\ T\_0\ \[Omega]\)\ A[T\_1, T\_2] + 
          E\^\(\(-I\)\ T\_0\ \[Omega]\)\ A\&_[T\_1, T\_2]]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eqOrder[2]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eq = eqOrder[2] /. sol1 // ExpandAll; \n
    order2Eq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
        InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_2\),
          SequenceForm[ 
            Power[ 
              Subscript[ D, 0], 2], 
            Subscript[ u, 2]],
          Editable->False], "+", \(\[Omega]\^2\ u\_2\)}], "==", 
      RowBox[{
      \(\(-A\^2\)\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\), "-", 
        \(2\ A\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
          \[Delta]\ \[CapitalLambda]\), "-", 
        \(2\ A\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
          \[Delta]\ \[CapitalLambda]\), "-", 
        \(2\ \[Delta]\ \[CapitalLambda]\^2\), "-", 
        \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2\), "-", 
        \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2\), "-", 
        \(2\ I\ A\ E\^\(I\ T\_0\ \[Omega]\)\ \[Mu]\ \[Omega]\), "+", 
        \(2\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
          \[Mu]\ \[CapitalOmega]\), "-", 
        \(2\ I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
          \[CapitalOmega]\), "-", \(2\ A\ \[Delta]\ A\&_\), "-", 
        \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
          \[Delta]\ \[CapitalLambda]\ A\&_\), "-", 
        \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
          \[Delta]\ \[CapitalLambda]\ A\&_\), "+", 
        \(2\ I\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ \[Omega]\ A\&_\), "-", 
        \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\), "-", 
        RowBox[{
        "2", " ", "I", " ", \(E\^\(I\ T\_0\ \[Omega]\)\), " ", "\[Omega]", 
          " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]A\),
              SequenceForm[ 
                Subscript[ D, 1], A],
              Editable->False], ")"}]}], "+", 
        RowBox[{
        "2", " ", "I", " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\)\), " ", 
          "\[Omega]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\),
              SequenceForm[ 
                Subscript[ D, 1], 
                OverBar[ A]],
              Editable->False], ")"}]}]}]}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The Case \[CapitalOmega] \[TildeTilde] ",
  Cell[BoxData[
      \(TraditionalForm\`2\ \[Omega]\)]]
}], "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To express the nearness of \[CapitalOmega] to ",
  Cell[BoxData[
      \(TraditionalForm\`2  \[Omega]\)]],
  ", we introduce a detuning parameter ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma] = O(1)\)]],
  " defined by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(OmgRule = {\[CapitalOmega] -> 2\ \[Omega] + \[Epsilon]\ \[Sigma]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sigRule = \(Solve[OmgRule /. Rule -> Equal, \[Sigma]]\)[\([1]\)]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Sigma] \[Rule] 
        \(-\(\(2\ \[Omega] - \[CapitalOmega]\)\/\[Epsilon]\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(expRule2 = {
        Exp[arg_] :> 
          Exp[Expand[arg /. OmgRule] /. \[Epsilon]\ T\_0 -> T\_1]}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Converting the terms that produce small-divisor terms into terms that \
produce secular terms and then eliminating the secular terms from ",
  Cell[BoxData[
      StyleBox[\(u\_2\),
        FontSlant->"Italic"]]],
  " demands that"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond1 = 
      Coefficient[order2Eq[\([2]\)] /. expRule2, Exp[I\ \[Omega]\ T\_0]] == 
        0; \nSCond1 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\(-2\)\ I\ A\ \[Mu]\ \[Omega]\), "-", 
        \(2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ A\&_\), 
        "-", 
        RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]A\),
              SequenceForm[ 
                Subscript[ D, 1], A],
              Editable->False], ")"}]}]}], "==", "0"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["or ", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond1Rule", "=", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"Solve", "[", 
                RowBox[{"SCond1", ",", 
                  RowBox[{
                    SuperscriptBox["A", 
                      TagBox[\((1, 0)\),
                        Derivative],
                      MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
                "]"}], "[", \([1]\), "]"}], "//", "ExpandAll"}], ")"}]}], 
      ";", "\n", \(SCond1Rule /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(D\_1\[InvisibleSpace]A\),
          SequenceForm[ 
            Subscript[ D, 1], A],
          Editable->False], "\[Rule]", 
        \(\(-A\)\ \[Mu] + 
          \(I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ 
              A\&_\)\/\[Omega]\)}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting ",
  StyleBox["sigRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["SCond1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond1Rulem = 
      SCond1Rule /. 
        Exp[a_] :> 
          Exp[\(a /. sigRule\) /. T\_1 -> \[Epsilon]\ T\_0 // Expand]; \n
    SCond1Rulem /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(D\_1\[InvisibleSpace]A\),
          SequenceForm[ 
            Subscript[ D, 1], A],
          Editable->False], "\[Rule]", 
        \(\(-A\)\ \[Mu] + 
          \(I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
              \[Delta]\ \[CapitalLambda]\ A\&_\)\/\[Omega]\)}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whose complex conjugate is", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ccSCond1Rulem = SCond1Rulem /. conjugateRule; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting these conditions into ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eqm = \(order2Eq /. SCond1Rulem\) /. ccSCond1Rulem // ExpandAll; 
    \norder2Eqm /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
        InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_2\),
          SequenceForm[ 
            Power[ 
              Subscript[ D, 0], 2], 
            Subscript[ u, 2]],
          Editable->False], "+", \(\[Omega]\^2\ u\_2\)}], "==", 
      \(\(-A\^2\)\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta] - 
        2\ A\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda] - 2\ \[Delta]\ \[CapitalLambda]\^2 - 
        E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2 - 
        E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ \[CapitalLambda]\^2 + 
        2\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
          \[CapitalOmega] - 
        2\ I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
          \[CapitalOmega] - 2\ A\ \[Delta]\ A\&_ - 
        2\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
          \[Delta]\ \[CapitalLambda]\ A\&_ - 
        E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Transforming ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into an ordinary-differential equation, we can obtain the particular \
solution as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2p = 
      \(\((\(u\_2[T\_0] /. 
                  \(DSolve[
                      \((order2Eqm[\([1]\)] /. u\_2 -> \((u\_2[#1]\ &)\))
                          \) == #, u\_2[T\_0], T\_0]\)[\([1]\)]\) /. 
                C[_] -> 0 // TrigToExp)\)\ &\)\ /@\ order2Eqm[\([2]\)]; \n
    sol2p /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(A\^2\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\)\/\(3\ \[Omega]\^2\) - 
      \(2\ \[Delta]\ \[CapitalLambda]\^2\)\/\[Omega]\^2 - 
      \(2\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
          \[CapitalOmega]\)\/\(\((\(-\[Omega]\) + \[CapitalOmega])\)\ 
          \((\[Omega] + \[CapitalOmega])\)\) + 
      \(2\ I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
          \[CapitalOmega]\)\/\(\((\(-\[Omega]\) + \[CapitalOmega])\)\ 
          \((\[Omega] + \[CapitalOmega])\)\) + 
      \(2\ A\ E\^\(I\ T\_0\ \((\[Omega] + \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\)\/\(\[CapitalOmega]\ 
          \((2\ \[Omega] + \[CapitalOmega])\)\) + 
      \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2\)\/\(\((\(-\[Omega]\) + 2\ \[CapitalOmega])\)\ 
          \((\[Omega] + 2\ \[CapitalOmega])\)\) + 
      \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
          \[CapitalLambda]\^2\)\/\(\((\(-\[Omega]\) + 2\ \[CapitalOmega])\)\ 
          \((\[Omega] + 2\ \[CapitalOmega])\)\) - 
      \(2\ A\ \[Delta]\ A\&_\)\/\[Omega]\^2 + 
      \(2\ E\^\(\(-I\)\ T\_0\ \((\[Omega] + \[CapitalOmega])\)\)\ \[Delta]\ 
          \[CapitalLambda]\ A\&_\)\/\(\[CapitalOmega]\ 
          \((2\ \[Omega] + \[CapitalOmega])\)\) + 
      \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
          \[Omega]\^2\)\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(sol2 = u\_2 -> Function[{T\_0, T\_1, T\_2}, sol2p // Evaluate]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Then, using ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["sol2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in ",
  StyleBox["eqOrder[3]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order3Eq = \(eqOrder[3] /. sol1\) /. sol2 // ExpandAll; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Converting the terms that produce small-divisor terms into terms that \
produce secular terms and then eliminating the secular terms from ",
  Cell[BoxData[
      StyleBox[\(u\_3\),
        FontSlant->"Italic"]]],
  " demands that"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond2 = 
      \(\(Coefficient[
                  \(order3Eq[\([2]\)] /. expRule2\) /. 
                    \[CapitalOmega] -> 2  \[Omega], 
                  Exp[I\ \[Omega]\ T\_0]] == 0 /. D[SCond1Rule, T\_1]\) /. 
            SCond1Rule\) /. \((SCond1Rule /. conjugateRule)\) // ExpandAll; \n
    SCond2 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\(-6\)\ A\ \[Alpha]\ \[CapitalLambda]\^2\), "+", \(A\ \[Mu]\^2\), 
        "+", \(\(5\ A\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(2\ 
              \[Omega]\^2\)\), "-", \(3\ A\^2\ \[Alpha]\ A\&_\), "+", 
        \(\(10\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^2\)\), "-", 
        \(\(8\ I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ 
              \[Mu]\ A\&_\)\/\(3\ \[Omega]\)\), "+", 
        \(\(E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ \[Sigma]\ 
              A\&_\)\/\[Omega]\), "-", 
        RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_2\[InvisibleSpace]A\),
              SequenceForm[ 
                Subscript[ D, 2], A],
              Editable->False], ")"}]}]}], "==", "0"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["or", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond2Rule", "=", 
        RowBox[{
          RowBox[{
            RowBox[{"Solve", "[", 
              RowBox[{"SCond2", ",", 
                RowBox[{
                  SuperscriptBox["A", 
                    TagBox[\((0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
              "]"}], "[", \([1]\), "]"}], "//", "ExpandAll"}]}], ";", "\n", 
      \(SCond2Rule /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(D\_2\[InvisibleSpace]A\),
          SequenceForm[ 
            Subscript[ D, 2], A],
          Editable->False], "\[Rule]", 
        \(\(-\(\(5\ I\ A\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(4\ 
                  \[Omega]\^3\)\)\) + 
          \(3\ I\ A\ \[Alpha]\ \[CapitalLambda]\^2\)\/\[Omega] - 
          \(I\ A\ \[Mu]\^2\)\/\(2\ \[Omega]\) - 
          \(5\ I\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^3\) - 
          \(4\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ \[Mu]\ 
              A\&_\)\/\(3\ \[Omega]\^2\) - 
          \(I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ 
              \[Sigma]\ A\&_\)\/\(2\ \[Omega]\^2\) + 
          \(3\ I\ A\^2\ \[Alpha]\ A\&_\)\/\(2\ \[Omega]\)\)}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The two partial-differential equations, ",
  StyleBox["SCond1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["SCond2Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", can be reconstituted to obtain an ordinary-differential equation \
governing ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ". The result is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((2\ I\ \[Omega]\ A\^\[Prime] == 
          \((\(\(2\ I\ \[Omega]\ \(dt[1]\)[A[T\_1, T\_2]] /. SCond1Rule\) /. 
                  SCond2Rule // Expand\) // Collect[#, \[Epsilon]]\ &)\))
        \) /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
        SuperscriptBox["A", "\[Prime]",
          MultilineFunction->None]}], "==", 
      \(\[Epsilon]\ 
          \((\(-2\)\ I\ A\ \[Mu]\ \[Omega] - 
              2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ A\&_)
            \) + \[Epsilon]\^2\ 
          \((\(-6\)\ A\ \[Alpha]\ \[CapitalLambda]\^2 + A\ \[Mu]\^2 + 
              \(5\ A\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(2\ 
                  \[Omega]\^2\) - 3\ A\^2\ \[Alpha]\ A\&_ + 
              \(10\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^2\) - 
              \(8\ I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ 
                  \[Mu]\ A\&_\)\/\(3\ \[Omega]\) + 
              \(E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ 
                  \[Sigma]\ A\&_\)\/\[Omega])\)\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.2.5 First-Order Real-Valued System", "Subsection",
  Evaluatable->False,
  TextAlignment->Left,
  TextJustification->1,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],

Cell[TextData[{
  "As in Section 4.2.4 , we determine a second-order uniform expansion of the \
solution of the ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " for the case of subharmonic resonance of order one-half. However, instead \
of treating the second-order form of this equation, we treat its \
corresponding first-order form; that is, we first transform it into a system \
of two real-valued first-order equations. To this end, we introduce the \
transformation"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(vRule = \(u\^\[Prime]\)[t] -> v[t]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In order that the influence of the nonlinearity and damping balance the \
subharmonic resonance, we scale the damping coefficient ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\&^\)]],
  " and forcing amplitude ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling = {F -> \[Epsilon]\ f, \[Mu]\&^ -> \[Epsilon]\ \[Mu]}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using the ",
  StyleBox["scaling",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["vRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we transform the ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the following system of two real-valued first-order equations:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq425a = {vRule /. Rule -> Equal, 
        \(\(FDuffingEq /. scaling\) /. vRule\) /. D[vRule, t]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", \(v[t]\)}], 
        ",", 
        RowBox[{
          RowBox[{
          \(\[Omega]\^2\ u[t]\), "+", \(\[Delta]\ u[t]\^2\), "+", 
            \(\[Alpha]\ u[t]\^3\), "+", \(2\ \[Epsilon]\ \[Mu]\ v[t]\), "+", 
            RowBox[{
              SuperscriptBox["v", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", 
          \(f\ \[Epsilon]\ Cos[t\ \[CapitalOmega]]\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "To determine a second-order uniform expansion of the solution of ",
  StyleBox["eq425a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " using the method of multiple scales, we first transform these equations \
from ordinary-differential equations into partial-differential equations in \
terms of the three time scales ",
  Cell[BoxData[
      \(TraditionalForm\`T\_0, T\_1\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2\)]],
  " according to"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"multiScales", "=", 
        RowBox[{"{", 
          RowBox[{
          \(u[t] -> u[T\_0, T\_1, T\_2]\), ",", 
            \(v[t] -> v[T\_0, T\_1, T\_2]\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["u_", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], "->", 
              \(\(dt[1]\)[u[T\_0, T\_1, T\_2]]\)}], ",", \(t -> T\_0\)}], 
          "}"}]}], ";"}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Next, we expand ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " in the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(solRule = {
        u -> \((Sum[\[Epsilon]\^j\ u\_j[#1, #2, #3], {j, 3}]\ &)\), 
        v -> \((Sum[\[Epsilon]\^j\ v\_j[#1, #2, #3], {j, 3}]\ &)\)}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["multiScales",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["solRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eq425a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expanding the result for small \[Epsilon], and discarding terms of order \
higher than ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\^3\)]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq425b = 
      \((\(eq425a /. multiScales\) /. solRule // ExpandAll)\) /. 
        \[Epsilon]\^\(n_ /; n > 3\) -> 0; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Equating coefficients of like powers of \[Epsilon] in ",
  StyleBox["eq425b",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eqEps = 
      \(\(\(Thread[CoefficientList[Subtract\ @@\ #, \[Epsilon]] == 0]\ &\)\ /@
              \ eq425b // Transpose\) // Rest\) // TrigToExp; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
To place the linear operator on one side and the nonhomogeneous terms on the \
other side, we define\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(linearSys = \(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. f -> 0; \n
    linearSys /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_0\[InvisibleSpace]u\_1\),
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ u, 1]],
            Editable->False], "-", \(v\_1\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_0\[InvisibleSpace]v\_1\),
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 1]],
            Editable->False], "+", \(\[Omega]\^2\ u\_1\)}]}], "}"}]], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(eqOrder[i_] := 
      \((linearSys /. u_\_1 -> u\_i)\) == 
          \((linearSys /. u_\_1 -> u\_i)\) - 
            \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([i]\)])\) // Thread\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["eqOrder[i]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and the ",
  StyleBox["displayRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we rewrite ",
  StyleBox["eqEps",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in a concise way as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[{
    \(eqOrder[1] /. displayRule // TableForm\), 
    \(eqOrder[2] /. displayRule // TableForm\), 
    \(eqOrder[3] /. displayRule // TableForm\)}], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]u\_1\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ u, 1]],
                  Editable->False], "-", \(v\_1\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_1\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 1]],
                  Editable->False], "+", \(\[Omega]\^2\ u\_1\)}], "==", 
              \(1\/2\ \((
                  E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\) + 
                    E\^\(I\ T\_0\ \[CapitalOmega]\))\)\ f\)}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ u, 1]], 
            Times[ -1, 
              Subscript[ v, 1]]], 0], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 1]], 
            Times[ 
              Power[ \[Omega], 2], 
              Subscript[ u, 1]]], 
          Times[ 
            Rational[ 1, 2], 
            Plus[ 
              Power[ E, 
                Times[ 
                  Complex[ 0, -1], T\[UnderBracket]Subscript\[UnderBracket]0, 
                  \[CapitalOmega]]], 
              Power[ E, 
                Times[ 
                  Complex[ 0, 1], T\[UnderBracket]Subscript\[UnderBracket]0, 
                  \[CapitalOmega]]]], f]]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]u\_2\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ u, 2]],
                  Editable->False], "-", \(v\_2\)}], "==", 
              RowBox[{"-", 
                RowBox[{"(", 
                  InterpretationBox[\(D\_1\[InvisibleSpace]u\_1\),
                    SequenceForm[ 
                      Subscript[ D, 1], 
                      Subscript[ u, 1]],
                    Editable->False], ")"}]}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_2\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 2]],
                  Editable->False], "+", \(\[Omega]\^2\ u\_2\)}], "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_1\[InvisibleSpace]v\_1\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ v, 1]],
                      Editable->False], ")"}]}], "-", \(\[Delta]\ u\_1\%2\), 
                "-", \(2\ \[Mu]\ v\_1\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ u, 2]], 
            Times[ -1, 
              Subscript[ v, 2]]], 
          Times[ -1, 
            SequenceForm[ 
              Subscript[ D, 1], 
              Subscript[ u, 1]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 2]], 
            Times[ 
              Power[ \[Omega], 2], 
              Subscript[ u, 2]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ v, 1]]], 
            Times[ -1, \[Delta], 
              Power[ 
                Subscript[ u, 1], 2]], 
            Times[ -2, \[Mu], 
              Subscript[ v, 1]]]]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]u\_3\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ u, 3]],
                  Editable->False], "-", \(v\_3\)}], "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_1\[InvisibleSpace]u\_2\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ u, 2]],
                      Editable->False], ")"}]}], "-", 
                InterpretationBox[\(D\_2\[InvisibleSpace]u\_1\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ u, 1]],
                  Editable->False]}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]v\_3\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ v, 3]],
                  Editable->False], "+", \(\[Omega]\^2\ u\_3\)}], "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_1\[InvisibleSpace]v\_2\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ v, 2]],
                      Editable->False], ")"}]}], "-", 
                InterpretationBox[\(D\_2\[InvisibleSpace]v\_1\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ v, 1]],
                  Editable->False], "-", \(\[Alpha]\ u\_1\%3\), "-", 
                \(2\ \[Delta]\ u\_1\ u\_2\), "-", \(2\ \[Mu]\ v\_2\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ u, 3]], 
            Times[ -1, 
              Subscript[ v, 3]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ u, 2]]], 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ u, 1]]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ v, 3]], 
            Times[ 
              Power[ \[Omega], 2], 
              Subscript[ u, 3]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ v, 2]]], 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ v, 1]]], 
            Times[ -1, \[Alpha], 
              Power[ 
                Subscript[ u, 1], 3]], 
            Times[ -2, \[Delta], 
              Subscript[ u, 1], 
              Subscript[ u, 2]], 
            Times[ -2, \[Mu], 
              Subscript[ v, 2]]]]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["First-Order Equations: Linear System", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We seek a solution of the ",
  StyleBox["linearSys",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the form ",
  Cell[BoxData[
      \(TraditionalForm\`u\_1 = P\ E\^\(I\ \[Omega]\ T\_0\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_1 = Q\ E\^\(I\ \[Omega]\ T\_0\)\)]],
  " and obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coefList = 
      E\^\(\(-I\)\ \[Omega]\ T\_0\)\ linearSys /. {
            u\_1 -> \((P\ E\^\(I\ \[Omega]\ #\)&)\), 
            v\_1 -> \((Q\ E\^\(I\ \[Omega]\ #\)&)\)} // Expand\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\(-Q\) + I\ P\ \[Omega], I\ Q\ \[Omega] + P\ \[Omega]\^2}\)], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The coefficient matrix of ",
  StyleBox["coefList",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coefMat = Outer[Coefficient, coefList, {P, Q}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{I\ \[Omega], \(-1\)}, {\[Omega]\^2, I\ \[Omega]}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whose adjoint is defined by", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(hermitian[mat_?MatrixQ] := mat /. conjugateRule // Transpose\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Hence, the right and left eigenvectors of ",
  StyleBox["coefMat",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(rightVec = {1, c1} /. 
        \(Solve[\((coefMat . {1, c1})\)[\([1]\)] == 0, c1]\)[\([1]\)]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({1, I\ \[Omega]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(leftVec = {c1, 1} /. 
        \(Solve[\((hermitian[coefMat] . {c1, 1})\)[\([1]\)] == 0, c1]\)[
          \([1]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\(-I\)\ \[Omega], 1}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The complex conjugate of ",
  StyleBox["leftVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ccleftVec = leftVec /. conjugateRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({I\ \[Omega], 1}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Thefore, the homogeneous solution of ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is given by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1h = 
      \(# + \((# /. conjugateRule)\)\ &\)\ /@\ 
        \((rightVec\ A[T\_1, T\_2]\ E\^\(I\ \[Omega]\ T\_0\))\)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(I\ T\_0\ \[Omega]\)\ A[T\_1, T\_2] + 
        E\^\(\(-I\)\ T\_0\ \[Omega]\)\ A\&_[T\_1, T\_2], 
      I\ E\^\(I\ T\_0\ \[Omega]\)\ \[Omega]\ A[T\_1, T\_2] - 
        I\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Omega]\ A\&_[T\_1, T\_2]}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Transforming ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ordinary-differential equations and using ",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  ", we obtain the particular solution of ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1p = 
      \(\(DSolve[
                eqOrder[1] /. {u\_1 -> \((u\_1[#1]\ &)\), 
                    v\_1 -> \((v\_1[#1]\ &)\)}, {u\_1[T\_0], v\_1[T\_0]}, 
                T\_0]\)[\([1]\)] /. C[_] -> 0 // TrigToExp\) // Simplify\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1[T\_0] \[Rule] 
        \(-\(\(E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ 
                \((1 + E\^\(2\ I\ T\_0\ \[CapitalOmega]\))\)\ f\)\/\(2\ 
                \((\(-\[Omega]\^2\) + \[CapitalOmega]\^2)\)\)\)\), 
      v\_1[T\_0] \[Rule] 
        \(-\(\(I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ 
                \((\(-1\) + E\^\(2\ I\ T\_0\ \[CapitalOmega]\))\)\ f\ 
                \[CapitalOmega]\)\/\(2\ 
                \((\(-\[Omega]\^2\) + \[CapitalOmega]\^2)\)\)\)\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Then, the general solution of the first-order equations can be expressed in \
pure function form as\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(fRule = 
      f -> \(-2\) \((\(-\[Omega]\^2\) + \[CapitalOmega]\^2)\)\ 
          \[CapitalLambda]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = {
        u\_1 -> Function[{T\_0, T\_1, T\_2}, 
            sol1h[\([1]\)] + 
                \((\(u\_1[T\_0] /. sol1p\) /. fRule // Expand)\) // 
              Evaluate], 
        v\_1 -> Function[{T\_0, T\_1, T\_2}, 
            sol1h[\([2]\)] + 
                \((\(v\_1[T\_0] /. sol1p\) /. fRule // Expand)\) // Evaluate]}
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_1 \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
            E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
            E\^\(I\ T\_0\ \[Omega]\)\ A[T\_1, T\_2] + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\)\ A\&_[T\_1, T\_2]], 
      v\_1 \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(-I\)\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
              \[CapitalOmega] + 
            I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
              \[CapitalOmega] + 
            I\ E\^\(I\ T\_0\ \[Omega]\)\ \[Omega]\ A[T\_1, T\_2] - 
            I\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Omega]\ A\&_[T\_1, T\_2]]}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Second-Order Equations", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the first-order solution, ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", into the second-order equations, ",
  StyleBox["eqOrder[2]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eq = eqOrder[2] /. sol1 // ExpandAll; \n
    order2Eq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_2\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 2]],
              Editable->False], "-", \(v\_2\)}], "==", 
          RowBox[{
            RowBox[{\(-E\^\(I\ T\_0\ \[Omega]\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\),
                  SequenceForm[ 
                    Subscript[ D, 1], A],
                  Editable->False], ")"}]}], "-", 
            RowBox[{\(E\^\(\(-I\)\ T\_0\ \[Omega]\)\), " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    OverBar[ A]],
                  Editable->False], ")"}]}]}]}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_2\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 2]],
              Editable->False], "+", \(\[Omega]\^2\ u\_2\)}], "==", 
          RowBox[{
          \(\(-A\^2\)\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\), "-", 
            \(2\ A\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
              \[Delta]\ \[CapitalLambda]\), "-", 
            \(2\ A\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
              \[Delta]\ \[CapitalLambda]\), "-", 
            \(2\ \[Delta]\ \[CapitalLambda]\^2\), "-", 
            \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
              \[CapitalLambda]\^2\), "-", 
            \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
              \[CapitalLambda]\^2\), "-", 
            \(2\ I\ A\ E\^\(I\ T\_0\ \[Omega]\)\ \[Mu]\ \[Omega]\), "+", 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
              \[Mu]\ \[CapitalOmega]\), "-", 
            \(2\ I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
              \[CapitalOmega]\), "-", \(2\ A\ \[Delta]\ A\&_\), "-", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
              \[Delta]\ \[CapitalLambda]\ A\&_\), "-", 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
              \[Delta]\ \[CapitalLambda]\ A\&_\), "+", 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ \[Omega]\ A\&_\), 
            "-", \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\), 
            "-", 
            RowBox[{
            "I", " ", \(E\^\(I\ T\_0\ \[Omega]\)\), " ", "\[Omega]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\),
                  SequenceForm[ 
                    Subscript[ D, 1], A],
                  Editable->False], ")"}]}], "+", 
            RowBox[{
            "I", " ", \(E\^\(\(-I\)\ T\_0\ \[Omega]\)\), " ", "\[Omega]", 
              " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    OverBar[ A]],
                  Editable->False], ")"}]}]}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[
"To express quantitatively the nearness of the subharmonic resonance of order \
one-half, we introduce the detuning parameter \[Sigma] defined by"], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(OmgRule = {\[CapitalOmega] -> 2  \[Omega] + \[Epsilon]\ \[Sigma]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
To convert the terms that produce small-divisor terms into terms that produce \
secular terms, we use the rule\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(expRule1 = 
      Exp[arg_] :> Exp[Expand[arg /. OmgRule] /. \[Epsilon]\ T\_0 -> T\_1]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To eliminate the terms that produce secular terms in ",
  Cell[BoxData[
      \(TraditionalForm\`u\_2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_2\)]],
  " (i.e., the solvability condition of ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "), we first determine the vector proportional to ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(I\ \[Omega]\ T\_0\)\)]],
  " in the right-hand sides of ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(STerms1 = 
      \(Coefficient[#[\([2]\)] /. expRule1, Exp[I\ \[Omega]\ T\_0]]\ &\)\ /@\ 
        order2Eq\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"-", 
          RowBox[{
            SuperscriptBox["A", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], ",", 
        RowBox[{
        \(\(-2\)\ I\ \[Mu]\ \[Omega]\ A[T\_1, T\_2]\), "-", 
          \(2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ 
            A\&_[T\_1, T\_2]\), "-", 
          RowBox[{"I", " ", "\[Omega]", " ", 
            RowBox[{
              SuperscriptBox["A", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}]}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Then, the solvability condition of ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " demands that ",
  StyleBox["STerms1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " be orthogonal to the solution of the adjoint; that is, ",
  StyleBox["ccleftVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". The result is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SCond1", "=", 
      RowBox[{
        RowBox[{"Solve", "[", 
          RowBox[{\(ccleftVec . STerms1 == 0\), ",", 
            RowBox[{
              SuperscriptBox["A", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
          "]"}], "[", \([1]\), "]"}]}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox["A", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], "\[Rule]", 
        \(-\(\(\[Mu]\ \[Omega]\ A[T\_1, T\_2] - 
                I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ 
                  A\&_[T\_1, T\_2]\)\/\[Omega]\)\)}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whose complex conjugate is", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ccSCond1 = SCond1 /. conjugateRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox[\(A\&_\), 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], "\[Rule]", 
        \(-\(\(I\ E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ 
                  A[T\_1, T\_2] + 
                \[Mu]\ \[Omega]\ A\&_[T\_1, T\_2]\)\/\[Omega]\)\)}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Next, we use the solvability condition to eliminate ",
  Cell[BoxData[
      \(TraditionalForm\`\(D\_1\) A\)]],
  " and its complex conjugate from ",
  StyleBox["order2Eq ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "and then find their particular solution. To simplify the resulting \
equations using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we need to replace ",
  Cell[BoxData[
      \(TraditionalForm\`T\_1\)]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\ T\_0\)]],
  ". To this end, we express the detuning parameter ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\)]],
  " in terms of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega]\)]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sigRule = \(Solve[OmgRule /. Rule -> Equal, \[Sigma]]\)[\([1]\)]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Sigma] \[Rule] 
        \(-\(\(2\ \[Omega] - \[CapitalOmega]\)\/\[Epsilon]\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["and define the rule", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(expRule2 = 
      Exp[a_] :> Exp[\(a /. T\_1 -> \[Epsilon]\ T\_0\) /. sigRule // Expand]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "This rule enables us to rewrite ",
  StyleBox["SCond1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["ccSCond1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond1f = Join[SCond1, ccSCond1] /. expRule2; \n
    SCond1f /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          InterpretationBox[\(D\_1\[InvisibleSpace]A\),
            SequenceForm[ 
              Subscript[ D, 1], A],
            Editable->False], "\[Rule]", 
          \(-\(\(A\ \[Mu]\ \[Omega] - 
                  I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega] + 
                        I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                    \[CapitalLambda]\ A\&_\)\/\[Omega]\)\)}], ",", 
        RowBox[{
          InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\),
            SequenceForm[ 
              Subscript[ D, 1], 
              OverBar[ A]],
            Editable->False], "\[Rule]", 
          \(-\(\(I\ A\ 
                    E\^\(2\ I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                    \[Delta]\ \[CapitalLambda] + 
                  \[Mu]\ \[Omega]\ A\&_\)\/\[Omega]\)\)}]}], "}"}]], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "With this form of the solvability condition, ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " becomes"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eqm = order2Eq /. SCond1f // ExpandAll; \n
    order2Eqm /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]u\_2\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ u, 2]],
              Editable->False], "-", \(v\_2\)}], "==", 
          \(A\ E\^\(I\ T\_0\ \[Omega]\)\ \[Mu] + 
            \(I\ A\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\)\/\[Omega] + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ A\&_ - 
            \(I\ E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ A\&_\)\/\[Omega]\)}], ",", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(D\_0\[InvisibleSpace]v\_2\),
              SequenceForm[ 
                Subscript[ D, 0], 
                Subscript[ v, 2]],
              Editable->False], "+", \(\[Omega]\^2\ u\_2\)}], "==", 
          \(\(-A\^2\)\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta] - 
            A\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
              \[CapitalLambda] - 
            2\ A\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
              \[Delta]\ \[CapitalLambda] - 2\ \[Delta]\ \[CapitalLambda]\^2 - 
            E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
              \[CapitalLambda]\^2 - 
            E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
              \[CapitalLambda]\^2 - 
            I\ A\ E\^\(I\ T\_0\ \[Omega]\)\ \[Mu]\ \[Omega] + 
            2\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
              \[Mu]\ \[CapitalOmega] - 
            2\ I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
              \[CapitalOmega] - 2\ A\ \[Delta]\ A\&_ - 
            2\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
              \[Delta]\ \[CapitalLambda]\ A\&_ - 
            E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
              \[Delta]\ \[CapitalLambda]\ A\&_ + 
            I\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ \[Omega]\ A\&_ - 
            E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)}]}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Next, we use the method of undetermined coefficients to determine the \
particular solution of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". To accomplish this, we first identify the form of their nonhomogeneous \
terms, which we will refer to as possible terms, and then seek the solution \
as a linear combination of them. Substituting this solution into ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and equating the coefficient of each possible term to zero, we obtain a \
set of pairs of algebraic equations that need to be solved for the unknown \
coefficients. The solutions of these pairs are unique except for the \
coefficients of ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(I\ \[Omega]\ T\_0\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(\(-I\)\ \[Omega]\ T\_0\)\)]],
  ". To determine a unique solution corresponding to these terms, we use two \
different approaches."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[StyleBox["Approach 1:",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1],
  Background->RGBColor[1, 1, 0]]], "Text",
  TextAlignment->Left,
  TextJustification->1,
  Background->RGBColor[1, 1, 0]],

Cell[TextData[{
  "In the first approach, we replace \[Omega] with another symbol, say ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_0\)]],
  ", find the solution of the system of algebraic equations, and then take \
the limit as ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_0\)]],
  " tends to \[Omega]. To accomplish this, we define"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(collectForm = {E\^\(I\ T\_0\ \[Omega]\)\ A[T\_1, T\_2], 
        E\^\(\(-I\)\ T\_0\ \[Omega]\)\ A\&_[T\_1, T\_2], 
        E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda], 
        E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Then, the form of the possible terms on the right-hand sides of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be determined as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(possibleTerms = 
      \((collectForm /. \[Omega] -> \[Omega]\_0)\)~Join~
        \((\(Outer[Times, collectForm, collectForm] // Flatten\) // Union)
          \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(I\ T\_0\ \[Omega]\_0\)\ A[T\_1, T\_2], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_0\)\ A\&_[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda], 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda], 
      \[CapitalLambda]\^2, 
      E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\^2, 
      E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\^2, 
      E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
        A[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
        A[T\_1, T\_2], E\^\(2\ I\ T\_0\ \[Omega]\)\ A[T\_1, T\_2]\^2, 
      E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
        \[CapitalLambda]\ A\&_[T\_1, T\_2], 
      E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
        \[CapitalLambda]\ A\&_[T\_1, T\_2], A[T\_1, T\_2]\ A\&_[T\_1, T\_2], 
      E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ A\&_[T\_1, T\_2]\^2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Next, we associate with each possible term an undetermined coefficient in \
",
  Cell[BoxData[
      \(TraditionalForm\`u\_2\)]],
  " by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(symbolList1 = Table[\[CapitalGamma]\_i, {i, Length[possibleTerms]}]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalGamma]\_1, \[CapitalGamma]\_2, \[CapitalGamma]\_3, 
      \[CapitalGamma]\_4, \[CapitalGamma]\_5, \[CapitalGamma]\_6, 
      \[CapitalGamma]\_7, \[CapitalGamma]\_8, \[CapitalGamma]\_9, 
      \[CapitalGamma]\_10, \[CapitalGamma]\_11, \[CapitalGamma]\_12, 
      \[CapitalGamma]\_13, \[CapitalGamma]\_14}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "and an undetermined coefficient in ",
  Cell[BoxData[
      \(TraditionalForm\`v\_2\)]],
  " by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(symbolList2 = symbolList1 /. \[CapitalGamma] -> \[CapitalLambda]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalLambda]\_1, \[CapitalLambda]\_2, \[CapitalLambda]\_3, 
      \[CapitalLambda]\_4, \[CapitalLambda]\_5, \[CapitalLambda]\_6, 
      \[CapitalLambda]\_7, \[CapitalLambda]\_8, \[CapitalLambda]\_9, 
      \[CapitalLambda]\_10, \[CapitalLambda]\_11, \[CapitalLambda]\_12, 
      \[CapitalLambda]\_13, \[CapitalLambda]\_14}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Then, we seek a particular solution of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol2Rule = {
        u\_2 -> Function[{T\_0, T\_1, T\_2}, 
            symbolList1 . possibleTerms // Evaluate], 
        v\_2 -> Function[{T\_0, T\_1, T\_2}, 
            symbolList2 . possibleTerms // Evaluate]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol2Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and replacing ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(\(\[PlusMinus]I\)\ \[Omega]\ T\_0\)\)]],
  " on the right-hand sides of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(\(\[PlusMinus]I\)\ \[Omega]\_0\ T\_0\)\)]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order2Eqf = 
      \(\(Subtract\ @@\ #\ &\)\ /@\ order2Eqm /. sol2Rule\) /. {
            Exp[I\ \[Omega]\ T\_0] -> Exp[I\ \[Omega]\_0\ T\_0], 
            Exp[\(-I\)\ \[Omega]\ T\_0] -> Exp[\(-I\)\ \[Omega]\_0\ T\_0]} // 
        Expand; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Applying directly the function ",
  StyleBox["Coefficient",
    FontWeight->"Bold"],
  " to collect the coefficients of all ",
  StyleBox["possibleTerms",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " could result in extra terms that are functions of ",
  Cell[BoxData[
      \(TraditionalForm\`\(T\_0\ , \)\)]],
  "which we eliminate. The result is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(algEqs = 
      Flatten[\(Coefficient[order2Eqf, #]&\)/@\ possibleTerms] == 0 /. 
          Exp[_\ T\_0] -> 0 // Thread\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\(-\[Mu]\) - \[CapitalLambda]\_1 + 
          I\ \[CapitalGamma]\_1\ \[Omega]\_0 == 0, 
      I\ \[Mu]\ \[Omega] + \[Omega]\^2\ \[CapitalGamma]\_1 + 
          I\ \[CapitalLambda]\_1\ \[Omega]\_0 == 0, 
      \(-\[Mu]\) - \[CapitalLambda]\_2 - 
          I\ \[CapitalGamma]\_2\ \[Omega]\_0 == 0, 
      \(-I\)\ \[Mu]\ \[Omega] + \[Omega]\^2\ \[CapitalGamma]\_2 - 
          I\ \[CapitalLambda]\_2\ \[Omega]\_0 == 0, 
      I\ \[CapitalOmega]\ \[CapitalGamma]\_3 - \[CapitalLambda]\_3 == 0, 
      2\ I\ \[Mu]\ \[CapitalOmega] + \[Omega]\^2\ \[CapitalGamma]\_3 + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_3 == 0, 
      \(-I\)\ \[CapitalOmega]\ \[CapitalGamma]\_4 - \[CapitalLambda]\_4 == 0, 
      \(-2\)\ I\ \[Mu]\ \[CapitalOmega] + \[Omega]\^2\ \[CapitalGamma]\_4 - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_4 == 0, 
      \(-\[CapitalLambda]\_5\) == 0, 
      2\ \[Delta] + \[Omega]\^2\ \[CapitalGamma]\_5 == 0, 
      \(-2\)\ I\ \[CapitalOmega]\ \[CapitalGamma]\_6 - \[CapitalLambda]\_6 == 
        0, \[Delta] + \[Omega]\^2\ \[CapitalGamma]\_6 - 
          2\ I\ \[CapitalOmega]\ \[CapitalLambda]\_6 == 0, 
      2\ I\ \[CapitalOmega]\ \[CapitalGamma]\_7 - \[CapitalLambda]\_7 == 0, 
      \[Delta] + \[Omega]\^2\ \[CapitalGamma]\_7 + 
          2\ I\ \[CapitalOmega]\ \[CapitalLambda]\_7 == 0, 
      \(-\(\(I\ \[Delta]\)\/\[Omega]\)\) + I\ \[Omega]\ \[CapitalGamma]\_8 - 
          I\ \[CapitalOmega]\ \[CapitalGamma]\_8 - \[CapitalLambda]\_8 == 0, 
      \[Delta] + \[Omega]\^2\ \[CapitalGamma]\_8 + 
          I\ \[Omega]\ \[CapitalLambda]\_8 - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_8 == 0, 
      I\ \[Omega]\ \[CapitalGamma]\_9 + 
          I\ \[CapitalOmega]\ \[CapitalGamma]\_9 - \[CapitalLambda]\_9 == 0, 
      2\ \[Delta] + \[Omega]\^2\ \[CapitalGamma]\_9 + 
          I\ \[Omega]\ \[CapitalLambda]\_9 + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_9 == 0, 
      2\ I\ \[Omega]\ \[CapitalGamma]\_10 - \[CapitalLambda]\_10 == 0, 
      \[Delta] + \[Omega]\^2\ \[CapitalGamma]\_10 + 
          2\ I\ \[Omega]\ \[CapitalLambda]\_10 == 0, 
      \(-I\)\ \[Omega]\ \[CapitalGamma]\_11 - 
          I\ \[CapitalOmega]\ \[CapitalGamma]\_11 - \[CapitalLambda]\_11 == 
        0, 
      2\ \[Delta] + \[Omega]\^2\ \[CapitalGamma]\_11 - 
          I\ \[Omega]\ \[CapitalLambda]\_11 - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_11 == 0, 
      \(I\ \[Delta]\)\/\[Omega] - I\ \[Omega]\ \[CapitalGamma]\_12 + 
          I\ \[CapitalOmega]\ \[CapitalGamma]\_12 - \[CapitalLambda]\_12 == 
        0, \[Delta] + \[Omega]\^2\ \[CapitalGamma]\_12 - 
          I\ \[Omega]\ \[CapitalLambda]\_12 + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_12 == 0, 
      \(-\[CapitalLambda]\_13\) == 0, 
      2\ \[Delta] + \[Omega]\^2\ \[CapitalGamma]\_13 == 0, 
      \(-2\)\ I\ \[Omega]\ \[CapitalGamma]\_14 - \[CapitalLambda]\_14 == 0, 
      \[Delta] + \[Omega]\^2\ \[CapitalGamma]\_14 - 
          2\ I\ \[Omega]\ \[CapitalLambda]\_14 == 0}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Using the function ",
  StyleBox["Solve",
    FontWeight->"Bold"],
  ", we directly solve the system of algebraic equations ",
  StyleBox["algEqs",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " for these undetermined coefficients and obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(var = Join[symbolList1, symbolList2]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(coefs = \(Solve[algEqs, var]\)[\([1]\)]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["coefs",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["sol2Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and changing ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_0\)]],
  " back to ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\)]],
  ", we obtain the solution of the second-order equations in pure function \
form as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2a = 
      sol2Rule /. 
        Function[{T\_0, T\_1, T\_2}, b_] :> 
          Function[{T\_0, T\_1, T\_2} // Evaluate, 
            \(b /. coefs\) /. \[Omega]\_0 -> \[Omega] // Evaluate]; \n
    sol2a /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_2 \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(-\(\(2\ \[Delta]\ \[CapitalLambda]\^2\)\/\[Omega]\^2\)\) - 
            \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                \[CapitalLambda]\^2\)\/\(\[Omega]\^2 - 
                4\ \[CapitalOmega]\^2\) - 
            \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                \[CapitalLambda]\^2\)\/\(\[Omega]\^2 - 
                4\ \[CapitalOmega]\^2\) + 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
                \[Mu]\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
                \[CapitalOmega]\^2\) - 
            \(2\ I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
                \[CapitalOmega]\)\/\(\[Omega]\^2 - \[CapitalOmega]\^2\) - 
            \(I\ E\^\(I\ T\_0\ \[Omega]\)\ \[Mu]\ A\)\/\(2\ \[Omega]\) - 
            \(E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                \[CapitalLambda]\ A\)\/\(\[Omega]\ \[CapitalOmega]\) + 
            \(2\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ A\)\/\(\[CapitalOmega]\ 
                \((2\ \[Omega] + \[CapitalOmega])\)\) + 
            \(E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\^2\)\/\(3\ 
                \[Omega]\^2\) + 
            \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ A\&_\)\/\(2\ 
                \[Omega]\) - 
            \(E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ A\&_\)\/\(\[Omega]\ 
                \[CapitalOmega]\) + 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ A\&_\)\/\(\[CapitalOmega]\ 
                \((2\ \[Omega] + \[CapitalOmega])\)\) - 
            \(2\ \[Delta]\ A\ A\&_\)\/\[Omega]\^2 + 
            \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
                \[Omega]\^2\)], 
      v\_2 \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(2\ I\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                \[CapitalLambda]\^2\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
                4\ \[CapitalOmega]\^2\) - 
            \(2\ I\ E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                \[CapitalLambda]\^2\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
                4\ \[CapitalOmega]\^2\) + 
            \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
                \[Mu]\ \[CapitalOmega]\^2\)\/\(\[Omega]\^2 - 
                \[CapitalOmega]\^2\) + 
            \(2\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
                \[CapitalOmega]\^2\)\/\(\[Omega]\^2 - \[CapitalOmega]\^2\) - 
            1\/2\ E\^\(I\ T\_0\ \[Omega]\)\ \[Mu]\ A - 
            \(I\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ A\)\/\[CapitalOmega] + 
            \(2\ I\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ \((\[Omega] + \[CapitalOmega])\)\ 
                A\)\/\(\[CapitalOmega]\ 
                \((2\ \[Omega] + \[CapitalOmega])\)\) + 
            \(2\ I\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\^2\)\/\(3\ 
                \[Omega]\) - 
            1\/2\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ A\&_ + 
            \(I\ E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ A\&_\)\/\[CapitalOmega] - 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ \((\[Omega] + \[CapitalOmega])\)\ 
                A\&_\)\/\(\[CapitalOmega]\ 
                \((2\ \[Omega] + \[CapitalOmega])\)\) - 
            \(2\ I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3
                \ \[Omega]\)]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[StyleBox["Approach 2:",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]]], "Text",
  TextAlignment->Left,
  TextJustification->1,
  Background->RGBColor[1, 1, 0]],

Cell[TextData[{
  "As discussed above, solutions of the algebraic equations resulting from \
applying the method of undetermined coefficients are unique except those \
corresponding to ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(I\ \[Omega]\ T\_0\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(\(-I\)\ \[Omega]\ T\_0\)\)]],
  ". To render them unique, we demand that they be orthogonal to solutions of \
the corresponding adjoint problems; that is, we damand that the coefficient \
vector of ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(I\ \[Omega]\ T\_0\)\)]],
  " be ",
  Cell[BoxData[
      \(TraditionalForm\`{u\_\(2\ \), v\_2}\)]],
  " be orthogonal to ",
  StyleBox["ccleftVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". To accomplish this, we first determine the form of all possible terms on \
the right-hand sides of ",
  StyleBox["order2Eqm ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "and then identify those among them corresponding to the resonance terms \
and those corresponding to nonresonance terms."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(possibleTerms = 
      collectForm~Join~
        \((\(Outer[Times, collectForm, collectForm] // Flatten\) // Union)
          \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(I\ T\_0\ \[Omega]\)\ A[T\_1, T\_2], 
      E\^\(\(-I\)\ T\_0\ \[Omega]\)\ A\&_[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda], 
      E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda], 
      \[CapitalLambda]\^2, 
      E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\^2, 
      E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\^2, 
      E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
        A[T\_1, T\_2], 
      E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
        A[T\_1, T\_2], E\^\(2\ I\ T\_0\ \[Omega]\)\ A[T\_1, T\_2]\^2, 
      E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
        \[CapitalLambda]\ A\&_[T\_1, T\_2], 
      E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
        \[CapitalLambda]\ A\&_[T\_1, T\_2], A[T\_1, T\_2]\ A\&_[T\_1, T\_2], 
      E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ A\&_[T\_1, T\_2]\^2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["Next, we identify the resonance terms among them by", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(RT = 
      \(\((\(# /. {a_ /; a =!= 0 -> 1}\ &\)\ /@\ 
                \((\(E\^\(\(-I\)\ \[Omega]\ T\_0\)\ possibleTerms /. expRule1
                      \) /. Exp[_\ T\_0 + _. ] -> 0)\))\)\ possibleTerms // 
          Union\) // Rest\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(I\ T\_0\ \[Omega]\)\ A[T\_1, T\_2], 
      E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
        \[CapitalLambda]\ A\&_[T\_1, T\_2]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Hence, the nonresonance part of ",
  StyleBox["possibleTerms",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is the complement of ",
  StyleBox["RT",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "; that is,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(NRT = Complement[possibleTerms, Join[RT, RT /. conjugateRule]]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda], 
      E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda], \[CapitalLambda]\^2, 
      E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\^2, 
      E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\^2, 
      E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
        A[T\_1, T\_2], E\^\(2\ I\ T\_0\ \[Omega]\)\ A[T\_1, T\_2]\^2, 
      E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
        \[CapitalLambda]\ A\&_[T\_1, T\_2], A[T\_1, T\_2]\ A\&_[T\_1, T\_2], 
      E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ A\&_[T\_1, T\_2]\^2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Next, we associate with each possible resonance term an undetermined \
coefficient by using the rule\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(RTsymbolList = Table[\[CapitalGamma]\_j, {j, Length[RT]}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalGamma]\_1, \[CapitalGamma]\_2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
and we associate with each possible nonresonance term an undetermined \
coefficient by using the rule\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(NRTsymbolList[i_] = 
      Table[\[CapitalLambda]\_\(i, j\), {j, Length[NRT]}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalLambda]\_\(i, 1\), \[CapitalLambda]\_\(i, 2\), 
      \[CapitalLambda]\_\(i, 3\), \[CapitalLambda]\_\(i, 4\), 
      \[CapitalLambda]\_\(i, 5\), \[CapitalLambda]\_\(i, 6\), 
      \[CapitalLambda]\_\(i, 7\), \[CapitalLambda]\_\(i, 8\), 
      \[CapitalLambda]\_\(i, 9\), \[CapitalLambda]\_\(i, 10\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Hence, the coefficients of ",
  StyleBox["RT",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the nonhomogeneous terms in ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coefRT = 
      \(Coefficient[#[\([2]\)], RT]\ &\)\ /@\ order2Eqm /. 
        Exp[_\ T\_0 + _. ] -> 0\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{\[Mu], \(-\(\(I\ \[Delta]\)\/\[Omega]\)\)}, {\(-I\)\ \[Mu]\ \[Omega], 
        \(-\[Delta]\)}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["It follows from", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ccleftVec . coefRT === {0, 0}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(True\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "that ",
  StyleBox["coefRT",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is orthogonal to the solution of the adjoint, ",
  StyleBox["ccleftVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", as it should."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Imposing the condition that {",
  Cell[BoxData[
      \(TraditionalForm\`u\_2\)]],
  " , ",
  Cell[BoxData[
      \(TraditionalForm\`v\_2\)]],
  "} is orthogonal to ",
  StyleBox["ccleftVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we seek ",
  Cell[BoxData[
      \(TraditionalForm\`u\_2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_2\)]],
  " in pure function form as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol2Form = {\n\t\t
        u\_2 -> Function[{T\_0, T\_1, T\_2}, 
            RTsymbolList . RT + \((RTsymbolList . RT /. conjugateRule)\) + 
                NRTsymbolList[1] . NRT // Evaluate], 
        v\_2 -> Function[{T\_0, T\_1, T\_2}, 
            \(-I\)\ \[Omega]\ RTsymbolList . RT + 
                \((\(-I\)\ \[Omega]\ RTsymbolList . RT /. conjugateRule)\) + 
                NRTsymbolList[2] . NRT // Evaluate]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol2Form",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and collecting coefficients of ",
  StyleBox["NRT",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the following set of algebraic equations:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(algEqs1 = 
      \((\(Coefficient[Subtract\ @@\ #, NRT]\ &\)\ /@\ 
                  \((order2Eqm /. sol2Form)\) /. Exp[_\ T\_0] -> 0 // Flatten)
            \) == 0 // Thread\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\(-I\)\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 1\) - 
          \[CapitalLambda]\_\(2, 1\) == 0, 
      I\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 2\) - 
          \[CapitalLambda]\_\(2, 2\) == 0, 
      \(-\[CapitalLambda]\_\(2, 3\)\) == 0, 
      \(-2\)\ I\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 4\) - 
          \[CapitalLambda]\_\(2, 4\) == 0, 
      2\ I\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 5\) - 
          \[CapitalLambda]\_\(2, 5\) == 0, 
      I\ \[Omega]\ \[CapitalLambda]\_\(1, 6\) + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 6\) - 
          \[CapitalLambda]\_\(2, 6\) == 0, 
      2\ I\ \[Omega]\ \[CapitalLambda]\_\(1, 7\) - 
          \[CapitalLambda]\_\(2, 7\) == 0, 
      \(-I\)\ \[Omega]\ \[CapitalLambda]\_\(1, 8\) - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(1, 8\) - 
          \[CapitalLambda]\_\(2, 8\) == 0, 
      \(-\[CapitalLambda]\_\(2, 9\)\) == 0, 
      \(-2\)\ I\ \[Omega]\ \[CapitalLambda]\_\(1, 10\) - 
          \[CapitalLambda]\_\(2, 10\) == 0, 
      \(-2\)\ I\ \[Mu]\ \[CapitalOmega] + 
          \[Omega]\^2\ \[CapitalLambda]\_\(1, 1\) - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 1\) == 0, 
      2\ I\ \[Mu]\ \[CapitalOmega] + 
          \[Omega]\^2\ \[CapitalLambda]\_\(1, 2\) + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 2\) == 0, 
      2\ \[Delta] + \[Omega]\^2\ \[CapitalLambda]\_\(1, 3\) == 0, 
      \[Delta] + \[Omega]\^2\ \[CapitalLambda]\_\(1, 4\) - 
          2\ I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 4\) == 0, 
      \[Delta] + \[Omega]\^2\ \[CapitalLambda]\_\(1, 5\) + 
          2\ I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 5\) == 0, 
      2\ \[Delta] + \[Omega]\^2\ \[CapitalLambda]\_\(1, 6\) + 
          I\ \[Omega]\ \[CapitalLambda]\_\(2, 6\) + 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 6\) == 0, 
      \[Delta] + \[Omega]\^2\ \[CapitalLambda]\_\(1, 7\) + 
          2\ I\ \[Omega]\ \[CapitalLambda]\_\(2, 7\) == 0, 
      2\ \[Delta] + \[Omega]\^2\ \[CapitalLambda]\_\(1, 8\) - 
          I\ \[Omega]\ \[CapitalLambda]\_\(2, 8\) - 
          I\ \[CapitalOmega]\ \[CapitalLambda]\_\(2, 8\) == 0, 
      2\ \[Delta] + \[Omega]\^2\ \[CapitalLambda]\_\(1, 9\) == 0, 
      \[Delta] + \[Omega]\^2\ \[CapitalLambda]\_\(1, 10\) - 
          2\ I\ \[Omega]\ \[CapitalLambda]\_\(2, 10\) == 0}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Solving ",
  StyleBox["algEqs1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " for the undetermined coefficients ",
  StyleBox["NRTsymbolList",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef1 = 
      \(Solve[algEqs1, Array[NRTsymbolList, 2] // Flatten]\)[\([1]\)]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalLambda]\_\(2, 9\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 3\) \[Rule] 
        \(-\(\(2\ \[Delta]\)\/\[Omega]\^2\)\), 
      \[CapitalLambda]\_\(1, 9\) \[Rule] 
        \(-\(\(2\ \[Delta]\)\/\[Omega]\^2\)\), 
      \[CapitalLambda]\_\(2, 3\) \[Rule] 0, 
      \[CapitalLambda]\_\(1, 1\) \[Rule] 
        \(2\ I\ \[Mu]\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
            \[CapitalOmega]\^2\), 
      \[CapitalLambda]\_\(1, 4\) \[Rule] 
        \(-\(\[Delta]\/\(\[Omega]\^2 - 4\ \[CapitalOmega]\^2\)\)\), 
      \[CapitalLambda]\_\(1, 2\) \[Rule] 
        \(-\(\(2\ I\ \[Mu]\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
                \[CapitalOmega]\^2\)\)\), 
      \[CapitalLambda]\_\(1, 5\) \[Rule] 
        \(-\(\[Delta]\/\(\[Omega]\^2 - 4\ \[CapitalOmega]\^2\)\)\), 
      \[CapitalLambda]\_\(2, 1\) \[Rule] 
        \(2\ \[Mu]\ \[CapitalOmega]\^2\)\/\(\[Omega]\^2 - 
            \[CapitalOmega]\^2\), 
      \[CapitalLambda]\_\(1, 7\) \[Rule] \[Delta]\/\(3\ \[Omega]\^2\), 
      \[CapitalLambda]\_\(2, 2\) \[Rule] 
        \(2\ \[Mu]\ \[CapitalOmega]\^2\)\/\(\[Omega]\^2 - 
            \[CapitalOmega]\^2\), 
      \[CapitalLambda]\_\(2, 5\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
                4\ \[CapitalOmega]\^2\)\)\), 
      \[CapitalLambda]\_\(1, 10\) \[Rule] \[Delta]\/\(3\ \[Omega]\^2\), 
      \[CapitalLambda]\_\(2, 10\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\)\/\(3\ \[Omega]\)\)\), 
      \[CapitalLambda]\_\(2, 4\) \[Rule] 
        \(2\ I\ \[Delta]\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
            4\ \[CapitalOmega]\^2\), 
      \[CapitalLambda]\_\(2, 7\) \[Rule] \(2\ I\ \[Delta]\)\/\(3\ \[Omega]\), 
      \[CapitalLambda]\_\(2, 6\) \[Rule] 
        \(2\ I\ \[Delta]\ 
            \((\[Omega] + \[CapitalOmega])\)\)\/\(\[CapitalOmega]\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\), 
      \[CapitalLambda]\_\(1, 6\) \[Rule] 
        \(2\ \[Delta]\)\/\(\[CapitalOmega]\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\), 
      \[CapitalLambda]\_\(1, 8\) \[Rule] 
        \(2\ \[Delta]\)\/\(2\ \[Omega]\ \[CapitalOmega] + 
            \[CapitalOmega]\^2\), 
      \[CapitalLambda]\_\(2, 8\) \[Rule] 
        \(-\(\(2\ I\ \[Delta]\ 
                \((\[Omega] + \[CapitalOmega])\)\)\/\(2\ \[Omega]\ 
                  \[CapitalOmega] + \[CapitalOmega]\^2\)\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol2Form",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into either of the two ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and collecting the coefficients of ",
  StyleBox["RT",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the following set of algebraic equations:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(algEqs2 = 
      Coefficient[Subtract\ @@\ order2Eqm[\([1]\)] /. sol2Form, RT] == 0 /. 
          Exp[_\ T\_0] -> 0 // Thread\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\(-\[Mu]\) + 2\ I\ \[Omega]\ \[CapitalGamma]\_1 == 0, 
      \(I\ \[Delta]\)\/\[Omega] + I\ \[CapitalOmega]\ \[CapitalGamma]\_2 == 0}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Solving ",
  StyleBox["algEqs2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " for the undetermined coefficients ",
  StyleBox["RTsymbolList",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef2a = \(Solve[algEqs2, RTsymbolList]\)[\([1]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalGamma]\_1 \[Rule] \(-\(\(I\ \[Mu]\)\/\(2\ \[Omega]\)\)\), 
      \[CapitalGamma]\_2 \[Rule] 
        \(-\(\[Delta]\/\(\[Omega]\ \[CapitalOmega]\)\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef2 = Join[coef2a, coef2a /. conjugateRule]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalGamma]\_1 \[Rule] \(-\(\(I\ \[Mu]\)\/\(2\ \[Omega]\)\)\), 
      \[CapitalGamma]\_2 \[Rule] 
        \(-\(\[Delta]\/\(\[Omega]\ \[CapitalOmega]\)\)\), 
      \[CapitalGamma]\&_\_1 \[Rule] \(I\ \[Mu]\)\/\(2\ \[Omega]\), 
      \[CapitalGamma]\&_\_2 \[Rule] 
        \(-\(\[Delta]\/\(\[Omega]\ \[CapitalOmega]\)\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting ",
  StyleBox["coef1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["coef2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["sol2Form",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the solution of the second-order equations in pure function \
form as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2b = 
      sol2Form /. 
        Function[{T\_0, T\_1, T\_2}, b_] :> 
          Function[{T\_0, T\_1, T\_2} // Evaluate, 
            \(\(b /. coef1\) /. coef2 // Expand\) // Evaluate]; \n
    sol2b /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u\_2 \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(-\(\(2\ \[Delta]\ \[CapitalLambda]\^2\)\/\[Omega]\^2\)\) - 
            \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                \[CapitalLambda]\^2\)\/\(\[Omega]\^2 - 
                4\ \[CapitalOmega]\^2\) - 
            \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                \[CapitalLambda]\^2\)\/\(\[Omega]\^2 - 
                4\ \[CapitalOmega]\^2\) + 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
                \[Mu]\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
                \[CapitalOmega]\^2\) - 
            \(2\ I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
                \[CapitalOmega]\)\/\(\[Omega]\^2 - \[CapitalOmega]\^2\) - 
            \(I\ E\^\(I\ T\_0\ \[Omega]\)\ \[Mu]\ A\)\/\(2\ \[Omega]\) - 
            \(E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                \[CapitalLambda]\ A\)\/\(\[Omega]\ \[CapitalOmega]\) + 
            \(2\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ A\)\/\(\[CapitalOmega]\ 
                \((2\ \[Omega] + \[CapitalOmega])\)\) + 
            \(E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\^2\)\/\(3\ 
                \[Omega]\^2\) + 
            \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ A\&_\)\/\(2\ 
                \[Omega]\) - 
            \(E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ A\&_\)\/\(\[Omega]\ 
                \[CapitalOmega]\) + 
            \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ 
                A\&_\)\/\(2\ \[Omega]\ \[CapitalOmega] + 
                \[CapitalOmega]\^2\) - 
            \(2\ \[Delta]\ A\ A\&_\)\/\[Omega]\^2 + 
            \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
                \[Omega]\^2\)], 
      v\_2 \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(2\ I\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                \[CapitalLambda]\^2\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
                4\ \[CapitalOmega]\^2\) - 
            \(2\ I\ E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                \[CapitalLambda]\^2\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
                4\ \[CapitalOmega]\^2\) + 
            \(2\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
                \[Mu]\ \[CapitalOmega]\^2\)\/\(\[Omega]\^2 - 
                \[CapitalOmega]\^2\) + 
            \(2\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ \[Mu]\ 
                \[CapitalOmega]\^2\)\/\(\[Omega]\^2 - \[CapitalOmega]\^2\) - 
            1\/2\ E\^\(I\ T\_0\ \[Omega]\)\ \[Mu]\ A - 
            \(I\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ A\)\/\[CapitalOmega] + 
            \(2\ I\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ A\)\/\(2\ \[Omega] + 
                \[CapitalOmega]\) + 
            \(2\ I\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ \[Omega]\ A\)\/\(\[CapitalOmega]\ 
                \((2\ \[Omega] + \[CapitalOmega])\)\) + 
            \(2\ I\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\^2\)\/\(3\ 
                \[Omega]\) - 
            1\/2\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ A\&_ + 
            \(I\ E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ A\&_\)\/\[CapitalOmega] - 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ \[Omega]\ 
                A\&_\)\/\(2\ \[Omega]\ \[CapitalOmega] + 
                \[CapitalOmega]\^2\) - 
            \(2\ I\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                \[Delta]\ \[CapitalLambda]\ \[CapitalOmega]\ 
                A\&_\)\/\(2\ \[Omega]\ \[CapitalOmega] + 
                \[CapitalOmega]\^2\) - 
            \(2\ I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3
                \ \[Omega]\)]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["These two approaches generate the same results because", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Subtract\ @@\ \((u\_2[T\_0, T\_1, T\_2] /. {sol2a, sol2b})\) // Simplify
      \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(0\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Subtract\ @@\ \((v\_2[T\_0, T\_1, T\_2] /. {sol2a, sol2b})\) // Simplify
      \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(0\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
The second approach is more convenient to use for a general system of \
equations. Hence, we will adopt this approach in the remainder of this \
book.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["Third-Order Equations", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the first- and second-order solutions into the third-order \
equations, ",
  StyleBox["eqOrder[3]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order3Eq = \(eqOrder[3] /. sol1\) /. sol2b // ExpandAll; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using the ",
  StyleBox["expRule1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " to convert the terms that produce small-divisor terms into terms that \
produce secular terms in the right-hand sides of ",
  StyleBox["order3Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and collecting the terms that could produce secular terms, we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(STerms2 = 
      \(Coefficient[
            \(#[\([2]\)] /. expRule1\) /. \[CapitalOmega] -> 2\ \[Omega], 
            Exp[I\ \[Omega]\ T\_0]]\ &\)\ /@\ order3Eq; \n
    STerms2 /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{"I", " ", "\[Mu]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\),
                  SequenceForm[ 
                    Subscript[ D, 1], A],
                  Editable->False], ")"}]}], \(2\ \[Omega]\)], "+", 
          FractionBox[
            RowBox[{
            \(E\^\(I\ T\_1\ \[Sigma]\)\), " ", "\[Delta]", " ", 
              "\[CapitalLambda]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    OverBar[ A]],
                  Editable->False], ")"}]}], \(2\ \[Omega]\^2\)], "-", 
          InterpretationBox[\(D\_2\[InvisibleSpace]A\),
            SequenceForm[ 
              Subscript[ D, 2], A],
            Editable->False]}], ",", 
        RowBox[{
        \(\(-6\)\ A\ \[Alpha]\ \[CapitalLambda]\^2\), "+", \(A\ \[Mu]\^2\), 
          "+", \(\(9\ A\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(2\ 
                \[Omega]\^2\)\), "-", \(3\ A\^2\ \[Alpha]\ A\&_\), "+", 
          \(\(10\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^2\)\), "-", 
          \(\(14\ I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ 
                \[Mu]\ A\&_\)\/\(3\ \[Omega]\)\), "+", 
          RowBox[{\(1\/2\), " ", "\[Mu]", " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_1\[InvisibleSpace]A\),
                SequenceForm[ 
                  Subscript[ D, 1], A],
                Editable->False], ")"}]}], "-", 
          FractionBox[
            RowBox[{
            "I", " ", \(E\^\(I\ T\_1\ \[Sigma]\)\), " ", "\[Delta]", " ", 
              "\[CapitalLambda]", " ", 
              RowBox[{"(", 
                InterpretationBox[\(D\_1\[InvisibleSpace]A\&_\),
                  SequenceForm[ 
                    Subscript[ D, 1], 
                    OverBar[ A]],
                  Editable->False], ")"}]}], \(2\ \[Omega]\)], "-", 
          RowBox[{"I", " ", "\[Omega]", " ", 
            RowBox[{"(", 
              InterpretationBox[\(D\_2\[InvisibleSpace]A\),
                SequenceForm[ 
                  Subscript[ D, 2], A],
                Editable->False], ")"}]}]}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Then, the solvability condition demands that ",
  StyleBox["STerms2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " be orthogonal to the solution of the adjoint ",
  StyleBox["ccleftVec",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". The result is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond2", "=", 
        RowBox[{
          RowBox[{
            RowBox[{"Solve", "[", 
              RowBox[{\(ccleftVec . STerms2 == 0\), ",", 
                RowBox[{
                  SuperscriptBox["A", 
                    TagBox[\((0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
              "]"}], "[", \([1]\), "]"}], "//", "ExpandAll"}]}], ";", "\n", 
      \(SCond2 /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(D\_2\[InvisibleSpace]A\),
          SequenceForm[ 
            Subscript[ D, 2], A],
          Editable->False], "\[Rule]", 
        \(\(-\(\(9\ I\ A\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(4\ 
                  \[Omega]\^3\)\)\) + 
          \(3\ I\ A\ \[Alpha]\ \[CapitalLambda]\^2\)\/\[Omega] - 
          \(I\ A\ \[Mu]\^2\)\/\(2\ \[Omega]\) - 
          \(5\ I\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^3\) - 
          \(7\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ \[Mu]\ 
              A\&_\)\/\(3\ \[Omega]\^2\) + 
          \(3\ I\ A\^2\ \[Alpha]\ A\&_\)\/\(2\ \[Omega]\)\)}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The two partial-differential equations, ",
  StyleBox["SCond1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["SCond2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", can be reconstituted to obtain an ordinary-differential equation \
governing ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ". The result is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((2\ I\ \[Omega]\ A\^\[Prime] == 
          \((\(\(2\ I\ \[Omega]\ \(dt[1]\)[A[T\_1, T\_2]] /. SCond1\) /. 
                  SCond2 // Expand\) // Collect[#, \[Epsilon]]\ &)\))\) /. 
      displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
        SuperscriptBox["A", "\[Prime]",
          MultilineFunction->None]}], "==", 
      \(\[Epsilon]\ 
          \((\(-2\)\ I\ A\ \[Mu]\ \[Omega] - 
              2\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ A\&_)
            \) + \[Epsilon]\^2\ 
          \((\(-6\)\ A\ \[Alpha]\ \[CapitalLambda]\^2 + A\ \[Mu]\^2 + 
              \(9\ A\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(2\ 
                  \[Omega]\^2\) - 3\ A\^2\ \[Alpha]\ A\&_ + 
              \(10\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^2\) - 
              \(14\ I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ 
                  \[Mu]\ A\&_\)\/\(3\ \[Omega]\))\)\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.2.6 First-Order Complex-Valued System", "Subsection",
  Evaluatable->False,
  TextAlignment->Left,
  TextJustification->1,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],

Cell[TextData[{
  "In this section, we first transform ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into a single first-order complex-valued equation using the \
transformation"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(transformRule = {u -> \((\[Zeta] + \[Zeta]\&_)\), 
        u\^\[Prime] -> I\ \[Omega]\ \((\[Zeta] - \[Zeta]\&_)\)}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(gRule = 
      g -> \(-\ 2\)\ \[Epsilon]\ \[Mu]\ u\^\[Prime] - \[Delta]\ u\^2 - 
          \[Alpha]\ u\^3 + \[Epsilon]\ f\ Cos[\[CapitalOmega]\ t]; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "then ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " becomes"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq426a = 
      \(\[Zeta]\^\[Prime] == I\ \[Omega]\ \[Zeta] - I\/\(2\ \[Omega]\)\ g /. 
            gRule\) /. transformRule // ExpandAll\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      SuperscriptBox["\[Zeta]", "\[Prime]",
        MultilineFunction->None], "==", 
      \(\(-\[Epsilon]\)\ \[Zeta]\ \[Mu] + 
        \(I\ \[Delta]\ \[Zeta]\^2\)\/\(2\ \[Omega]\) + 
        \(I\ \[Alpha]\ \[Zeta]\^3\)\/\(2\ \[Omega]\) + I\ \[Zeta]\ \[Omega] - 
        \(I\ f\ \[Epsilon]\ Cos[t\ \[CapitalOmega]]\)\/\(2\ \[Omega]\) + 
        \[Epsilon]\ \[Mu]\ \[Zeta]\&_ + 
        \(I\ \[Delta]\ \[Zeta]\ \[Zeta]\&_\)\/\[Omega] + 
        \(3\ I\ \[Alpha]\ \[Zeta]\^2\ \[Zeta]\&_\)\/\(2\ \[Omega]\) + 
        \(I\ \[Delta]\ \[Zeta]\&_\^2\)\/\(2\ \[Omega]\) + 
        \(3\ I\ \[Alpha]\ \[Zeta]\ \[Zeta]\&_\^2\)\/\(2\ \[Omega]\) + 
        \(I\ \[Alpha]\ \[Zeta]\&_\^3\)\/\(2\ \[Omega]\)\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "To determine a second-order uniform expansion of the solution of ",
  StyleBox["eq426a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " using the method of multiple scales, we first introduce"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"multiScales", "=", 
        RowBox[{"{", 
          RowBox[{
          \(\[Zeta] -> \[Zeta][T\_0, T\_1, T\_2]\), ",", 
            \(\[Zeta]\&_ -> \[Zeta]\&_[T\_0, T\_1, T\_2]\), ",", 
            RowBox[{
              SuperscriptBox["\[Zeta]", "\[Prime]",
                MultilineFunction->None], "->", 
              \(\(dt[1]\)[\[Zeta][T\_0, T\_1, T\_2]]\)}], ",", 
            \(t -> T\_0\)}], "}"}]}], ";"}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "and then expand \[Zeta] and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Zeta]\&_\)]],
  " in the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(solRule = {
        \[Zeta] -> 
          \((Sum[\[Epsilon]\^j\ \[Zeta]\_j[#1, #2, #3], {j, 1, 3}]\ &)\), 
        \[Zeta]\&_ -> 
          \((Sum[\(\[Epsilon]\^j\) \[Zeta]\&_\_j[#1, #2, #3], {j, 1, 3}]\ &)
            \)}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting ",
  StyleBox["multiScales",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["solRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eq426a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expanding the result for small \[Epsilon], and discarding terms of order \
higher than ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Epsilon]\^3, \)\)]],
  " we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq426b = 
      \((\(eq426a /. multiScales\) /. solRule // ExpandAll)\) /. 
        \[Epsilon]\^\(n_ /; n > 3\) -> 0; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[
"Equating coefficients of like powers of \[Epsilon] yields"], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eqEps = 
      \(\(CoefficientList[Subtract\ @@\ eq426b, \[Epsilon]] == 0 // Thread
            \) // Rest\) // TrigToExp; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
To place the linear operator on one side and the nonhomogeneous terms on the \
other side, we define\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(eqOrder[i_] := 
      \(\((\(eqEps[\([1, 1]\)] /. f -> 0\) /. \[Zeta]\_1 -> \[Zeta]\_i)\) - #
              \ &\)\ /@\ eqEps[\([i]\)] // Reverse\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using ",
  StyleBox["eqOrder[i]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["displayRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we rewrite ",
  StyleBox["eqEps",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in a concise way as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[eqOrder, 3] /. displayRule // TableForm\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]\[Zeta]\_1\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ \[Zeta], 1]],
                  Editable->False], "-", \(I\ \[Omega]\ \[Zeta]\_1\)}], "==", 
              \(-\(\(I\ 
                      \((E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\) + 
                          E\^\(I\ T\_0\ \[CapitalOmega]\))\)\ f\)\/\(4\ 
                      \[Omega]\)\)\)}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]\[Zeta]\_2\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ \[Zeta], 2]],
                  Editable->False], "-", \(I\ \[Omega]\ \[Zeta]\_2\)}], 
              "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_1\[InvisibleSpace]\[Zeta]\_1\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ \[Zeta], 1]],
                      Editable->False], ")"}]}], "-", \(\[Mu]\ \[Zeta]\_1\), 
                "+", \(\(I\ \[Delta]\ \[Zeta]\_1\%2\)\/\(2\ \[Omega]\)\), 
                "+", \(\[Mu]\ \[Zeta]\&_\_1\), "+", 
                \(\(I\ \[Delta]\ \[Zeta]\_1\ \[Zeta]\&_\_1\)\/\[Omega]\), 
                "+", \(\(I\ \[Delta]\ \[Zeta]\&_\_1\%2\)\/\(2\ 
                      \[Omega]\)\)}]}]},
          {
            RowBox[{
              RowBox[{
                InterpretationBox[\(D\_0\[InvisibleSpace]\[Zeta]\_3\),
                  SequenceForm[ 
                    Subscript[ D, 0], 
                    Subscript[ \[Zeta], 3]],
                  Editable->False], "-", \(I\ \[Omega]\ \[Zeta]\_3\)}], 
              "==", 
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    InterpretationBox[\(D\_1\[InvisibleSpace]\[Zeta]\_2\),
                      SequenceForm[ 
                        Subscript[ D, 1], 
                        Subscript[ \[Zeta], 2]],
                      Editable->False], ")"}]}], "-", 
                InterpretationBox[\(D\_2\[InvisibleSpace]\[Zeta]\_1\),
                  SequenceForm[ 
                    Subscript[ D, 2], 
                    Subscript[ \[Zeta], 1]],
                  Editable->False], "+", 
                \(\(I\ \[Alpha]\ \[Zeta]\_1\%3\)\/\(2\ \[Omega]\)\), "-", 
                \(\[Mu]\ \[Zeta]\_2\), "+", 
                \(\(I\ \[Delta]\ \[Zeta]\_1\ \[Zeta]\_2\)\/\[Omega]\), "+", 
                \(\(3\ I\ \[Alpha]\ \[Zeta]\_1\%2\ \[Zeta]\&_\_1\)\/\(2\ 
                      \[Omega]\)\), "+", 
                \(\(I\ \[Delta]\ \[Zeta]\_2\ \[Zeta]\&_\_1\)\/\[Omega]\), 
                "+", \(\(3\ I\ \[Alpha]\ \[Zeta]\_1\ \[Zeta]\&_\_1\%2\)\/\(2\ 
                      \[Omega]\)\), "+", 
                \(\(I\ \[Alpha]\ \[Zeta]\&_\_1\%3\)\/\(2\ \[Omega]\)\), "+", 
                \(\[Mu]\ \[Zeta]\&_\_2\), "+", 
                \(\(I\ \[Delta]\ \[Zeta]\_1\ \[Zeta]\&_\_2\)\/\[Omega]\), 
                "+", \(\(I\ \[Delta]\ \[Zeta]\&_\_1\ 
                      \[Zeta]\&_\_2\)\/\[Omega]\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ \[Zeta], 1]], 
            Times[ 
              Complex[ 0, -1], \[Omega], 
              Subscript[ \[Zeta], 1]]], 
          Times[ 
            Complex[ 0, 
              Rational[ -1, 4]], 
            Plus[ 
              Power[ E, 
                Times[ 
                  Complex[ 0, -1], T\[UnderBracket]Subscript\[UnderBracket]0, 
                  \[CapitalOmega]]], 
              Power[ E, 
                Times[ 
                  Complex[ 0, 1], T\[UnderBracket]Subscript\[UnderBracket]0, 
                  \[CapitalOmega]]]], f, 
            Power[ \[Omega], -1]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ \[Zeta], 2]], 
            Times[ 
              Complex[ 0, -1], \[Omega], 
              Subscript[ \[Zeta], 2]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ \[Zeta], 1]]], 
            Times[ -1, \[Mu], 
              Subscript[ \[Zeta], 1]], 
            Times[ 
              Complex[ 0, 
                Rational[ 1, 2]], \[Delta], 
              Power[ \[Omega], -1], 
              Power[ 
                Subscript[ \[Zeta], 1], 2]], 
            Times[ \[Mu], 
              Subscript[ 
                OverBar[ \[Zeta]], 1]], 
            Times[ 
              Complex[ 0, 1], \[Delta], 
              Power[ \[Omega], -1], 
              Subscript[ \[Zeta], 1], 
              Subscript[ 
                OverBar[ \[Zeta]], 1]], 
            Times[ 
              Complex[ 0, 
                Rational[ 1, 2]], \[Delta], 
              Power[ \[Omega], -1], 
              Power[ 
                Subscript[ 
                  OverBar[ \[Zeta]], 1], 2]]]], 
        Equal[ 
          Plus[ 
            SequenceForm[ 
              Subscript[ D, 0], 
              Subscript[ \[Zeta], 3]], 
            Times[ 
              Complex[ 0, -1], \[Omega], 
              Subscript[ \[Zeta], 3]]], 
          Plus[ 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 1], 
                Subscript[ \[Zeta], 2]]], 
            Times[ -1, 
              SequenceForm[ 
                Subscript[ D, 2], 
                Subscript[ \[Zeta], 1]]], 
            Times[ 
              Complex[ 0, 
                Rational[ 1, 2]], \[Alpha], 
              Power[ \[Omega], -1], 
              Power[ 
                Subscript[ \[Zeta], 1], 3]], 
            Times[ -1, \[Mu], 
              Subscript[ \[Zeta], 2]], 
            Times[ 
              Complex[ 0, 1], \[Delta], 
              Power[ \[Omega], -1], 
              Subscript[ \[Zeta], 1], 
              Subscript[ \[Zeta], 2]], 
            Times[ 
              Complex[ 0, 
                Rational[ 3, 2]], \[Alpha], 
              Power[ \[Omega], -1], 
              Power[ 
                Subscript[ \[Zeta], 1], 2], 
              Subscript[ 
                OverBar[ \[Zeta]], 1]], 
            Times[ 
              Complex[ 0, 1], \[Delta], 
              Power[ \[Omega], -1], 
              Subscript[ \[Zeta], 2], 
              Subscript[ 
                OverBar[ \[Zeta]], 1]], 
            Times[ 
              Complex[ 0, 
                Rational[ 3, 2]], \[Alpha], 
              Power[ \[Omega], -1], 
              Subscript[ \[Zeta], 1], 
              Power[ 
                Subscript[ 
                  OverBar[ \[Zeta]], 1], 2]], 
            Times[ 
              Complex[ 0, 
                Rational[ 1, 2]], \[Alpha], 
              Power[ \[Omega], -1], 
              Power[ 
                Subscript[ 
                  OverBar[ \[Zeta]], 1], 3]], 
            Times[ \[Mu], 
              Subscript[ 
                OverBar[ \[Zeta]], 2]], 
            Times[ 
              Complex[ 0, 1], \[Delta], 
              Power[ \[Omega], -1], 
              Subscript[ \[Zeta], 1], 
              Subscript[ 
                OverBar[ \[Zeta]], 2]], 
            Times[ 
              Complex[ 0, 1], \[Delta], 
              Power[ \[Omega], -1], 
              Subscript[ 
                OverBar[ \[Zeta]], 1], 
              Subscript[ 
                OverBar[ \[Zeta]], 2]]]]}]]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The general solution of the first-order equation, ",
  StyleBox["eqOrder[1]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", can be expressed in pure function form as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1Form = 
      \(\((\(DSolve[eqOrder[1], \[Zeta]\_1[T\_0, T\_1, T\_2], timeScales]\)[
                  \([1, 1, 2]\)] /. C[1] -> A // Expand)\) /. 
          Exp[a_] :> Exp[a // Expand]\) //. 
        c1_\ Exp[x_] + c2_\ Exp[x_] :> Factor[c1 + c2]\ Exp[x]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(E\^\(I\ T\_0\ \[CapitalOmega]\)\ f\)\/\(4\ \[Omega]\ 
          \((\[Omega] - \[CapitalOmega])\)\) + 
      \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ f\)\/\(4\ \[Omega]\ 
          \((\[Omega] + \[CapitalOmega])\)\) + 
      E\^\(I\ T\_0\ \[Omega]\)\ A[T\_1, T\_2]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = {
        \[Zeta]\_1 -> Function[{T\_0, T\_1, T\_2}, sol1Form // Evaluate], 
        \[Zeta]\&_\_1 -> 
          Function[{T\_0, T\_1, T\_2}, sol1Form /. conjugateRule // Evaluate]}
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Zeta]\_1 \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(E\^\(I\ T\_0\ \[CapitalOmega]\)\ f\)\/\(4\ \[Omega]\ 
                \((\[Omega] - \[CapitalOmega])\)\) + 
            \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ f\)\/\(4\ \[Omega]\ 
                \((\[Omega] + \[CapitalOmega])\)\) + 
            E\^\(I\ T\_0\ \[Omega]\)\ A[T\_1, T\_2]], 
      \[Zeta]\&_\_1 \[Rule] 
        Function[{T\_0, T\_1, T\_2}, 
          \(E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ f\)\/\(4\ \[Omega]\ 
                \((\[Omega] - \[CapitalOmega])\)\) + 
            \(E\^\(I\ T\_0\ \[CapitalOmega]\)\ f\)\/\(4\ \[Omega]\ 
                \((\[Omega] + \[CapitalOmega])\)\) + 
            E\^\(\(-I\)\ T\_0\ \[Omega]\)\ A\&_[T\_1, T\_2]]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting the first-order solution into the second-order equation, ",
  StyleBox["eqOrder[2]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2Eq = Expand\ /@\ \((eqOrder[2] /. sol1)\); \n
    order2Eq /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
        InterpretationBox[\(D\_0\[InvisibleSpace]\[Zeta]\_2\),
          SequenceForm[ 
            Subscript[ D, 0], 
            Subscript[ \[Zeta], 2]],
          Editable->False], "-", \(I\ \[Omega]\ \[Zeta]\_2\)}], "==", 
      RowBox[{
      \(\(-A\)\ E\^\(I\ T\_0\ \[Omega]\)\ \[Mu]\), "+", 
        \(\(I\ A\^2\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\)\/\(2\ 
              \[Omega]\)\), "+", 
        \(\(I\ f\^2\ \[Delta]\)\/\(16\ \[Omega]\^3\ 
              \((\[Omega] - \[CapitalOmega])\)\^2\)\), "+", 
        \(\(I\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(32
              \ \[Omega]\^3\ \((\[Omega] - \[CapitalOmega])\)\^2\)\), "+", 
        \(\(I\ E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(32\ 
              \[Omega]\^3\ \((\[Omega] - \[CapitalOmega])\)\^2\)\), "+", 
        \(\(I\ A\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ f\ 
              \[Delta]\)\/\(4\ \[Omega]\^2\ 
              \((\[Omega] - \[CapitalOmega])\)\)\), "+", 
        \(\(I\ A\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ f\ 
              \[Delta]\)\/\(4\ \[Omega]\^2\ 
              \((\[Omega] - \[CapitalOmega])\)\)\), "+", 
        \(\(E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\)\/\(4\ \[Omega]\ 
              \((\[Omega] - \[CapitalOmega])\)\)\), "-", 
        \(\(E\^\(I\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\)\/\(4\ \[Omega]\ 
              \((\[Omega] - \[CapitalOmega])\)\)\), "+", 
        \(\(I\ f\^2\ \[Delta]\)\/\(16\ \[Omega]\^3\ 
              \((\[Omega] + \[CapitalOmega])\)\^2\)\), "+", 
        \(\(I\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(32
              \ \[Omega]\^3\ \((\[Omega] + \[CapitalOmega])\)\^2\)\), "+", 
        \(\(I\ E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(32\ 
              \[Omega]\^3\ \((\[Omega] + \[CapitalOmega])\)\^2\)\), "+", 
        \(\(I\ A\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ f\ 
              \[Delta]\)\/\(4\ \[Omega]\^2\ 
              \((\[Omega] + \[CapitalOmega])\)\)\), "+", 
        \(\(I\ A\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ f\ 
              \[Delta]\)\/\(4\ \[Omega]\^2\ 
              \((\[Omega] + \[CapitalOmega])\)\)\), "-", 
        \(\(E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\)\/\(4\ \[Omega]\ 
              \((\[Omega] + \[CapitalOmega])\)\)\), "+", 
        \(\(E\^\(I\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\)\/\(4\ \[Omega]\ 
              \((\[Omega] + \[CapitalOmega])\)\)\), "+", 
        \(\(I\ f\^2\ \[Delta]\)\/\(8\ \[Omega]\^3\ 
              \((\[Omega] - \[CapitalOmega])\)\ 
              \((\[Omega] + \[CapitalOmega])\)\)\), "+", 
        \(\(I\ E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(16
              \ \[Omega]\^3\ \((\[Omega] - \[CapitalOmega])\)\ 
              \((\[Omega] + \[CapitalOmega])\)\)\), "+", 
        \(\(I\ E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(16\ 
              \[Omega]\^3\ \((\[Omega] - \[CapitalOmega])\)\ 
              \((\[Omega] + \[CapitalOmega])\)\)\), "+", 
        \(E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ A\&_\), "+", 
        \(\(I\ A\ \[Delta]\ A\&_\)\/\[Omega]\), "+", 
        \(\(I\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ f\ 
              \[Delta]\ A\&_\)\/\(4\ \[Omega]\^2\ 
              \((\[Omega] - \[CapitalOmega])\)\)\), "+", 
        \(\(I\ E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ f\ 
              \[Delta]\ A\&_\)\/\(4\ \[Omega]\^2\ 
              \((\[Omega] - \[CapitalOmega])\)\)\), "+", 
        \(\(I\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ f\ 
              \[Delta]\ A\&_\)\/\(4\ \[Omega]\^2\ 
              \((\[Omega] + \[CapitalOmega])\)\)\), "+", 
        \(\(I\ E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ f\ 
              \[Delta]\ A\&_\)\/\(4\ \[Omega]\^2\ 
              \((\[Omega] + \[CapitalOmega])\)\)\), "+", 
        \(\(I\ E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(2\ 
              \[Omega]\)\), "-", 
        RowBox[{\(E\^\(I\ T\_0\ \[Omega]\)\), " ", 
          RowBox[{"(", 
            InterpretationBox[\(D\_1\[InvisibleSpace]A\),
              SequenceForm[ 
                Subscript[ D, 1], A],
              Editable->False], ")"}]}]}]}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Eliminating the terms that lead to secular terms in ",
  Cell[BoxData[
      \(TraditionalForm\`\[Zeta]\_2\)]],
  " from ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SCond1 = 
      Coefficient[order2Eq[\([2]\)] /. expRule1, Exp[I\ \[Omega]\ T\_0]] == 0
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\(-\[Mu]\)\ A[T\_1, T\_2]\), "+", 
        \(\(I\ E\^\(I\ T\_1\ \[Sigma]\)\ f\ \[Delta]\ A\&_[T\_1, T\_2]\)\/\(4
              \ \[Omega]\^2\ \((\[Omega] - \[CapitalOmega])\)\)\), "+", 
        \(\(I\ E\^\(I\ T\_1\ \[Sigma]\)\ f\ \[Delta]\ A\&_[T\_1, T\_2]\)\/\(4
              \ \[Omega]\^2\ \((\[Omega] + \[CapitalOmega])\)\)\), "-", 
        RowBox[{
          SuperscriptBox["A", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], "==", 
      "0"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["or", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"SCond1Rule", "=", 
      RowBox[{
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"Solve", "[", 
                RowBox[{"SCond1", ",", 
                  RowBox[{
                    SuperscriptBox["A", 
                      TagBox[\((1, 0)\),
                        Derivative],
                      MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}]}], 
                "]"}], "[", \([1]\), "]"}], "//", "ExpandAll"}], ")"}], "/.", 
        \(c1_\ \[Mu] + c2_\ \[Mu] :> Factor[c1 + c2]\ \[Mu]\)}]}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox["A", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(T\_1, T\_2\), "]"}], "\[Rule]", 
        \(\(-\[Mu]\)\ A[T\_1, T\_2] + 
          \(I\ E\^\(I\ T\_1\ \[Sigma]\)\ f\ \[Delta]\ 
              A\&_[T\_1, T\_2]\)\/\(2\ \[Omega]\^3 - 
              2\ \[Omega]\ \[CapitalOmega]\^2\)\)}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "With this solvability condition, we rewrite ",
  StyleBox["order2Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order2Eqm = 
      Expand\ /@\ 
        \((\(order2Eq /. SCond1Rule\) /. 
            Exp[arg_] :> 
              Exp[\(arg /. T\_1 -> \[Epsilon]\ T\_0\) /. sigRule // Expand])
          \); \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "There are at least two approaches we can use to solve for the particular \
solution of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". In the first approach, we transform ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into an ordinary-differential equation and then use ",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  " and ",
  StyleBox["Map",
    FontWeight->"Bold"],
  " to determine the following particular solution:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((sol2a = 
          \(\((\(\[Zeta]\_2[T\_0] /. 
                        \(DSolve[
                            \((order2Eqm[\([1]\)] /. 
                                  \[Zeta]\_2 -> \((\[Zeta]\_2[#1]\ &)\))
                                \) == #, \[Zeta]\_2[T\_0], T\_0]\)[\([1]\)]
                          \) /. C[_] -> 0)\)\ &\)\ /@\ order2Eqm[\([2]\)] /. 
              Exp[a_] :> Exp[Expand[a]] // Expand)\) // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({6.62900000000001909`\ Second, 
      \(-\(\(f\^2\ \[Delta]\)\/\(16\ \[Omega]\^4\ 
                \((\[Omega] - \[CapitalOmega])\)\^2\)\)\) - 
        \(I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\)\/\(4\ \[Omega]\ 
            \((\[Omega] - \[CapitalOmega])\)\^2\) - 
        \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(32\ 
            \[Omega]\^3\ \((\[Omega] - 2\ \[CapitalOmega])\)\ 
            \((\[Omega] - \[CapitalOmega])\)\^2\) - 
        \(f\^2\ \[Delta]\)\/\(16\ \[Omega]\^4\ 
            \((\[Omega] + \[CapitalOmega])\)\^2\) - 
        \(I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\)\/\(4\ \[Omega]\ 
            \((\[Omega] + \[CapitalOmega])\)\^2\) - 
        \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(32\ 
            \[Omega]\^3\ \((\[Omega] - 2\ \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\^2\) - 
        \(f\^2\ \[Delta]\)\/\(8\ \[Omega]\^4\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\) + 
        \(I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\)\/\(4\ \[Omega]\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\) + 
        \(I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\)\/\(4\ \[Omega]\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\) - 
        \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(16\ 
            \[Omega]\^3\ \((\[Omega] - 2\ \[CapitalOmega])\)\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\) - 
        \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(32\ 
            \[Omega]\^3\ \((\[Omega] - \[CapitalOmega])\)\^2\ 
            \((\[Omega] + 2\ \[CapitalOmega])\)\) - 
        \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(32\ 
            \[Omega]\^3\ \((\[Omega] + \[CapitalOmega])\)\^2\ 
            \((\[Omega] + 2\ \[CapitalOmega])\)\) - 
        \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(16\ 
            \[Omega]\^3\ \((\[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\ 
            \((\[Omega] + 2\ \[CapitalOmega])\)\) - 
        \(E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ f\ \[Delta]\ 
            A[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] - \[CapitalOmega])\)\ \[CapitalOmega]\) + 
        \(E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ f\ \[Delta]\ 
            A[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] - \[CapitalOmega])\)\ \[CapitalOmega]\) - 
        \(E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ f\ \[Delta]\ 
            A[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ \[CapitalOmega]\ 
            \((\[Omega] + \[CapitalOmega])\)\) + 
        \(E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ f\ \[Delta]\ 
            A[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ \[CapitalOmega]\ 
            \((\[Omega] + \[CapitalOmega])\)\) + 
        \(E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A[T\_1, T\_2]\^2\)\/\(2\ 
            \[Omega]\^2\) + 
        \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ A\&_[T\_1, T\_2]\)\/\(2\ 
            \[Omega]\) - 
        \(E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ f\ 
            \[Delta]\ A\&_[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((2\ \[Omega] - \[CapitalOmega])\)\) - 
        \(E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ f\ 
            \[Delta]\ A\&_[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ 
            \((2\ \[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\) - 
        \(E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ f\ 
            \[Delta]\ A\&_[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\) - 
        \(E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ f\ 
            \[Delta]\ A\&_[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] + \[CapitalOmega])\)\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\) + 
        \(E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ f\ 
            \[Delta]\ A\&_[T\_1, T\_2]\)\/\(2\ \[Omega]\ 
            \((2\ \[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega]\^2 - \[CapitalOmega]\^2)\)\) - 
        \(\[Delta]\ A[T\_1, T\_2]\ A\&_[T\_1, T\_2]\)\/\[Omega]\^2 - 
        \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ 
            A\&_[T\_1, T\_2]\^2\)\/\(6\ \[Omega]\^2\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "In the second approach, we multiply ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " by an integrating factor and then use the function ",
  StyleBox["Integrate.",
    FontWeight->"Bold"],
  " To reduce the computation time, we define first the rule"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(intRule = int[a_ + b_, arg_] -> int[a, arg] + int[b, arg]; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Then, using this rule and an integrating factor, we find a particular \
solution of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((sol2b = 
          \((\((\(int[order2Eqm[\([2]\)]*Exp[\(-I\)\ T\_0\ \[Omega]] // 
                            Expand, T\_0] //. intRule\) /. int -> Integrate)
                    \)*Exp[I\ T\_0\ \[Omega]] // Expand)\) /. 
            Exp[a_] :> Exp[Expand[a]])\) // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({0.841000000000008185`\ Second, 
      \(-\(\(f\^2\ \[Delta]\)\/\(16\ \[Omega]\^4\ 
                \((\[Omega] - \[CapitalOmega])\)\^2\)\)\) - 
        \(I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\)\/\(4\ \[Omega]\ 
            \((\[Omega] - \[CapitalOmega])\)\^2\) - 
        \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(32\ 
            \[Omega]\^3\ \((\[Omega] - 2\ \[CapitalOmega])\)\ 
            \((\[Omega] - \[CapitalOmega])\)\^2\) - 
        \(f\^2\ \[Delta]\)\/\(16\ \[Omega]\^4\ 
            \((\[Omega] + \[CapitalOmega])\)\^2\) - 
        \(I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\)\/\(4\ \[Omega]\ 
            \((\[Omega] + \[CapitalOmega])\)\^2\) - 
        \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(32\ 
            \[Omega]\^3\ \((\[Omega] - 2\ \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\^2\) - 
        \(f\^2\ \[Delta]\)\/\(8\ \[Omega]\^4\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\) + 
        \(I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\)\/\(4\ \[Omega]\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\) + 
        \(I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ f\ \[Mu]\)\/\(4\ \[Omega]\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\) - 
        \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(16\ 
            \[Omega]\^3\ \((\[Omega] - 2\ \[CapitalOmega])\)\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\) - 
        \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(32\ 
            \[Omega]\^3\ \((\[Omega] - \[CapitalOmega])\)\^2\ 
            \((\[Omega] + 2\ \[CapitalOmega])\)\) - 
        \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(32\ 
            \[Omega]\^3\ \((\[Omega] + \[CapitalOmega])\)\^2\ 
            \((\[Omega] + 2\ \[CapitalOmega])\)\) - 
        \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ f\^2\ \[Delta]\)\/\(16\ 
            \[Omega]\^3\ \((\[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\ 
            \((\[Omega] + 2\ \[CapitalOmega])\)\) - 
        \(E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ f\ \[Delta]\ 
            A[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] - \[CapitalOmega])\)\ \[CapitalOmega]\) + 
        \(E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ f\ \[Delta]\ 
            A[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] - \[CapitalOmega])\)\ \[CapitalOmega]\) - 
        \(E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ f\ \[Delta]\ 
            A[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ \[CapitalOmega]\ 
            \((\[Omega] + \[CapitalOmega])\)\) + 
        \(E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ f\ \[Delta]\ 
            A[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ \[CapitalOmega]\ 
            \((\[Omega] + \[CapitalOmega])\)\) + 
        \(E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A[T\_1, T\_2]\^2\)\/\(2\ 
            \[Omega]\^2\) + 
        \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ A\&_[T\_1, T\_2]\)\/\(2\ 
            \[Omega]\) - 
        \(E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ f\ 
            \[Delta]\ A\&_[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((2\ \[Omega] - \[CapitalOmega])\)\) - 
        \(E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ f\ 
            \[Delta]\ A\&_[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ 
            \((2\ \[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\) - 
        \(E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ f\ 
            \[Delta]\ A\&_[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\) - 
        \(E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ f\ 
            \[Delta]\ A\&_[T\_1, T\_2]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] + \[CapitalOmega])\)\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\) + 
        \(E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ f\ 
            \[Delta]\ A\&_[T\_1, T\_2]\)\/\(2\ \[Omega]\ 
            \((2\ \[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega]\^2 - \[CapitalOmega]\^2)\)\) - 
        \(\[Delta]\ A[T\_1, T\_2]\ A\&_[T\_1, T\_2]\)\/\[Omega]\^2 - 
        \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ 
            A\&_[T\_1, T\_2]\^2\)\/\(6\ \[Omega]\^2\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["The CPU time is decreased by a factor of", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(%%%[\([1]\)]/%[\([1]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(7.88228299643276475`\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2a === sol2b\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(True\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Then, the particular solution of ",
  StyleBox["order2Eqm",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " can be expressed in pure function form as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(sol2 = {
        \[Zeta]\_2 -> Function[{T\_0, T\_1, T\_2}, sol2b // Evaluate], 
        \[Zeta]\&_\_2 -> 
          Function[{T\_0, T\_1, T\_2}, sol2b /. conjugateRule // Evaluate]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the first- and second-order solutions into the third-order \
equation, ",
  StyleBox["eqOrder[3]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order3Eq = Expand\ /@\ \((\(eqOrder[3] /. sol1\) /. sol2)\); \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Eliminating the terms that produce secular terms in ",
  Cell[BoxData[
      \(TraditionalForm\`\[Zeta]\_3\)]],
  " from ",
  StyleBox["order3Eq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"SCond2Rule", "=", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{"Solve", "[", 
                      RowBox[{
                      \(Coefficient[order3Eq[\([2]\)] /. expRule1, 
                            Exp[I\ \[Omega]\ T\_0]] == 0\), ",", 
                        RowBox[{
                          SuperscriptBox["A", 
                            TagBox[\((0, 1)\),
                              Derivative],
                            MultilineFunction->None], "[", \(T\_1, T\_2\), 
                          "]"}]}], "]"}], "[", \([1]\), "]"}], "/.", 
                  "SCond1Rule"}], "/.", \((SCond1Rule /. conjugateRule)\)}], 
              "//", "ExpandAll"}], ")"}], "//.", 
          \({c1_\ \[Mu] + c2_\ \[Mu] :> Factor[c1 + c2]\ \[Mu], 
            c1_\ f\^2\ \[Delta]\^2 + c2_\ f\^2\ \[Delta]\^2 :> 
              Factor[c1 + c2]\ f\^2\ \[Delta]\^2, 
            c1_\ f\^2\ \[Alpha] + c2_\ f\^2\ \[Alpha] :> 
              Factor[c1 + c2]\ f\^2\ \[Alpha]}\)}]}], ";", "\n", 
      \(SCond2Rule /. displayRule\)}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(D\_2\[InvisibleSpace]A\),
          SequenceForm[ 
            Subscript[ D, 2], A],
          Editable->False], "\[Rule]", 
        \(\(-\(\(I\ A\ \[Mu]\^2\)\/\(2\ \[Omega]\)\)\) + 
          \(3\ I\ A\ f\^2\ \[Alpha]\)\/\(4\ \[Omega]\ 
              \((\[Omega] - \[CapitalOmega])\)\^2\ 
              \((\[Omega] + \[CapitalOmega])\)\^2\) - 
          \(I\ A\ f\^2\ \[Delta]\^2\ 
              \((5\ \[Omega] + 2\ \[CapitalOmega])\)\)\/\(4\ \[Omega]\^3\ 
              \((\[Omega] - \[CapitalOmega])\)\^2\ 
              \((\[Omega] + \[CapitalOmega])\)\^2\ 
              \((2\ \[Omega] + \[CapitalOmega])\)\) - 
          \(5\ I\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^3\) + 
          \(3\ I\ A\^2\ \[Alpha]\ A\&_\)\/\(2\ \[Omega]\) - 
          \(E\^\(I\ T\_1\ \[Sigma]\)\ f\ \[Delta]\ \[Mu]\ 
              \((2\ \[Omega]\^3 + \[Omega]\^2\ \[CapitalOmega] - 
                  6\ \[Omega]\ \[CapitalOmega]\^2 - \[CapitalOmega]\^3)\)\ 
              A\&_\)\/\(4\ \[Omega]\^2\ \((\[Omega] - \[CapitalOmega])\)\^2\ 
              \[CapitalOmega]\ \((\[Omega] + \[CapitalOmega])\)\^2\)\)}], 
      "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["or", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(fRule = {
        f -> 2 \((\[Omega]\^2 - \[CapitalOmega]\^2)\)\ \[CapitalLambda]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(SCond2Rule /. fRule\) /. \[CapitalOmega] -> 2  \[Omega]\) /. 
      displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(D\_2\[InvisibleSpace]A\),
          SequenceForm[ 
            Subscript[ D, 2], A],
          Editable->False], "\[Rule]", 
        \(\(-\(\(9\ I\ A\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(4\ 
                  \[Omega]\^3\)\)\) + 
          \(3\ I\ A\ \[Alpha]\ \[CapitalLambda]\^2\)\/\[Omega] - 
          \(I\ A\ \[Mu]\^2\)\/\(2\ \[Omega]\) - 
          \(5\ I\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^3\) - 
          \(7\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ \[Mu]\ 
              A\&_\)\/\(3\ \[Omega]\^2\) + 
          \(3\ I\ A\^2\ \[Alpha]\ A\&_\)\/\(2\ \[Omega]\)\)}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
which is in agreement with that obtained in the preceding section.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "4.2.7 The Function ",
  StyleBox["MMS1",
    FontColor->RGBColor[1, 0, 1]]
}], "Subsection",
  Evaluatable->False,
  TextAlignment->Left,
  TextJustification->1,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],

Cell[TextData[{
  "Collecting the steps described in Section 4.2.5 for a system of two \
real-valued first-order equations, we can build a function named ",
  StyleBox["MMS1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " (",
  StyleBox["M",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "ethod of ",
  StyleBox["M",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "ultiple ",
  StyleBox["S",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "cales for ",
  StyleBox["1",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "DOF system) specifically for ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". A more general function (a Package) can be similarly created by \
considering as arguments the governing equation, symbols for the dependent \
variable, independent variable, excitation amplitudes and frequencies, and \
all other related quantities which allow the program to identify their \
respective meanings. We then use ",
  StyleBox["MMS1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " to solve for different resonance cases."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
    \(MMS1[scaling_List, ResonanceCond : {__Equal}]\), ":=", "\n", "   ", 
      RowBox[{"Module", "[", 
        RowBox[{\({}\), ",", "\n", "\t\t", 
          RowBox[{
          \(vRule = \(u\^\[Prime]\)[t] -> v[t]\), ";", "\n", "     ", 
            \(OmgRule = \(Solve[ResonanceCond, \[CapitalOmega]]\)[\([1]\)]\), 
            ";", "\n", "\t\t", 
            \(eqa = {vRule /. Rule -> Equal, 
                \(\(FDuffingEq /. scaling\) /. vRule\) /. D[vRule, t]}\), 
            ";", "\n", "\t\t", 
            RowBox[{"multiScales", "=", 
              RowBox[{"{", 
                RowBox[{
                \(u[t] -> u[T\_0, T\_1, T\_2]\), ",", 
                  \(v[t] -> v[T\_0, T\_1, T\_2]\), ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["u_", "\[Prime]",
                        MultilineFunction->None], "[", "t", "]"}], "->", 
                    \(\(dt[1]\)[u[T\_0, T\_1, T\_2]]\)}], ",", 
                  \(t -> T\_0\)}], "}"}]}], ";", "\n", "\t\t", 
            \(solRule = {
                u -> \((Sum[\[Epsilon]\^j\ u\_j[#1, #2, #3], {j, 3}]\ &)\), 
                v -> \((Sum[\[Epsilon]\^j\ v\_j[#1, #2, #3], {j, 3}]\ &)\)}
                \), ";", "\n", "\t\t", 
            \(eqb = \((
                  \(\(eqa /. multiScales\) /. solRule // TrigToExp\) // 
                    ExpandAll)\) /. \[Epsilon]\^\(n_ /; n > 3\) -> 0\), ";", 
            "\n", "\t\t", 
            \(eqEps = 
              \(\(Thread[CoefficientList[Subtract\ @@\ #, \[Epsilon]] == 0]\ &
                      \)\ /@\ eqb // Transpose\) // Rest\), ";", "\n", 
            "\t\t", "\n", "\t  ", 
            StyleBox[\( (*\ First - Order\ Problem\ *) \),
              FontColor->RGBColor[0, 0, 1]], "\t\t", "\n", "\t\t", 
            \(linearSys = \(#[\([1]\)]\ &\)\ /@\ eqEps[\([1]\)] /. f -> 0\), 
            ";", "\n", "\t\t", 
            \(eqOrder[i_] := 
              \((linearSys /. u_\_1 -> u\_i)\) == 
                  \((linearSys /. u_\_1 -> u\_i)\) - 
                    \((\(#[\([1]\)]\ &\)\ /@\ eqEps[\([i]\)])\) // Thread\), 
            ";", "\n", "\t\t", 
            \(coefList = 
              E\^\(\(-I\)\ \[Omega]\ T\_0\)\ linearSys /. {
                    u\_1 -> \((P\ E\^\(I\ \[Omega]\ #\)&)\), 
                    v\_1 -> \((Q\ E\^\(I\ \[Omega]\ #\)&)\)} // Expand\), 
            ";", "\n", "\t\t", 
            \(coefMat = Outer[Coefficient, coefList, {P, Q}]\), ";", "\n", 
            "\t\t", \(hermitian[mat_?MatrixQ] := 
              mat /. conjugateRule // Transpose\), ";", "\n", "\t\t", 
            \(rightVec = {1, c1} /. 
                \(Solve[\((coefMat . {1, c1})\)[\([1]\)] == 0, c1]\)[\([1]\)]
                  \), ";", "\n", "\t\t", 
            \(leftVec = {c1, 1} /. 
                \(Solve[\((hermitian[coefMat] . {c1, 1})\)[\([1]\)] == 0, c1]
                    \)[\([1]\)]\), ";", "\n", "\t\t", 
            \(ccleftVec = leftVec /. conjugateRule\), ";", "\n", "\t\t", 
            \(sol1h = 
              \(# + \((# /. conjugateRule)\)\ &\)\ /@\ 
                \((rightVec\ A[T\_1, T\_2]\ E\^\(I\ \[Omega]\ T\_0\))\)\), 
            ";", "\n", "\t\t", 
            \(sol1p = 
              \(\(DSolve[
                        eqOrder[1] /. {u\_1 -> \((u\_1[#1]\ &)\), 
                            v\_1 -> \((v\_1[#1]\ &)\)}, {u\_1[T\_0], 
                          v\_1[T\_0]}, T\_0]\)[\([1]\)] /. C[_] -> 0 // 
                  TrigToExp\) // Simplify\), ";", "\n", "\t\t", 
            \(fRule = 
              f -> \(-2\) \((\(-\[Omega]\^2\) + \[CapitalOmega]\^2)\)\ 
                  \[CapitalLambda]\), ";", "\n", "\t\t", 
            \(sol1 = {
                u\_1 -> 
                  Function[{T\_0, T\_1, T\_2}, 
                    sol1h[\([1]\)] + 
                        \((\(u\_1[T\_0] /. sol1p\) /. fRule // Expand)\) // 
                      Evaluate], 
                v\_1 -> 
                  Function[{T\_0, T\_1, T\_2}, 
                    sol1h[\([2]\)] + 
                        \((\(v\_1[T\_0] /. sol1p\) /. fRule // Expand)\) // 
                      Evaluate]}\), ";", "\n", "\t\t", "\n", "\t  ", 
            StyleBox[\( (*\ Second - Order\ Problem\ *) \),
              FontColor->RGBColor[0, 0, 1]], "\t\t", "\n", "\t\t", 
            \(order2Eq = eqOrder[2] /. sol1 // ExpandAll\), ";", "\n", 
            "\t\t", \(expRule1 = 
              Exp[arg_] :> 
                Exp[Expand[arg /. OmgRule] /. 
                    \[Epsilon]\^n_. \ T\_0 :> timeScales[\([n + 1]\)]]\), 
            ";", "\n", "\t\t", 
            \(STerms1 = 
              \(Coefficient[#[\([2]\)] /. expRule1, Exp[I\ \[Omega]\ T\_0]]\ &
                  \)\ /@\ order2Eq\), ";", "\n", "\t\t", 
            RowBox[{"SCond1", "=", 
              RowBox[{
                RowBox[{"Solve", "[", 
                  RowBox[{\(ccleftVec . STerms1 == 0\), ",", 
                    RowBox[{
                      SuperscriptBox["A", 
                        TagBox[\((1, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(T\_1, T\_2\), 
                      "]"}]}], "]"}], "[", \([1]\), "]"}]}], ";", "\n", 
            "\t\t", \(ccSCond1 = SCond1 /. conjugateRule\), ";", "\n", 
            "\t\t", \(sigRule = 
              \(Solve[OmgRule /. Rule -> Equal, \[Sigma]]\)[\([1]\)]\), ";", 
            "\n", "\t\t", 
            \(expRule2 = 
              Exp[a_] :> 
                Exp[\(a /. {T\_1 -> \[Epsilon]\ T\_0, 
                          T\_2 -> \[Epsilon]\^2\ T\_0}\) /. sigRule // Expand]
                  \), ";", "\n", "\t\t", 
            \(SCond1f = Join[SCond1, ccSCond1] /. expRule2\), ";", "\n", 
            "\t\t", \(order2Eqm = order2Eq /. SCond1f // ExpandAll\), ";", 
            "\n", "\t  ", 
            \(collectForm = 
              Join[{E\^\(I\ T\_0\ \[Omega]\)\ A[T\_1, T\_2], 
                  E\^\(\(-I\)\ T\_0\ \[Omega]\)\ A\&_[T\_1, T\_2]}, 
                If[\((F/f /. scaling)\) === \[Epsilon], {
                    E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda], 
                    E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ 
                      \[CapitalLambda]}, {}]]\), ";", "\n", "\t\t", 
            \(possibleTerms = 
              collectForm~Join~
                \((\(Outer[Times, collectForm, collectForm] // Flatten\) // 
                    Union)\)\), ";", "\n", "\t\t", 
            \(RT = \(\((
                      \(# /. {a_ /; a =!= 0 -> 1}\ &\)\ /@\ 
                        \((\(E\^\(\(-I\)\ \[Omega]\ T\_0\)\ possibleTerms /. 
                              expRule1\) /. Exp[_\ T\_0 + _. ] -> 0)\))\)\ 
                    possibleTerms // Union\) // Rest\), ";", "\n", "\t\t", 
            \(NRT = Complement[possibleTerms, Join[RT, RT /. conjugateRule]]
                \), ";", "\n", "\t\t", 
            \(RTsymbolList = Table[\[CapitalGamma]\_j, {j, Length[RT]}]\), 
            ";", "\n", "\t\t", 
            \(NRTsymbolList[i_] = 
              Table[\[CapitalLambda]\_\(i, j\), {j, Length[NRT]}]\), ";", 
            "\n", "\t\t", 
            \(sol2Form = {\n\ \ \ \ \ \t\t
                u\_2 -> 
                  Function[{T\_0, T\_1, T\_2}, 
                    RTsymbolList . RT + 
                        \((RTsymbolList . RT /. conjugateRule)\) + 
                        NRTsymbolList[1] . NRT // Evaluate], 
                v\_2 -> 
                  Function[{T\_0, T\_1, T\_2}, 
                    \(-I\)\ \[Omega]\ RTsymbolList . RT + 
                        \((\(-I\)\ \[Omega]\ RTsymbolList . RT /. 
                            conjugateRule)\) + NRTsymbolList[2] . NRT // 
                      Evaluate]}\), ";", "\n", "\t\t", 
            \(algEqs1 = 
              \((\(Coefficient[Subtract\ @@\ #, NRT]\ &\)\ /@\ 
                          \((order2Eqm /. sol2Form)\) /. Exp[_\ T\_0] -> 0 // 
                      Flatten)\) == 0 // Thread\), ";", "\n", "\t\t", 
            \(coef1 = 
              \(Solve[algEqs1, Array[NRTsymbolList, 2] // Flatten]\)[\([1]\)]
                \), ";", "\n", "\t\t", 
            \(algEqs2 = 
              Coefficient[Subtract\ @@\ order2Eqm[\([1]\)] /. sol2Form, 
                      RT] == 0 /. Exp[_\ T\_0] -> 0 // Thread\), ";", "\n", 
            "\t\t", \(coef2a = \(Solve[algEqs2, RTsymbolList]\)[\([1]\)]\), 
            ";", "\n", "\t\t", 
            \(coef2 = Join[coef2a, coef2a /. conjugateRule]\), ";", "\n", 
            "\t\t", \(sol2 = 
              sol2Form /. 
                Function[{T\_0, T\_1, T\_2}, b_] :> 
                  Function[{T\_0, T\_1, T\_2} // Evaluate, 
                    \(\(b /. coef1\) /. coef2 // Expand\) // Evaluate]\), 
            ";", "\n", "\t\t", "\n", "\t  ", 
            StyleBox[\( (*\ Third - Order\ Problem\ *) \),
              FontColor->RGBColor[0, 0, 1]], "\n", "\t\t", 
            \(order3Eq = \(eqOrder[3] /. sol1\) /. sol2 // ExpandAll\), ";", 
            "\n", "\t\t", 
            \(STerms2 = 
              \(Coefficient[
                    \(#[\([2]\)] /. expRule1\) /. 
                      \((OmgRule /. \[Epsilon] -> 0)\), 
                    Exp[I\ \[Omega]\ T\_0]]\ &\)\ /@\ order3Eq\), ";", "\n", 
            "\t\t", 
            RowBox[{"SCond2", "=", 
              RowBox[{
                RowBox[{
                  RowBox[{"Solve", "[", 
                    RowBox[{\(ccleftVec . STerms2 == 0\), ",", 
                      RowBox[{
                        SuperscriptBox["A", 
                          TagBox[\((0, 1)\),
                            Derivative],
                          MultilineFunction->None], "[", \(T\_1, T\_2\), 
                        "]"}]}], "]"}], "[", \([1]\), "]"}], "//", 
                "ExpandAll"}]}], ";", "\n", "\t\t", "\n", "\t  ", 
            StyleBox[\( (*\ Reconstitution\ *) \),
              FontColor->RGBColor[0, 0, 1]], "\n", "\t\t", 
            \(moduEq = 
              2\ I\ \[Omega]\ A\^\[Prime] == 
                \((\(2\ I\ \[Omega]\ \(dt[1]\)[\ A[T\_1, T\_2]] /. SCond1
                        \) /. SCond2 // Collect[#, \[Epsilon]]\ &)\)\), ";", 
            "\n", "\t\t", 
            RowBox[{"Print", "[", "\"\<\!\(\*
StyleBox[\\(The\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(second\\),\nFontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\\(-\\),\nFontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\\(order\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(approximate\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(solution\\),\nFontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\\(:\\),\nFontColor->RGBColor[0, 0, 1]]\)\>\"", "]"}], ";", "\n", 
            "\t\t", \(Print[
              u[t] == \((
                  \(\(\(\(u\ @@\ timeScales /. solRule\) /. 
                          \[Epsilon]^3 -> 0\) /. sol1\) /. sol2\) /. 
                    displayRule)\)]\), ";", "\n", "\t\t", 
            RowBox[{"If", "[", 
              RowBox[{\(\((F/f /. scaling)\) === \[Epsilon]\), ",", 
                RowBox[{"Print", "[", "\"\<\!\(\*
StyleBox[\\(where\\),\nFontColor->RGBColor[0, 0, 1]]\)\\n \
\[CapitalLambda]==f/(2(\!\(\[Omega]\^2\)-\!\(\[CapitalOmega]\^2\)))\>\"", 
                  "]"}]}], "\n", "\t\t", "]"}], ";", " ", "\n", "\t\t", 
            RowBox[{"Print", "[", "\"\<\\n\!\(\*
StyleBox[\\(The\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(modulation\\),\nFontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\\(equations\\),\nFontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\\(:\\),\nFontColor->RGBColor[0, 0, 1]]\)\>\"", "]"}], ";", "\n", 
            "\t\t", \(Print[moduEq /. displayRule]\)}]}], "\n", "  ", 
        "]"}]}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"Primary Resonance:  \[CapitalOmega] \[TildeTilde] \[Omega]",
  Background->RGBColor[1, 1, 0]]], "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling1 = {F -> \[Epsilon]\^3\ f, \[Mu]\&^ -> \[Epsilon]\^2\ \[Mu]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond1 = {
        \[CapitalOmega] == \[Omega] + \[Epsilon]\^2\ \[Sigma]}; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MMS1[scaling1, ResonanceCond1] // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(second\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(-\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(order\
\\), FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(approximate\\), \
FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(solution\\), \
FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(:\\), \
FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(u[t] == 
      \[Epsilon]\ 
          \((A\ E\^\(I\ T\_0\ \[Omega]\) + 
              E\^\(\(-I\)\ T\_0\ \[Omega]\)\ A\&_)\) + 
        \[Epsilon]\^2\ 
          \((\(A\^2\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\)\/\(3\ 
                  \[Omega]\^2\) - \(2\ A\ \[Delta]\ A\&_\)\/\[Omega]\^2 + 
              \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
                  \[Omega]\^2\))\)\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\n\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(modulation\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(equations\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(:\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
        SuperscriptBox["A", "\[Prime]",
          MultilineFunction->None]}], "==", 
      \(2\ I\ \[Epsilon]\^2\ \[Omega]\ 
        \((\(-A\)\ \[Mu] - 
            \(I\ E\^\(I\ T\_2\ \[Sigma]\)\ f\)\/\(4\ \[Omega]\) - 
            \(5\ I\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^3\) + 
            \(3\ I\ A\^2\ \[Alpha]\ A\&_\)\/\(2\ \[Omega]\))\)\)}]], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({1.51300000000003365`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"Subharmonic Resonance of Order 1/2:  \[CapitalOmega] \[TildeTilde] \
2\[Omega]",
  Background->RGBColor[1, 1, 0]]], "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling2 = {F -> \[Epsilon]\ f, \[Mu]\&^ -> \[Epsilon]\ \[Mu]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond2 = {
        \[CapitalOmega] == 2  \[Omega] + \[Epsilon]\ \[Sigma]}; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MMS1[scaling2, ResonanceCond2] // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(second\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(-\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(order\
\\), FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(approximate\\), \
FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(solution\\), \
FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(:\\), \
FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(u[t] == 
      \[Epsilon]\ 
          \((A\ E\^\(I\ T\_0\ \[Omega]\) + 
              E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
              E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
              E\^\(\(-I\)\ T\_0\ \[Omega]\)\ A\&_)\) + 
        \[Epsilon]\^2\ 
          \((\(A\^2\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\)\/\(3\ 
                  \[Omega]\^2\) - 
              \(2\ \[Delta]\ \[CapitalLambda]\^2\)\/\[Omega]\^2 - 
              \(I\ A\ E\^\(I\ T\_0\ \[Omega]\)\ \[Mu]\)\/\(2\ \[Omega]\) - 
              \(A\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\)\/\(\[Omega]\ 
                  \[CapitalOmega]\) + 
              \(2\ A\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\)\/\(\[CapitalOmega]\ 
                  \((2\ \[Omega] + \[CapitalOmega])\)\) - 
              \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                  \[CapitalLambda]\^2\)\/\(\[Omega]\^2 - 
                  4\ \[CapitalOmega]\^2\) - 
              \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                  \[CapitalLambda]\^2\)\/\(\[Omega]\^2 - 
                  4\ \[CapitalOmega]\^2\) + 
              \(2\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
                  \[Mu]\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
                  \[CapitalOmega]\^2\) - 
              \(2\ I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
                  \[Mu]\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
                  \[CapitalOmega]\^2\) - 
              \(2\ A\ \[Delta]\ A\&_\)\/\[Omega]\^2 + 
              \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ A\&_\)\/\(2\ 
                  \[Omega]\) - 
              \(E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\ A\&_\)\/\(\[Omega]\ 
                  \[CapitalOmega]\) + 
              \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\ 
                  A\&_\)\/\(2\ \[Omega]\ \[CapitalOmega] + 
                  \[CapitalOmega]\^2\) + 
              \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
                  \[Omega]\^2\))\)\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(where\\), FontColor->RGBColor[0, 0, 1]]\\)\\n \
\[CapitalLambda]==f/(2(\\!\\(\[Omega]\\^2\\)-\\!\\(\[CapitalOmega]\\^2\\)))\"\
\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\n\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(modulation\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(equations\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(:\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
        SuperscriptBox["A", "\[Prime]",
          MultilineFunction->None]}], "==", 
      \(\(-2\)\ I\ \[Epsilon]\ 
          \((A\ \[Mu]\ \[Omega] - 
              I\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ A\&_)
            \) + 2\ I\ \[Epsilon]\^2\ \[Omega]\ 
          \((\(-\(\(9\ I\ A\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(4\ 
                      \[Omega]\^3\)\)\) + 
              \(3\ I\ A\ \[Alpha]\ \[CapitalLambda]\^2\)\/\[Omega] - 
              \(I\ A\ \[Mu]\^2\)\/\(2\ \[Omega]\) - 
              \(5\ I\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^3\) - 
              \(7\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\ 
                  \[Mu]\ A\&_\)\/\(3\ \[Omega]\^2\) + 
              \(3\ I\ A\^2\ \[Alpha]\ A\&_\)\/\(2\ \[Omega]\))\)\)}]], "Print",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({8.56200000000001182`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"Subharmonic Resonance of Order 1/3:  \[CapitalOmega] \[TildeTilde] \
3\[Omega]",
  Background->RGBColor[1, 1, 0]]], "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling3 = {F -> \[Epsilon]\ f, \[Mu]\&^ -> \[Epsilon]\^2\ \[Mu]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond3 = {
        \[CapitalOmega] == 3  \[Omega] + \[Epsilon]\^2\ \[Sigma]}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MMS1[scaling3, ResonanceCond3] // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(second\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(-\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(order\
\\), FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(approximate\\), \
FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(solution\\), \
FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(:\\), \
FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(u[t] == 
      \[Epsilon]\ 
          \((A\ E\^\(I\ T\_0\ \[Omega]\) + 
              E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
              E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
              E\^\(\(-I\)\ T\_0\ \[Omega]\)\ A\&_)\) + 
        \[Epsilon]\^2\ 
          \((\(A\^2\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\)\/\(3\ 
                  \[Omega]\^2\) - 
              \(2\ \[Delta]\ \[CapitalLambda]\^2\)\/\[Omega]\^2 - 
              \(2\ A\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ 
                  \[CapitalLambda]\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
                  \[CapitalOmega]\) + 
              \(2\ A\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\)\/\(\[CapitalOmega]\ 
                  \((2\ \[Omega] + \[CapitalOmega])\)\) - 
              \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                  \[CapitalLambda]\^2\)\/\(\[Omega]\^2 - 
                  4\ \[CapitalOmega]\^2\) - 
              \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                  \[CapitalLambda]\^2\)\/\(\[Omega]\^2 - 
                  4\ \[CapitalOmega]\^2\) - 
              \(2\ A\ \[Delta]\ A\&_\)\/\[Omega]\^2 - 
              \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\ 
                  A\&_\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
                  \[CapitalOmega]\) + 
              \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\ A\&_\)\/\(\[CapitalOmega]\ 
                  \((2\ \[Omega] + \[CapitalOmega])\)\) + 
              \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
                  \[Omega]\^2\))\)\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(where\\), FontColor->RGBColor[0, 0, 1]]\\)\\n \
\[CapitalLambda]==f/(2(\\!\\(\[Omega]\\^2\\)-\\!\\(\[CapitalOmega]\\^2\\)))\"\
\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\n\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(modulation\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(equations\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(:\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
        SuperscriptBox["A", "\[Prime]",
          MultilineFunction->None]}], "==", 
      \(2\ I\ \[Epsilon]\^2\ \[Omega]\ 
        \((\(-A\)\ \[Mu] - 
            \(6\ I\ A\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(5\ 
                \[Omega]\^3\) + 
            \(3\ I\ A\ \[Alpha]\ \[CapitalLambda]\^2\)\/\[Omega] - 
            \(5\ I\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^3\) + 
            \(3\ I\ A\^2\ \[Alpha]\ A\&_\)\/\(2\ \[Omega]\) + 
            \(I\ E\^\(I\ T\_2\ \[Sigma]\)\ \[Delta]\^2\ \[CapitalLambda]\ 
                A\&_\^2\)\/\[Omega]\^3 + 
            \(3\ I\ E\^\(I\ T\_2\ \[Sigma]\)\ \[Alpha]\ \[CapitalLambda]\ 
                A\&_\^2\)\/\(2\ \[Omega]\))\)\)}]], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({7.02999999999997271`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"Superharmonic Resonance of Order 2:  2\[CapitalOmega] \[TildeTilde] \
\[Omega]",
  Background->RGBColor[1, 1, 0]]], "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling4 = {F -> \[Epsilon]\ f, \[Mu]\&^ -> \[Epsilon]\ \[Mu]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond4 = {
        2  \[CapitalOmega] == \[Omega] + \[Epsilon]\ \[Sigma]}; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MMS1[scaling4, ResonanceCond4] // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(second\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(-\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(order\
\\), FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(approximate\\), \
FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(solution\\), \
FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(:\\), \
FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(u[t] == 
      \[Epsilon]\ 
          \((A\ E\^\(I\ T\_0\ \[Omega]\) + 
              E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
              E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
              E\^\(\(-I\)\ T\_0\ \[Omega]\)\ A\&_)\) + 
        \[Epsilon]\^2\ 
          \((\(A\^2\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\)\/\(3\ 
                  \[Omega]\^2\) - 
              \(2\ \[Delta]\ \[CapitalLambda]\^2\)\/\[Omega]\^2 - 
              \(I\ A\ E\^\(I\ T\_0\ \[Omega]\)\ \[Mu]\)\/\(2\ \[Omega]\) + 
              \(2\ A\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\)\/\(\[CapitalOmega]\ 
                  \((2\ \[Omega] + \[CapitalOmega])\)\) - 
              \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                  \[CapitalLambda]\^2\)\/\(2\ \[Omega]\ 
                  \((\[Omega] + 2\ \[CapitalOmega])\)\) - 
              \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                  \[CapitalLambda]\^2\)\/\(2\ \[Omega]\ 
                  \((\[Omega] + 2\ \[CapitalOmega])\)\) + 
              \(2\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
                  \[Mu]\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
                  \[CapitalOmega]\^2\) - 
              \(2\ I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
                  \[Mu]\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
                  \[CapitalOmega]\^2\) - 
              \(2\ A\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ 
                  \[CapitalLambda]\)\/\(2\ \[Omega]\ \[CapitalOmega] - 
                  \[CapitalOmega]\^2\) - 
              \(2\ A\ \[Delta]\ A\&_\)\/\[Omega]\^2 + 
              \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ A\&_\)\/\(2\ 
                  \[Omega]\) + 
              \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\ A\&_\)\/\(\[CapitalOmega]\ 
                  \((2\ \[Omega] + \[CapitalOmega])\)\) - 
              \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\ 
                  A\&_\)\/\(2\ \[Omega]\ \[CapitalOmega] - 
                  \[CapitalOmega]\^2\) + 
              \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
                  \[Omega]\^2\))\)\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(where\\), FontColor->RGBColor[0, 0, 1]]\\)\\n \
\[CapitalLambda]==f/(2(\\!\\(\[Omega]\\^2\\)-\\!\\(\[CapitalOmega]\\^2\\)))\"\
\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\n\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(modulation\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(equations\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(:\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
        SuperscriptBox["A", "\[Prime]",
          MultilineFunction->None]}], "==", 
      \(\(-I\)\ \[Epsilon]\ 
          \((\(-I\)\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ 
                \[CapitalLambda]\^2 + 2\ A\ \[Mu]\ \[Omega])\) + 
        2\ I\ \[Epsilon]\^2\ \[Omega]\ 
          \((\(-\(\(46\ I\ A\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(15\ 
                      \[Omega]\^3\)\)\) + 
              \(13\ E\^\(I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda]\^2\ 
                  \[Mu]\)\/\(12\ \[Omega]\^2\) + 
              \(3\ I\ A\ \[Alpha]\ \[CapitalLambda]\^2\)\/\[Omega] - 
              \(I\ A\ \[Mu]\^2\)\/\(2\ \[Omega]\) - 
              \(5\ I\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^3\) + 
              \(3\ I\ A\^2\ \[Alpha]\ A\&_\)\/\(2\ \[Omega]\))\)\)}]], "Print",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({8.99299999999993815`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"Superharmonic Resonance of Order 3:  3\[CapitalOmega] \[TildeTilde] \
\[Omega]",
  Background->RGBColor[1, 1, 0]]], "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling5 = {F -> \[Epsilon]\ f, \[Mu]\&^ -> \[Epsilon]\^2\ \[Mu]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond5 = {
        3  \[CapitalOmega] == \[Omega] + \[Epsilon]\^2\ \[Sigma]}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MMS1[scaling5, ResonanceCond5] // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(second\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(-\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(order\
\\), FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(approximate\\), \
FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(solution\\), \
FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(:\\), \
FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(u[t] == 
      \[Epsilon]\ 
          \((A\ E\^\(I\ T\_0\ \[Omega]\) + 
              E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
              E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
              E\^\(\(-I\)\ T\_0\ \[Omega]\)\ A\&_)\) + 
        \[Epsilon]\^2\ 
          \((\(A\^2\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\)\/\(3\ 
                  \[Omega]\^2\) - 
              \(2\ \[Delta]\ \[CapitalLambda]\^2\)\/\[Omega]\^2 - 
              \(2\ A\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ 
                  \[CapitalLambda]\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
                  \[CapitalOmega]\) + 
              \(2\ A\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\)\/\(\[CapitalOmega]\ 
                  \((2\ \[Omega] + \[CapitalOmega])\)\) - 
              \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                  \[CapitalLambda]\^2\)\/\(\[Omega]\^2 - 
                  4\ \[CapitalOmega]\^2\) - 
              \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                  \[CapitalLambda]\^2\)\/\(\[Omega]\^2 - 
                  4\ \[CapitalOmega]\^2\) - 
              \(2\ A\ \[Delta]\ A\&_\)\/\[Omega]\^2 - 
              \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\ 
                  A\&_\)\/\(\((2\ \[Omega] - \[CapitalOmega])\)\ 
                  \[CapitalOmega]\) + 
              \(2\ E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\ A\&_\)\/\(\[CapitalOmega]\ 
                  \((2\ \[Omega] + \[CapitalOmega])\)\) + 
              \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
                  \[Omega]\^2\))\)\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(where\\), FontColor->RGBColor[0, 0, 1]]\\)\\n \
\[CapitalLambda]==f/(2(\\!\\(\[Omega]\\^2\\)-\\!\\(\[CapitalOmega]\\^2\\)))\"\
\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\n\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(modulation\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(equations\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(:\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
        SuperscriptBox["A", "\[Prime]",
          MultilineFunction->None]}], "==", 
      \(2\ I\ \[Epsilon]\^2\ \[Omega]\ 
        \((\(-A\)\ \[Mu] - 
            \(106\ I\ A\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(35\ 
                \[Omega]\^3\) - 
            \(9\ I\ E\^\(I\ T\_2\ \[Sigma]\)\ \[Delta]\^2\ 
                \[CapitalLambda]\^3\)\/\(5\ \[Omega]\^3\) + 
            \(3\ I\ A\ \[Alpha]\ \[CapitalLambda]\^2\)\/\[Omega] + 
            \(I\ E\^\(I\ T\_2\ \[Sigma]\)\ \[Alpha]\ 
                \[CapitalLambda]\^3\)\/\(2\ \[Omega]\) - 
            \(5\ I\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^3\) + 
            \(3\ I\ A\^2\ \[Alpha]\ A\&_\)\/\(2\ \[Omega]\))\)\)}]], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({7.07999999999992724`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"Slowly-Modulated Load:  \[CapitalOmega] \[TildeTilde] 0",
  Background->RGBColor[1, 1, 0]]], "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(scaling6 = {F -> \[Epsilon]\ f, \[Mu]\&^ -> \[Epsilon]\ \[Mu]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(ResonanceCond6 = {\[CapitalOmega] == \[Epsilon]\ \[Sigma]}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MMS1[scaling6, ResonanceCond6] // Timing\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(second\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(-\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(order\
\\), FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(approximate\\), \
FontColor->RGBColor[0, 0, 1]]\\) \\!\\(\\* StyleBox[\\(solution\\), \
FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* StyleBox[\\(:\\), \
FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(u[t] == 
      \[Epsilon]\ 
          \((A\ E\^\(I\ T\_0\ \[Omega]\) + 
              E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
              E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda] + 
              E\^\(\(-I\)\ T\_0\ \[Omega]\)\ A\&_)\) + 
        \[Epsilon]\^2\ 
          \((\(A\^2\ E\^\(2\ I\ T\_0\ \[Omega]\)\ \[Delta]\)\/\(3\ 
                  \[Omega]\^2\) - 
              \(2\ \[Delta]\ \[CapitalLambda]\^2\)\/\[Omega]\^2 - 
              \(I\ A\ E\^\(I\ T\_0\ \[Omega]\)\ \[Mu]\)\/\(2\ \[Omega]\) - 
              \(A\ E\^\(I\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\)\/\(\[Omega]\ 
                  \((2\ \[Omega] - \[CapitalOmega])\)\) - 
              \(A\ E\^\(I\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\)\/\(\[Omega]\ 
                  \((2\ \[Omega] + \[CapitalOmega])\)\) - 
              \(E\^\(\(-2\)\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                  \[CapitalLambda]\^2\)\/\(\[Omega]\^2 - 
                  4\ \[CapitalOmega]\^2\) - 
              \(E\^\(2\ I\ T\_0\ \[CapitalOmega]\)\ \[Delta]\ 
                  \[CapitalLambda]\^2\)\/\(\[Omega]\^2 - 
                  4\ \[CapitalOmega]\^2\) + 
              \(2\ I\ E\^\(\(-I\)\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
                  \[Mu]\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
                  \[CapitalOmega]\^2\) - 
              \(2\ I\ E\^\(I\ T\_0\ \[CapitalOmega]\)\ \[CapitalLambda]\ 
                  \[Mu]\ \[CapitalOmega]\)\/\(\[Omega]\^2 - 
                  \[CapitalOmega]\^2\) - 
              \(2\ A\ \[Delta]\ A\&_\)\/\[Omega]\^2 + 
              \(I\ E\^\(\(-I\)\ T\_0\ \[Omega]\)\ \[Mu]\ A\&_\)\/\(2\ 
                  \[Omega]\) - 
              \(E\^\(\(-I\)\ T\_0\ \[Omega] + I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\ A\&_\)\/\(\[Omega]\ 
                  \((2\ \[Omega] - \[CapitalOmega])\)\) - 
              \(E\^\(\(-I\)\ T\_0\ \[Omega] - I\ T\_0\ \[CapitalOmega]\)\ 
                  \[Delta]\ \[CapitalLambda]\ A\&_\)\/\(\[Omega]\ 
                  \((2\ \[Omega] + \[CapitalOmega])\)\) + 
              \(E\^\(\(-2\)\ I\ T\_0\ \[Omega]\)\ \[Delta]\ A\&_\^2\)\/\(3\ 
                  \[Omega]\^2\))\)\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\!\\(\\* StyleBox[\\(where\\), FontColor->RGBColor[0, 0, 1]]\\)\\n \
\[CapitalLambda]==f/(2(\\!\\(\[Omega]\\^2\\)-\\!\\(\[CapitalOmega]\\^2\\)))\"\
\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
  "\<\"\\n\\!\\(\\* StyleBox[\\(The\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(modulation\\), FontColor->RGBColor[0, 0, 1]]\\) \
\\!\\(\\* StyleBox[\\(equations\\), FontColor->RGBColor[0, 0, 1]]\\)\\!\\(\\* \
StyleBox[\\(:\\), FontColor->RGBColor[0, 0, 1]]\\)\"\>"], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
        SuperscriptBox["A", "\[Prime]",
          MultilineFunction->None]}], "==", 
      \(\(-2\)\ I\ A\ E\^\(\(-I\)\ T\_1\ \[Sigma]\)\ \[Epsilon]\ 
          \((\(-I\)\ \[Delta]\ \[CapitalLambda] - 
              I\ E\^\(2\ I\ T\_1\ \[Sigma]\)\ \[Delta]\ \[CapitalLambda] + 
              E\^\(I\ T\_1\ \[Sigma]\)\ \[Mu]\ \[Omega])\) + 
        2\ I\ \[Epsilon]\^2\ \[Omega]\ 
          \((\(-\(\(3\ I\ A\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\[Omega]\^3
                      \)\) - \(3\ I\ A\ E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\)\ 
                  \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(2\ \[Omega]\^3\) - 
              \(3\ I\ A\ E\^\(2\ I\ T\_1\ \[Sigma]\)\ \[Delta]\^2\ 
                  \[CapitalLambda]\^2\)\/\(2\ \[Omega]\^3\) + 
              \(3\ I\ A\ \[Alpha]\ \[CapitalLambda]\^2\)\/\[Omega] + 
              \(3\ I\ A\ E\^\(\(-2\)\ I\ T\_1\ \[Sigma]\)\ \[Alpha]\ 
                  \[CapitalLambda]\^2\)\/\(2\ \[Omega]\) + 
              \(3\ I\ A\ E\^\(2\ I\ T\_1\ \[Sigma]\)\ \[Alpha]\ 
                  \[CapitalLambda]\^2\)\/\(2\ \[Omega]\) - 
              \(I\ A\ \[Mu]\^2\)\/\(2\ \[Omega]\) - 
              \(5\ I\ A\^2\ \[Delta]\^2\ A\&_\)\/\(3\ \[Omega]\^3\) + 
              \(3\ I\ A\^2\ \[Alpha]\ A\&_\)\/\(2\ \[Omega]\))\)\)}]], "Print",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({8.0019999999999527`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.3 The Generalized Method of Averaging", "Section",
  CellMargins->{{Inherited, 17.4375}, {Inherited, Inherited}},
  Evaluatable->False,
  TextAlignment->Left,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],

Cell[TextData[{
  "To apply either the method of averaging or the generalized method of \
averaging to ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we need first to use the method of variation of parameters to transform \
it into a system of two first-order equations governing the amplitude and \
phase. To this end, we introduce the following transformation:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(states = {a[t], \[Phi][t]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(transformRule = {
        u -> a[t] Cos[\[Phi][t]] + \[CapitalLambda]\ Cos[\[CapitalPsi][t]], 
        u\^\[Prime] -> 
          \(-\ \[Omega]\)\ a[t]\ Sin[\[Phi][t]] - 
            \[CapitalOmega]\ \[CapitalLambda]\ Sin[\[CapitalPsi][t]]}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"gRule", "=", 
        RowBox[{"g", "->", 
          RowBox[{
            RowBox[{\(-2\), " ", "\[Epsilon]", " ", "\[Mu]", " ", 
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None]}], "-", 
            \(\[Epsilon]\ \[Delta]\ u\^2\), "-", 
            \(\[Epsilon]\^2\ \[Alpha]\ u\^3\)}]}]}], ";"}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "After some algebraic manipulations (Nayfeh, 1973, 1981), we transform ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into two first-order equations as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq43a = 
      D[states, t] == 
          \((\(\(\({\(-\(g\/\[Omega]\)\)\ Sin[\[Phi][t]], 
                        \[Omega] - g\/\(a[t]\ \[Omega]\)\ Cos[\[Phi][t]]} /. 
                      gRule\) /. transformRule // Expand\) // TrigReduce\) // 
              Expand)\) // Thread; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We seek approximate solutions to ",
  StyleBox["eq43a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(basicTerms = {\[Eta][t], \[CurlyPhi][t], \[CapitalPsi][t]}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(solRule = {
        a -> \((Evaluate[
                \[Eta][t] + 
                    Sum[\[Epsilon]\^j\ a\_j\ @@\ basicTerms, {j, 2}] /. 
                  t -> #]\ &)\), 
        \[Phi] -> 
          \((Evaluate[
                \[CurlyPhi][t] + 
                    Sum[\[Epsilon]\^j\ \[Phi]\_j\ @@\ basicTerms, {j, 2}] /. 
                  t -> #]\ &)\)}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({a \[Rule] 
        \((\[Eta][#1] + 
              \[Epsilon]\ 
                a\_1[\[Eta][#1], \[CurlyPhi][#1], \[CapitalPsi][#1]] + 
              \[Epsilon]\^2\ 
                a\_2[\[Eta][#1], \[CurlyPhi][#1], \[CapitalPsi][#1]]&)\), 
      \[Phi] \[Rule] 
        \((\[CurlyPhi][#1] + 
              \[Epsilon]\ 
                \[Phi]\_1[\[Eta][#1], \[CurlyPhi][#1], \[CapitalPsi][#1]] + 
              \[Epsilon]\^2\ 
                \[Phi]\_2[\[Eta][#1], \[CurlyPhi][#1], \[CapitalPsi][#1]]&)\)}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Eta][t]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CurlyPhi][t]\)]],
  " are expanded in power series in \[Epsilon] as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(basicDRule = 
      D[basicTerms[\([{1, 2}]\)], t] -> {
            Sum[\[Epsilon]\^i\ A\_i\ @@\ basicTerms, {i, 2}], 
            \[Omega] + 
              Sum[\[Epsilon]\^i\ \[CapitalPhi]\_i\ @@\ basicTerms, {i, 
                  2}]} // Thread\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["\[Eta]", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          \(\[Epsilon]\ A\_1[\[Eta][t], \[CurlyPhi][t], \[CapitalPsi][t]] + 
            \[Epsilon]\^2\ 
              A\_2[\[Eta][t], \[CurlyPhi][t], \[CapitalPsi][t]]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["\[CurlyPhi]", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          \(\[Omega] + 
            \[Epsilon]\ 
              \[CapitalPhi]\_1[\[Eta][t], \[CurlyPhi][t], \[CapitalPsi][t]] + 
            \[Epsilon]\^2\ 
              \[CapitalPhi]\_2[\[Eta][t], \[CurlyPhi][t], \[CapitalPsi][t]]
                \)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The functions ",
  Cell[BoxData[
      \(TraditionalForm\`a\_1, a\_2, \)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Phi]\_1, \)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_2\)]],
  " are fast varying functions of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CurlyPhi]\)]],
  ", while it follows from ",
  StyleBox["basicDRule ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "that ",
  Cell[BoxData[
      \(TraditionalForm\`\[Eta]\)]],
  ", and hence the ",
  Cell[BoxData[
      \(TraditionalForm\`A\_n\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_n\)]],
  " are slowly varying functions of ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To the second approximation, we differentiate ",
  Cell[BoxData[
      \(TraditionalForm\`a[t]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi][t]\)]],
  " once with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", use ",
  StyleBox["solRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["basicDRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expand the result for small \[Epsilon], discard terms of order higher \
than ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\^2\)]],
  ", and obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq43bLHS = 
      \(CoefficientList[
            Expand[\(#[\([1]\)] /. solRule\) /. basicDRule] /. 
              \[Epsilon]\^\(n_ /; n > 2\) -> 0, \[Epsilon]]\ &\)\ /@\ eq43a; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Next, we substitute ",
  StyleBox["solRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the right-hand sides of ",
  StyleBox["eq43a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expand the result for small \[Epsilon], keep terms up to ",
  Cell[BoxData[
      \(TraditionalForm\`O(\[Epsilon]\^2)\)]],
  ", and rewrite their right-hand sides as"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq43bRHS = 
      \(CoefficientList[
            \(Series[#[\([2]\)] /. solRule, {\[Epsilon], 0, 2}] // Normal
                \) // Expand, \[Epsilon]]\ &\)\ /@\ eq43a; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Equating coefficients of like powers of \[Epsilon] in ",
  StyleBox["eq43bLHS",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["eq43bRHS",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eqEps = 
      \(MapThread[Equal, {eq43bLHS, eq43bRHS}, 2] // Transpose\) // Rest; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Next, we use the method of separation of variables to separate fast and \
slowly varying terms in the first-order equations, ",
  StyleBox["eqEps[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". We first introduce the rules"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[{
    \(SVT[j_] := {A\_j\ @@\ basicTerms, \[CapitalPhi]\_j\ @@\ basicTerms}\), 
    \(solVar[j_] := {a\_j, \[Phi]\_j}\)}], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(psiRule = {\[CurlyPhi][t] -> \[Omega]\ t + \[Beta][t], 
        \[CapitalPsi][t] -> \[CapitalOmega]\ t}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(betaRule = 
      \(Solve[psiRule /. Rule -> Equal, {\[Beta][t], \[CapitalOmega]}]\)[
        \([1]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Beta][t] \[Rule] \(-t\)\ \[Omega] + \[CurlyPhi][t], 
      \[CapitalOmega] \[Rule] \[CapitalPsi][t]\/t}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "For the case of subharmonic resonance of ",
  Cell[BoxData[
      \(TraditionalForm\`O(1\/2)\)]],
  ", we define"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(OmgRule = {\[CapitalOmega] -> 2  \[Omega] + \[Epsilon]\ \[Sigma]}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sigRule = \(Solve[OmgRule /. Rule -> Equal, \[Sigma]]\)[\([1]\)]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Sigma] \[Rule] 
        \(-\(\(2\ \[Omega] - \[CapitalOmega]\)\/\[Epsilon]\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(expRule1 = 
      f_[a_] :> 
        f[Expand[\(a /. psiRule\) /. OmgRule] /. \[Epsilon]\ t -> t\_1]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(expRule2 = 
      f_[a_] :> 
        f[Expand[\(\(a /. t\_1 -> \[Epsilon]\ t\) /. sigRule\) /. betaRule]]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using these rules, we find that the slowly varying parts of ",
  StyleBox["eqEps[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are given by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SVT1Rule = 
      Table[\(Solve[
              \(\(\(eqEps[\([1, i]\)] /. Thread[solVar[1] -> \((0\ &)\)]\) /. 
                    expRule1\) /. f_[_\ t + _. ] -> 0\) /. expRule2, 
              \(SVT[1]\)[\([i]\)]]\)\ [\([1]\)], {i, 2}] // Flatten\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({A\_1[\[Eta][t], \[CurlyPhi][t], \[CapitalPsi][t]] \[Rule] 
        \(-\(\(2\ \[Mu]\ \[Omega]\ \[Eta][t] - 
                \[Delta]\ \[CapitalLambda]\ 
                  Sin[2\ \[CurlyPhi][t] - \[CapitalPsi][t]]\ \[Eta][t]\)\/\(2
                \ \[Omega]\)\)\), 
      \[CapitalPhi]\_1[\[Eta][t], \[CurlyPhi][t], \[CapitalPsi][t]] \[Rule] 
        \(\[Delta]\ \[CapitalLambda]\ 
            Cos[2\ \[CurlyPhi][t] - \[CapitalPsi][t]]\)\/\(2\ \[Omega]\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["whereas the fast varying parts are given by", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(FVT1 = 
      Table[Subtract\ @@\ eqEps[\([1, i]\)] /. 
              Thread[solVar[1] -> \((0\ &)\)], {i, 2}] /. SVT1Rule // Expand
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\(\[CapitalLambda]\ \[Mu]\ \[CapitalOmega]\ 
            Cos[\[CurlyPhi][t] - \[CapitalPsi][t]]\)\/\[Omega] - 
        \(\[CapitalLambda]\ \[Mu]\ \[CapitalOmega]\ 
            Cos[\[CurlyPhi][t] + \[CapitalPsi][t]]\)\/\[Omega] - 
        \(\[Delta]\ \[CapitalLambda]\^2\ Sin[\[CurlyPhi][t]]\)\/\(2\ 
            \[Omega]\) - 
        \(\[Delta]\ \[CapitalLambda]\^2\ 
            Sin[\[CurlyPhi][t] - 2\ \[CapitalPsi][t]]\)\/\(4\ \[Omega]\) - 
        \(\[Delta]\ \[CapitalLambda]\^2\ 
            Sin[\[CurlyPhi][t] + 2\ \[CapitalPsi][t]]\)\/\(4\ \[Omega]\) - 
        \[Mu]\ Cos[2\ \[CurlyPhi][t]]\ \[Eta][t] - 
        \(\[Delta]\ \[CapitalLambda]\ 
            Sin[2\ \[CurlyPhi][t] + \[CapitalPsi][t]]\ \[Eta][t]\)\/\(2\ 
            \[Omega]\) - 
        \(\[Delta]\ Sin[\[CurlyPhi][t]]\ \[Eta][t]\^2\)\/\(4\ \[Omega]\) - 
        \(\[Delta]\ Sin[3\ \[CurlyPhi][t]]\ \[Eta][t]\^2\)\/\(4\ \[Omega]\), 
      \(-\(\(\[Delta]\ \[CapitalLambda]\ 
                Cos[\[CapitalPsi][t]]\)\/\[Omega]\)\) - 
        \(\[Delta]\ \[CapitalLambda]\ 
            Cos[2\ \[CurlyPhi][t] + \[CapitalPsi][t]]\)\/\(2\ \[Omega]\) + 
        \[Mu]\ Sin[2\ \[CurlyPhi][t]] - 
        \(\[Delta]\ \[CapitalLambda]\^2\ Cos[\[CurlyPhi][t]]\)\/\(2\ 
            \[Omega]\ \[Eta][t]\) - 
        \(\[Delta]\ \[CapitalLambda]\^2\ 
            Cos[\[CurlyPhi][t] - 2\ \[CapitalPsi][t]]\)\/\(4\ \[Omega]\ 
            \[Eta][t]\) - 
        \(\[Delta]\ \[CapitalLambda]\^2\ 
            Cos[\[CurlyPhi][t] + 2\ \[CapitalPsi][t]]\)\/\(4\ \[Omega]\ 
            \[Eta][t]\) - 
        \(\[CapitalLambda]\ \[Mu]\ \[CapitalOmega]\ 
            Sin[\[CurlyPhi][t] - \[CapitalPsi][t]]\)\/\(\[Omega]\ 
            \[Eta][t]\) + 
        \(\[CapitalLambda]\ \[Mu]\ \[CapitalOmega]\ 
            Sin[\[CurlyPhi][t] + \[CapitalPsi][t]]\)\/\(\[Omega]\ 
            \[Eta][t]\) - 
        \(3\ \[Delta]\ Cos[\[CurlyPhi][t]]\ \[Eta][t]\)\/\(4\ \[Omega]\) - 
        \(\[Delta]\ Cos[3\ \[CurlyPhi][t]]\ \[Eta][t]\)\/\(4\ \[Omega]\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "To determine a particular solution corresponding to these fast varying \
terms, we use the method of undetermined coefficients. To accomplish this, we \
first determine the possible forms of the terms in ",
  StyleBox["FVT1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " as follows:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(FVT1Forms = 
      \(\((\(Cases[#, \((Cos | Sin)\)[a_] -> {Cos[a], Sin[a]}, Infinity] // 
                Flatten\) // Union)\)\ &\)\ /@\ FVT1\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{Cos[\[CurlyPhi][t]], Cos[2\ \[CurlyPhi][t]], Cos[3\ \[CurlyPhi][t]], 
        Cos[\[CurlyPhi][t] - 2\ \[CapitalPsi][t]], 
        Cos[\[CurlyPhi][t] - \[CapitalPsi][t]], 
        Cos[\[CurlyPhi][t] + \[CapitalPsi][t]], 
        Cos[2\ \[CurlyPhi][t] + \[CapitalPsi][t]], 
        Cos[\[CurlyPhi][t] + 2\ \[CapitalPsi][t]], Sin[\[CurlyPhi][t]], 
        Sin[2\ \[CurlyPhi][t]], Sin[3\ \[CurlyPhi][t]], 
        Sin[\[CurlyPhi][t] - 2\ \[CapitalPsi][t]], 
        Sin[\[CurlyPhi][t] - \[CapitalPsi][t]], 
        Sin[\[CurlyPhi][t] + \[CapitalPsi][t]], 
        Sin[2\ \[CurlyPhi][t] + \[CapitalPsi][t]], 
        Sin[\[CurlyPhi][t] + 2\ \[CapitalPsi][t]]}, {Cos[\[CurlyPhi][t]], 
        Cos[2\ \[CurlyPhi][t]], Cos[3\ \[CurlyPhi][t]], 
        Cos[\[CurlyPhi][t] - 2\ \[CapitalPsi][t]], 
        Cos[\[CurlyPhi][t] - \[CapitalPsi][t]], Cos[\[CapitalPsi][t]], 
        Cos[\[CurlyPhi][t] + \[CapitalPsi][t]], 
        Cos[2\ \[CurlyPhi][t] + \[CapitalPsi][t]], 
        Cos[\[CurlyPhi][t] + 2\ \[CapitalPsi][t]], Sin[\[CurlyPhi][t]], 
        Sin[2\ \[CurlyPhi][t]], Sin[3\ \[CurlyPhi][t]], 
        Sin[\[CurlyPhi][t] - 2\ \[CapitalPsi][t]], 
        Sin[\[CurlyPhi][t] - \[CapitalPsi][t]], Sin[\[CapitalPsi][t]], 
        Sin[\[CurlyPhi][t] + \[CapitalPsi][t]], 
        Sin[2\ \[CurlyPhi][t] + \[CapitalPsi][t]], 
        Sin[\[CurlyPhi][t] + 2\ \[CapitalPsi][t]]}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Using the principle of superposition, we seek a particular solution \
corresponding to the fast-varying terms as a linear combination of these \
possible forms:\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1Form = 
      MapIndexed[\((coeffs1[#2[\([1]\)]] = Array[c, Length[#1]])\) . #1\ &, 
        FVT1Forms]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({c[1]\ Cos[\[CurlyPhi][t]] + c[2]\ Cos[2\ \[CurlyPhi][t]] + 
        c[3]\ Cos[3\ \[CurlyPhi][t]] + 
        c[4]\ Cos[\[CurlyPhi][t] - 2\ \[CapitalPsi][t]] + 
        c[5]\ Cos[\[CurlyPhi][t] - \[CapitalPsi][t]] + 
        c[6]\ Cos[\[CurlyPhi][t] + \[CapitalPsi][t]] + 
        c[7]\ Cos[2\ \[CurlyPhi][t] + \[CapitalPsi][t]] + 
        c[8]\ Cos[\[CurlyPhi][t] + 2\ \[CapitalPsi][t]] + 
        c[9]\ Sin[\[CurlyPhi][t]] + c[10]\ Sin[2\ \[CurlyPhi][t]] + 
        c[11]\ Sin[3\ \[CurlyPhi][t]] + 
        c[12]\ Sin[\[CurlyPhi][t] - 2\ \[CapitalPsi][t]] + 
        c[13]\ Sin[\[CurlyPhi][t] - \[CapitalPsi][t]] + 
        c[14]\ Sin[\[CurlyPhi][t] + \[CapitalPsi][t]] + 
        c[15]\ Sin[2\ \[CurlyPhi][t] + \[CapitalPsi][t]] + 
        c[16]\ Sin[\[CurlyPhi][t] + 2\ \[CapitalPsi][t]], 
      c[1]\ Cos[\[CurlyPhi][t]] + c[2]\ Cos[2\ \[CurlyPhi][t]] + 
        c[3]\ Cos[3\ \[CurlyPhi][t]] + 
        c[4]\ Cos[\[CurlyPhi][t] - 2\ \[CapitalPsi][t]] + 
        c[5]\ Cos[\[CurlyPhi][t] - \[CapitalPsi][t]] + 
        c[6]\ Cos[\[CapitalPsi][t]] + 
        c[7]\ Cos[\[CurlyPhi][t] + \[CapitalPsi][t]] + 
        c[8]\ Cos[2\ \[CurlyPhi][t] + \[CapitalPsi][t]] + 
        c[9]\ Cos[\[CurlyPhi][t] + 2\ \[CapitalPsi][t]] + 
        c[10]\ Sin[\[CurlyPhi][t]] + c[11]\ Sin[2\ \[CurlyPhi][t]] + 
        c[12]\ Sin[3\ \[CurlyPhi][t]] + 
        c[13]\ Sin[\[CurlyPhi][t] - 2\ \[CapitalPsi][t]] + 
        c[14]\ Sin[\[CurlyPhi][t] - \[CapitalPsi][t]] + 
        c[15]\ Sin[\[CapitalPsi][t]] + 
        c[16]\ Sin[\[CurlyPhi][t] + \[CapitalPsi][t]] + 
        c[17]\ Sin[2\ \[CurlyPhi][t] + \[CapitalPsi][t]] + 
        c[18]\ Sin[\[CurlyPhi][t] + 2\ \[CapitalPsi][t]]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting ",
  StyleBox["sol1Form",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eqEps[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", using ",
  StyleBox["SVT1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", collecting the coefficients of ",
  StyleBox["FVT1Forms",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", solving the resulting algebraic equations for the undetermined \
coefficients, and then substituting the result back into ",
  StyleBox["sol1Form",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain the solution"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1rhs = 
      Table[\(sol1Form[\([i]\)] /. 
              \(Solve[Coefficient[
                        \(Subtract\ @@\ eqEps[\([1, i]\)] /. SVT1Rule\) /. 
                          \(solVar[1]\)[\([i]\)] -> 
                            \((Evaluate[
                                  sol1Form[\([i]\)] /. 
                                    Thread[basicTerms -> {#1, #2, #3}]]\ &)
                              \), FVT1Forms[\([i]\)]] == 0 // Thread, 
                  coeffs1[i]]\)[\([1]\)]\) /. D[psiRule, t] // Expand, {i, 2}]
        \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\(-
          \(\(\[Delta]\ \[CapitalLambda]\^2\ Cos[\[CurlyPhi][t]]\)\/\(2\ 
                \[Omega]\^2\)\)\) - 
        \(\[Delta]\ \[CapitalLambda]\^2\ 
            Cos[\[CurlyPhi][t] - 2\ \[CapitalPsi][t]]\)\/\(4\ \[Omega]\ 
            \((\[Omega] - 2\ \[CapitalOmega])\)\) - 
        \(\[Delta]\ \[CapitalLambda]\^2\ 
            Cos[\[CurlyPhi][t] + 2\ \[CapitalPsi][t]]\)\/\(4\ \[Omega]\ 
            \((\[Omega] + 2\ \[CapitalOmega])\)\) - 
        \(\[CapitalLambda]\ \[Mu]\ \[CapitalOmega]\ 
            Sin[\[CurlyPhi][t] - \[CapitalPsi][t]]\)\/\(\[Omega]\ 
            \((\[Omega] - \[CapitalOmega])\)\) + 
        \(\[CapitalLambda]\ \[Mu]\ \[CapitalOmega]\ 
            Sin[\[CurlyPhi][t] + \[CapitalPsi][t]]\)\/\(\[Omega]\ 
            \((\[Omega] + \[CapitalOmega])\)\) - 
        \(\[Delta]\ \[CapitalLambda]\ 
            Cos[2\ \[CurlyPhi][t] + \[CapitalPsi][t]]\ \[Eta][t]\)\/\(2\ 
            \[Omega]\ \((2\ \[Omega] + \[CapitalOmega])\)\) + 
        \(\[Mu]\ Sin[2\ \[CurlyPhi][t]]\ \[Eta][t]\)\/\(2\ \[Omega]\) - 
        \(\[Delta]\ Cos[\[CurlyPhi][t]]\ \[Eta][t]\^2\)\/\(4\ \[Omega]\^2\) - 
        \(\[Delta]\ Cos[3\ \[CurlyPhi][t]]\ \[Eta][t]\^2\)\/\(12\ 
            \[Omega]\^2\), 
      \(\[Mu]\ Cos[2\ \[CurlyPhi][t]]\)\/\(2\ \[Omega]\) + 
        \(\[Delta]\ \[CapitalLambda]\ Sin[\[CapitalPsi][t]]\)\/\(\[Omega]\ 
            \[CapitalOmega]\) + 
        \(\[Delta]\ \[CapitalLambda]\ 
            Sin[2\ \[CurlyPhi][t] + \[CapitalPsi][t]]\)\/\(2\ \[Omega]\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\) - 
        \(\[CapitalLambda]\ \[Mu]\ \[CapitalOmega]\ 
            Cos[\[CurlyPhi][t] - \[CapitalPsi][t]]\)\/\(\[Omega]\ 
            \((\[Omega] - \[CapitalOmega])\)\ \[Eta][t]\) + 
        \(\[CapitalLambda]\ \[Mu]\ \[CapitalOmega]\ 
            Cos[\[CurlyPhi][t] + \[CapitalPsi][t]]\)\/\(\[Omega]\ 
            \((\[Omega] + \[CapitalOmega])\)\ \[Eta][t]\) + 
        \(\[Delta]\ \[CapitalLambda]\^2\ Sin[\[CurlyPhi][t]]\)\/\(2\ 
            \[Omega]\^2\ \[Eta][t]\) + 
        \(\[Delta]\ \[CapitalLambda]\^2\ 
            Sin[\[CurlyPhi][t] - 2\ \[CapitalPsi][t]]\)\/\(4\ \[Omega]\ 
            \((\[Omega] - 2\ \[CapitalOmega])\)\ \[Eta][t]\) + 
        \(\[Delta]\ \[CapitalLambda]\^2\ 
            Sin[\[CurlyPhi][t] + 2\ \[CapitalPsi][t]]\)\/\(4\ \[Omega]\ 
            \((\[Omega] + 2\ \[CapitalOmega])\)\ \[Eta][t]\) + 
        \(3\ \[Delta]\ Sin[\[CurlyPhi][t]]\ \[Eta][t]\)\/\(4\ \[Omega]\^2\) + 
        \(\[Delta]\ Sin[3\ \[CurlyPhi][t]]\ \[Eta][t]\)\/\(12\ \[Omega]\^2\)}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["which can be expressed in pure function form as", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1Rule = 
      Table[\(solVar[1]\)[\([i]\)] -> 
          \((Evaluate[sol1rhs[\([i]\)] /. Thread[basicTerms -> {#1, #2, #3}]]
                \ &)\), {i, 2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({a\_1 \[Rule] 
        \((\(-\(\(\[Delta]\ \[CapitalLambda]\^2\ Cos[#2]\)\/\(2\ 
                      \[Omega]\^2\)\)\) - 
              \(\[Delta]\ \[CapitalLambda]\^2\ Cos[#2 - 2\ #3]\)\/\(4\ 
                  \[Omega]\ \((\[Omega] - 2\ \[CapitalOmega])\)\) - 
              \(\[Delta]\ \[CapitalLambda]\^2\ Cos[#2 + 2\ #3]\)\/\(4\ 
                  \[Omega]\ \((\[Omega] + 2\ \[CapitalOmega])\)\) - 
              \(\[CapitalLambda]\ \[Mu]\ \[CapitalOmega]\ 
                  Sin[#2 - #3]\)\/\(\[Omega]\ 
                  \((\[Omega] - \[CapitalOmega])\)\) + 
              \(\[CapitalLambda]\ \[Mu]\ \[CapitalOmega]\ 
                  Sin[#2 + #3]\)\/\(\[Omega]\ 
                  \((\[Omega] + \[CapitalOmega])\)\) - 
              \(\[Delta]\ \[CapitalLambda]\ Cos[2\ #2 + #3]\ #1\)\/\(2\ 
                  \[Omega]\ \((2\ \[Omega] + \[CapitalOmega])\)\) + 
              \(\[Mu]\ Sin[2\ #2]\ #1\)\/\(2\ \[Omega]\) - 
              \(\[Delta]\ Cos[#2]\ #1\^2\)\/\(4\ \[Omega]\^2\) - 
              \(\[Delta]\ Cos[3\ #2]\ #1\^2\)\/\(12\ \[Omega]\^2\)&)\), 
      \[Phi]\_1 \[Rule] 
        \((\(\[Mu]\ Cos[2\ #2]\)\/\(2\ \[Omega]\) + 
              \(\[Delta]\ \[CapitalLambda]\ Sin[#3]\)\/\(\[Omega]\ 
                  \[CapitalOmega]\) + 
              \(\[Delta]\ \[CapitalLambda]\ Sin[2\ #2 + #3]\)\/\(2\ \[Omega]\ 
                  \((2\ \[Omega] + \[CapitalOmega])\)\) - 
              \(\[CapitalLambda]\ \[Mu]\ \[CapitalOmega]\ 
                  Cos[#2 - #3]\)\/\(\[Omega]\ 
                  \((\[Omega] - \[CapitalOmega])\)\ #1\) + 
              \(\[CapitalLambda]\ \[Mu]\ \[CapitalOmega]\ 
                  Cos[#2 + #3]\)\/\(\[Omega]\ 
                  \((\[Omega] + \[CapitalOmega])\)\ #1\) + 
              \(\[Delta]\ \[CapitalLambda]\^2\ Sin[#2]\)\/\(2\ \[Omega]\^2\ #1
                  \) + \(\[Delta]\ \[CapitalLambda]\^2\ Sin[#2 - 2\ #3]\)\/\(4
                  \ \[Omega]\ \((\[Omega] - 2\ \[CapitalOmega])\)\ #1\) + 
              \(\[Delta]\ \[CapitalLambda]\^2\ Sin[#2 + 2\ #3]\)\/\(4\ 
                  \[Omega]\ \((\[Omega] + 2\ \[CapitalOmega])\)\ #1\) + 
              \(3\ \[Delta]\ Sin[#2]\ #1\)\/\(4\ \[Omega]\^2\) + 
              \(\[Delta]\ Sin[3\ #2]\ #1\)\/\(12\ \[Omega]\^2\)&)\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting the slow- and fast-varying components of the first-order \
solution, ",
  StyleBox["SVT1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["sol1Rule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", into the second-order equations, we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((order2Expr = 
          Table[TrigReduce\ /@\ 
              \((\(Subtract\ @@\ eqEps[\([2, i]\)] /. SVT1Rule\) /. 
                    sol1Rule // Expand)\), {i, 2}]; )\) // Timing\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({12.3600000000001286`\ Second, Null}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Since we are seeking an expansion valid up to ",
  Cell[BoxData[
      \(TraditionalForm\`O(\[Epsilon]\^2)\)]],
  ", we do not need to solve for ",
  Cell[BoxData[
      \(TraditionalForm\`a\_2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_2\)]],
  ". All we need to do is to investigate the above expressions to determine \
the slowly varying parts and determine ",
  Cell[BoxData[
      \(TraditionalForm\`A\_2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_2\)]],
  ". The result is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(SVT2Rule = 
      \(Table[Solve[
              \(\(\(\(order2Expr[\([i]\)] == 0 /. 
                        Thread[solVar[2] -> \((0\ &)\)]\) /. expRule1\) /. 
                    f_[_\ t + _. ] -> 0\) /. expRule2\) /. 
                \((OmgRule /. \[Epsilon] -> 0)\), \(SVT[2]\)[\([i]\)]], {i, 
              2}] // Flatten\) // ExpandAll\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({A\_2[\[Eta][t], \[CurlyPhi][t], \[CapitalPsi][t]] \[Rule] 
        \(-\(\(7\ \[Delta]\ \[CapitalLambda]\ \[Mu]\ 
                Cos[2\ \[CurlyPhi][t] - \[CapitalPsi][t]]\ \[Eta][t]\)\/\(6\ 
                \[Omega]\^2\)\)\), 
      \[CapitalPhi]\_2[\[Eta][t], \[CurlyPhi][t], \[CapitalPsi][t]] \[Rule] 
        \(-\(\(9\ \[Delta]\^2\ \[CapitalLambda]\^2\)\/\(16\ 
                  \[Omega]\^3\)\)\) + 
          \(3\ \[Alpha]\ \[CapitalLambda]\^2\)\/\(4\ \[Omega]\) - 
          \[Mu]\^2\/\(2\ \[Omega]\) + 
          \(7\ \[Delta]\ \[CapitalLambda]\ \[Mu]\ 
              Sin[2\ \[CurlyPhi][t] - \[CapitalPsi][t]]\)\/\(6\ 
              \[Omega]\^2\) - 
          \(5\ \[Delta]\^2\ \[Eta][t]\^2\)\/\(12\ \[Omega]\^3\) + 
          \(3\ \[Alpha]\ \[Eta][t]\^2\)\/\(8\ \[Omega]\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["Hence, to the second approximation, we find  that", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(u[t] == 
      \((TrigReduce\ /@\ 
            \((Normal[
                    Series[\(u /. transformRule\) /. solRule, {\[Epsilon], 0, 
                        1}]] /. sol1Rule // Expand)\) // 
          Collect[#, \[Epsilon]]&)\)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(u[t] == 
      \[CapitalLambda]\ Cos[\[CapitalPsi][t]] + 
        Cos[\[CurlyPhi][t]]\ \[Eta][t] + 
        \[Epsilon]\ 
          \((\(-\(\(\[Delta]\ \[CapitalLambda]\^2\)\/\(2\ \[Omega]\^2\)\)\) - 
              \(\[Delta]\ \[CapitalLambda]\^2\ Cos[2\ \[CapitalPsi][t]]\)\/\(4
                  \ \[Omega]\ \((\[Omega] - 2\ \[CapitalOmega])\)\) - 
              \(\[Delta]\ \[CapitalLambda]\^2\ Cos[2\ \[CapitalPsi][t]]\)\/\(4
                  \ \[Omega]\ \((\[Omega] + 2\ \[CapitalOmega])\)\) + 
              \(\[CapitalLambda]\ \[Mu]\ \[CapitalOmega]\ 
                  Sin[\[CapitalPsi][t]]\)\/\(\[Omega]\ 
                  \((\[Omega] - \[CapitalOmega])\)\) + 
              \(\[CapitalLambda]\ \[Mu]\ \[CapitalOmega]\ 
                  Sin[\[CapitalPsi][t]]\)\/\(\[Omega]\ 
                  \((\[Omega] + \[CapitalOmega])\)\) - 
              \(\[Delta]\ \[CapitalLambda]\ 
                  Cos[\[CurlyPhi][t] - \[CapitalPsi][t]]\ \[Eta][t]\)\/\(2\ 
                  \[Omega]\ \[CapitalOmega]\) + 
              \(\[Delta]\ \[CapitalLambda]\ 
                  Cos[\[CurlyPhi][t] + \[CapitalPsi][t]]\ \[Eta][t]\)\/\(2\ 
                  \[Omega]\ \[CapitalOmega]\) - 
              \(\[Delta]\ \[CapitalLambda]\ 
                  Cos[\[CurlyPhi][t] + \[CapitalPsi][t]]\ \[Eta][t]\)\/\(2\ 
                  \[Omega]\ \((2\ \[Omega] + \[CapitalOmega])\)\) + 
              \(\[Mu]\ Sin[\[CurlyPhi][t]]\ \[Eta][t]\)\/\(2\ \[Omega]\) - 
              \(\[Delta]\ \[Eta][t]\^2\)\/\(2\ \[Omega]\^2\) + 
              \(\[Delta]\ Cos[2\ \[CurlyPhi][t]]\ \[Eta][t]\^2\)\/\(6\ 
                  \[Omega]\^2\))\)\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["where the equations governing the amplitude and phase are", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({ampEqs, phaseEqs} = 
      \(\((\(basicDRule /. SVT1Rule\) /. SVT2Rule // ExpandAll)\) /. 
          f_[a_] :> f[Collect[a /. psiRule, t]]\) /. Rule -> Equal\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["\[Eta]", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          \(\(-\[Epsilon]\)\ \[Mu]\ \[Eta][t] - 
            \(7\ \[Delta]\ \[Epsilon]\^2\ \[CapitalLambda]\ \[Mu]\ 
                Cos[t\ \((2\ \[Omega] - \[CapitalOmega])\) + 2\ \[Beta][t]]\ 
                \[Eta][t]\)\/\(6\ \[Omega]\^2\) + 
            \(\[Delta]\ \[Epsilon]\ \[CapitalLambda]\ 
                Sin[t\ \((2\ \[Omega] - \[CapitalOmega])\) + 2\ \[Beta][t]]\ 
                \[Eta][t]\)\/\(2\ \[Omega]\)\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["\[CurlyPhi]", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          \(\(-\(\(9\ \[Delta]\^2\ \[Epsilon]\^2\ \[CapitalLambda]\^2\)\/\(16
                    \ \[Omega]\^3\)\)\) + 
            \(3\ \[Alpha]\ \[Epsilon]\^2\ \[CapitalLambda]\^2\)\/\(4\ 
                \[Omega]\) - \(\[Epsilon]\^2\ \[Mu]\^2\)\/\(2\ \[Omega]\) + 
            \[Omega] + 
            \(\[Delta]\ \[Epsilon]\ \[CapitalLambda]\ 
                Cos[t\ \((2\ \[Omega] - \[CapitalOmega])\) + 2\ \[Beta][t]]
                  \)\/\(2\ \[Omega]\) + 
            \(7\ \[Delta]\ \[Epsilon]\^2\ \[CapitalLambda]\ \[Mu]\ 
                Sin[t\ \((2\ \[Omega] - \[CapitalOmega])\) + 2\ \[Beta][t]]
                  \)\/\(6\ \[Omega]\^2\) - 
            \(5\ \[Delta]\^2\ \[Epsilon]\^2\ \[Eta][t]\^2\)\/\(12\ 
                \[Omega]\^3\) + 
            \(3\ \[Alpha]\ \[Epsilon]\^2\ \[Eta][t]\^2\)\/\(8\ 
                \[Omega]\)\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.4 The Method of Normal Forms", "Section",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In this section, we use the method of normal forms to determine a \
second-order uniform expansion of the solution of ",
  StyleBox["FDuffingEq",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". To this end, we start with the corresponding first-order complex-valued \
equation, which was derived in Section 4.2.6 and a summary of the derivation \
is given below:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(transformRule = {u[t] -> \((\[Zeta][t] + \[Zeta]\&_[t])\), 
        \(u\^\[Prime]\)[t] -> I\ \[Omega]\ \((\[Zeta][t] - \[Zeta]\&_[t])\), 
        f\ Cos[\[CapitalOmega]\ t] -> \(1\/2\) \((z[t] + z\&_[t])\)}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(gRule = 
      g -> \(-2\)\ \[Epsilon]\ \[Mu]\ \(u\^\[Prime]\)[t] - 
          \[Epsilon]\ \[Delta]\ u[t]\^2 - 
          \(\[Epsilon]\^2\) \[Alpha]\ u[t]\^3 + f\ Cos[\[CapitalOmega]\ t]; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq44a = {
        \(\(\[Zeta]\^\[Prime]\)[t] == 
                I\ \[Omega]\ \[Zeta][t] - I\ g/\((2\ \[Omega])\) /. gRule
              \) /. transformRule // ExpandAll, 
        \(z\^\[Prime]\)[t] == I\ \[CapitalOmega]\ z[t]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["\[Zeta]", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          \(\(-\(\(I\ z[t]\)\/\(4\ \[Omega]\)\)\) - 
            \[Epsilon]\ \[Mu]\ \[Zeta][t] + I\ \[Omega]\ \[Zeta][t] + 
            \(I\ \[Delta]\ \[Epsilon]\ \[Zeta][t]\^2\)\/\(2\ \[Omega]\) + 
            \(I\ \[Alpha]\ \[Epsilon]\^2\ \[Zeta][t]\^3\)\/\(2\ \[Omega]\) - 
            \(I\ z\&_[t]\)\/\(4\ \[Omega]\) + 
            \[Epsilon]\ \[Mu]\ \[Zeta]\&_[t] + 
            \(I\ \[Delta]\ \[Epsilon]\ \[Zeta][t]\ 
                \[Zeta]\&_[t]\)\/\[Omega] + 
            \(3\ I\ \[Alpha]\ \[Epsilon]\^2\ \[Zeta][t]\^2\ 
                \[Zeta]\&_[t]\)\/\(2\ \[Omega]\) + 
            \(I\ \[Delta]\ \[Epsilon]\ \[Zeta]\&_[t]\^2\)\/\(2\ \[Omega]\) + 
            \(3\ I\ \[Alpha]\ \[Epsilon]\^2\ \[Zeta][t]\ 
                \[Zeta]\&_[t]\^2\)\/\(2\ \[Omega]\) + 
            \(I\ \[Alpha]\ \[Epsilon]\^2\ \[Zeta]\&_[t]\^3\)\/\(2\ 
                \[Omega]\)\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["z", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          \(I\ \[CapitalOmega]\ z[t]\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
According to the method of normal forms, we introduce the near-identity \
transformation\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(basicTerms = {\[Eta][t], \[Eta]\&_[t], z[t], z\&_[t]}; \)\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(zetaRule = {
        \[Zeta] -> 
          Function[t, 
            \[Eta][t] + 
                Sum[\[Epsilon]\^j\ h\_j[Sequence\ @@\ basicTerms], {j, 0, 
                    2}] // Evaluate], 
        \[Zeta]\&_ -> 
          Function[t, 
            \[Eta]\&_[t] + 
                Sum[\[Epsilon]\^j\ h\&_\_j[Sequence\ @@\ basicTerms], {j, 0, 
                    2}] // Evaluate]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Zeta] \[Rule] 
        Function[t, 
          \[Eta][t] + h\_0[\[Eta][t], \[Eta]\&_[t], z[t], z\&_[t]] + 
            \[Epsilon]\ h\_1[\[Eta][t], \[Eta]\&_[t], z[t], z\&_[t]] + 
            \[Epsilon]\^2\ h\_2[\[Eta][t], \[Eta]\&_[t], z[t], z\&_[t]]], 
      \[Zeta]\&_ \[Rule] 
        Function[t, 
          \[Eta]\&_[t] + h\&_\_0[\[Eta][t], \[Eta]\&_[t], z[t], z\&_[t]] + 
            \[Epsilon]\ h\&_\_1[\[Eta][t], \[Eta]\&_[t], z[t], z\&_[t]] + 
            \[Epsilon]\^2\ h\&_\_2[\[Eta][t], \[Eta]\&_[t], z[t], z\&_[t]]]}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["that results in the simplest possible equation", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(etaRule = {
        \(\[Eta]\^\[Prime]\)[t] -> 
          I\ \[Omega]\ \[Eta][t] + Sum[\[Epsilon]\^j\ g\_j[t], {j, 2}], 
        \(z\^\[Prime]\)[t] -> I\ \[CapitalOmega]\ z[t]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["\[Eta]", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          \(I\ \[Omega]\ \[Eta][t] + \[Epsilon]\ g\_1[t] + 
            \[Epsilon]\^2\ g\_2[t]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["z", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          \(I\ \[CapitalOmega]\ z[t]\)}]}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["where the overbar denotes the complex conjugate", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(conjugateRule = {\[Eta] -> \[Eta]\&_, \[Eta]\&_ -> \[Eta], g -> g\&_, 
        g\&_ -> g, z -> z\&_, z\&_ -> z, 
        Complex[0, n_] -> Complex[0, \(-n\)]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the expansion for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Zeta]\)]],
  ", the ",
  StyleBox["zetaRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", into ",
  StyleBox["eq44a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", using the ",
  StyleBox["etaRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", expanding the result for small \[Epsilon], and discarding terms of order \
higher than ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Epsilon]\^2, \)\)]],
  " we have"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eq44b = 
      \((\(\(eq44a[\([1]\)] /. zetaRule\) /. etaRule\) /. 
              \((etaRule /. conjugateRule)\) // ExpandAll)\) /. 
        \[Epsilon]\^\(n_ /; n > 2\) -> 0; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Equating coefficients of like powers of \[Epsilon] in ",
  StyleBox["eq44b",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(eqEps = 
      CoefficientList[Subtract\ @@\ eq44b, \[Epsilon]] == 0 // Thread; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["First-Order Solution", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell["Using the method of undetermined coefficients, we assume", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coeffsL = Table[\[CapitalDelta]\_i, {i, Length[basicTerms]}]\)], "Input",\

  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalDelta]\_1, \[CapitalDelta]\_2, \[CapitalDelta]\_3, 
      \[CapitalDelta]\_4}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(\(hFormL = {
        h\_0 -> \((
            Evaluate[
                coeffsL . basicTerms /. 
                  Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)\), 
        h\&_\_0 -> 
          \((Evaluate[
                \(coeffsL . basicTerms /. conjugateRule\) /. 
                  Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)\)}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the ",
  StyleBox["hFormL",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eqEps[[1]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", collecting the coefficients of the ",
  StyleBox["basicTerms",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and solving for the ",
  StyleBox["coeffsL",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coeffsLRule = 
      \(Solve[Coefficient[eqEps[\([1, 1]\)] /. hFormL, basicTerms] == 0 // 
            Thread, coeffsL]\)[\([1]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Solve::"svars" \( : \ \) 
      "Equations may not give solutions for all \"solve\" variables."\)], 
  "Message",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalDelta]\_2 \[Rule] 0, 
      \[CapitalDelta]\_3 \[Rule] 
        1\/\(4\ \[Omega]\ \((\[Omega] - \[CapitalOmega])\)\), 
      \[CapitalDelta]\_4 \[Rule] 
        1\/\(4\ \[Omega]\ \((\[Omega] + \[CapitalOmega])\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting the ",
  StyleBox["coeffsLRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the ",
  StyleBox["hFormL ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(hSolL = 
      \(\(h\_0\ @@\ basicTerms /. hFormL\) /. coeffsLRule\) /. 
        \[CapitalDelta]\_i_ -> 0\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(z[t]\/\(4\ \[Omega]\ \((\[Omega] - \[CapitalOmega])\)\) + 
      z\&_[t]\/\(4\ \[Omega]\ \((\[Omega] + \[CapitalOmega])\)\)\)], "Output",\

  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Then, we write the first-order solution in pure function form as\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(hRuleL = {
        h\_0 -> \((
            Evaluate[hSolL /. Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)\), 
        h\&_\_0 -> 
          \((Evaluate[
                \(hSolL /. conjugateRule\) /. 
                  Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)\)}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({h\_0 \[Rule] 
        \((#3\/\(4\ \[Omega]\ \((\[Omega] - \[CapitalOmega])\)\) + #4
                \/\(4\ \[Omega]\ \((\[Omega] + \[CapitalOmega])\)\)&)\), 
      h\&_\_0 \[Rule] 
        \((#3\/\(4\ \[Omega]\ \((\[Omega] + \[CapitalOmega])\)\) + #4
                \/\(4\ \[Omega]\ \((\[Omega] - \[CapitalOmega])\)\)&)\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Second-Order Solution", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the ",
  StyleBox["hRuleL",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the left-hand side of the second-order equation, ",
  StyleBox["eqEps[[2]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(order2expr = eqEps[\([2, 1]\)] /. hRuleL // Expand\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
    \(\(\[Mu]\ z[t]\)\/\(4\ \[Omega]\ \((\[Omega] - \[CapitalOmega])\)\)\), 
      "-", \(\(\[Mu]\ z[t]\)\/\(4\ \[Omega]\ 
            \((\[Omega] + \[CapitalOmega])\)\)\), "-", 
      \(\(I\ \[Delta]\ z[t]\^2\)\/\(32\ \[Omega]\^3\ 
            \((\[Omega] - \[CapitalOmega])\)\^2\)\), "-", 
      \(\(I\ \[Delta]\ z[t]\^2\)\/\(32\ \[Omega]\^3\ 
            \((\[Omega] + \[CapitalOmega])\)\^2\)\), "-", 
      \(\(I\ \[Delta]\ z[t]\^2\)\/\(16\ \[Omega]\^3\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\)\), "+", \(\[Mu]\ \[Eta][t]\), 
      "-", \(\(I\ \[Delta]\ z[t]\ \[Eta][t]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] - \[CapitalOmega])\)\)\), "-", 
      \(\(I\ \[Delta]\ z[t]\ \[Eta][t]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] + \[CapitalOmega])\)\)\), "-", 
      \(\(I\ \[Delta]\ \[Eta][t]\^2\)\/\(2\ \[Omega]\)\), "-", 
      \(\(\[Mu]\ z\&_[t]\)\/\(4\ \[Omega]\ 
            \((\[Omega] - \[CapitalOmega])\)\)\), "+", 
      \(\(\[Mu]\ z\&_[t]\)\/\(4\ \[Omega]\ 
            \((\[Omega] + \[CapitalOmega])\)\)\), "-", 
      \(\(I\ \[Delta]\ z[t]\ z\&_[t]\)\/\(16\ \[Omega]\^3\ 
            \((\[Omega] - \[CapitalOmega])\)\^2\)\), "-", 
      \(\(I\ \[Delta]\ z[t]\ z\&_[t]\)\/\(16\ \[Omega]\^3\ 
            \((\[Omega] + \[CapitalOmega])\)\^2\)\), "-", 
      \(\(I\ \[Delta]\ z[t]\ z\&_[t]\)\/\(8\ \[Omega]\^3\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\)\), "-", 
      \(\(I\ \[Delta]\ \[Eta][t]\ z\&_[t]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] - \[CapitalOmega])\)\)\), "-", 
      \(\(I\ \[Delta]\ \[Eta][t]\ z\&_[t]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] + \[CapitalOmega])\)\)\), "-", 
      \(\(I\ \[Delta]\ z\&_[t]\^2\)\/\(32\ \[Omega]\^3\ 
            \((\[Omega] - \[CapitalOmega])\)\^2\)\), "-", 
      \(\(I\ \[Delta]\ z\&_[t]\^2\)\/\(32\ \[Omega]\^3\ 
            \((\[Omega] + \[CapitalOmega])\)\^2\)\), "-", 
      \(\(I\ \[Delta]\ z\&_[t]\^2\)\/\(16\ \[Omega]\^3\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\)\), "-", 
      \(\[Mu]\ \[Eta]\&_[t]\), "-", 
      \(\(I\ \[Delta]\ z[t]\ \[Eta]\&_[t]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] - \[CapitalOmega])\)\)\), "-", 
      \(\(I\ \[Delta]\ z[t]\ \[Eta]\&_[t]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] + \[CapitalOmega])\)\)\), "-", 
      \(\(I\ \[Delta]\ \[Eta][t]\ \[Eta]\&_[t]\)\/\[Omega]\), "-", 
      \(\(I\ \[Delta]\ z\&_[t]\ \[Eta]\&_[t]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] - \[CapitalOmega])\)\)\), "-", 
      \(\(I\ \[Delta]\ z\&_[t]\ \[Eta]\&_[t]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] + \[CapitalOmega])\)\)\), "-", 
      \(\(I\ \[Delta]\ \[Eta]\&_[t]\^2\)\/\(2\ \[Omega]\)\), "+", 
      \(g\_1[t]\), "-", 
      \(I\ \[Omega]\ h\_1[\[Eta][t], \[Eta]\&_[t], z[t], z\&_[t]]\), "-", 
      RowBox[{"I", " ", "\[CapitalOmega]", " ", \(z\&_[t]\), " ", 
        RowBox[{
          SubsuperscriptBox["h", "1", 
            TagBox[\((0, 0, 0, 1)\),
              Derivative],
            MultilineFunction->None], "[", \(\[Eta][t], \[Eta]\&_[t], z[t], 
          z\&_[t]\), "]"}]}], "+", 
      RowBox[{"I", " ", "\[CapitalOmega]", " ", \(z[t]\), " ", 
        RowBox[{
          SubsuperscriptBox["h", "1", 
            TagBox[\((0, 0, 1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(\[Eta][t], \[Eta]\&_[t], z[t], 
          z\&_[t]\), "]"}]}], "-", 
      RowBox[{"I", " ", "\[Omega]", " ", \(\[Eta]\&_[t]\), " ", 
        RowBox[{
          SubsuperscriptBox["h", "1", 
            TagBox[\((0, 1, 0, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(\[Eta][t], \[Eta]\&_[t], z[t], 
          z\&_[t]\), "]"}]}], "+", 
      RowBox[{"I", " ", "\[Omega]", " ", \(\[Eta][t]\), " ", 
        RowBox[{
          SubsuperscriptBox["h", "1", 
            TagBox[\((1, 0, 0, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(\[Eta][t], \[Eta]\&_[t], z[t], 
          z\&_[t]\), "]"}]}]}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "We choose ",
  Cell[BoxData[
      \(TraditionalForm\`h\_1\)]],
  " to eliminate as many terms from ",
  StyleBox["order2expr",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", thereby reducing it to its simplest possible form. It turns out that we \
can eliminate all nonresonance terms. To determine the resonance terms in ",
  StyleBox["order2expr",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we first determine all of the possible forms of its nonhomogeneous \
terms:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(possibleQTerms = 
      basicTerms~Join~
        \((\(Outer[Times, basicTerms, basicTerms] // Flatten\) // Union)
          \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Eta][t], \[Eta]\&_[t], z[t], z\&_[t], z[t]\^2, z[t]\ \[Eta][t], 
      \[Eta][t]\^2, z[t]\ z\&_[t], \[Eta][t]\ z\&_[t], z\&_[t]\^2, 
      z[t]\ \[Eta]\&_[t], \[Eta][t]\ \[Eta]\&_[t], z\&_[t]\ \[Eta]\&_[t], 
      \[Eta]\&_[t]\^2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "It follows from the linear parts of the ",
  StyleBox["etaRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " that"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(form = {\[Eta][t] -> E\^\(I\ \[Omega]\ t\), 
        \[Eta]\&_[t] -> E\^\(\(-I\)\ \[Omega]\ t\), 
        z[t] -> E\^\(I\ \[CapitalOmega]\ t\), 
        z\&_[t] -> E\^\(\(-I\)\ \[CapitalOmega]\ t\)}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["Hence, the possible resonance terms are given by", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ResonantQTerm = 
      \(\((\(\(\(E\^\(\(-I\)\ \[Omega]\ t\)\) possibleQTerms /. form\) /. 
                  \[CapitalOmega] -> 2\ \[Omega]\) /. E\^\(_\ t\) -> 0)\)\ 
            possibleQTerms // Union\) // Rest\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Eta][t], z[t]\ \[Eta]\&_[t]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "We choose ",
  Cell[BoxData[
      \(TraditionalForm\`g\_1\)]],
  " to eliminate the resonance terms in ",
  StyleBox["order2expr",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " according to"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(gRuleQ = 
      g\_1[t] -> 
        \(-\((Coefficient[order2expr /. h\_1 -> \((0&)\), ResonantQTerm] /. 
                Thread[basicTerms -> 0])\) . ResonantQTerm\)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(g\_1[t] \[Rule] 
      \(-\[Mu]\)\ \[Eta][t] - 
        \((\(-\(\(I\ \[Delta]\)\/\(4\ \[Omega]\^2\ 
                      \((\[Omega] - \[CapitalOmega])\)\)\)\) - 
              \(I\ \[Delta]\)\/\(4\ \[Omega]\^2\ 
                  \((\[Omega] + \[CapitalOmega])\)\))\)\ z[t]\ 
          \[Eta]\&_[t]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
The nonresonance terms are the complement of the resonance terms; that is,\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(NRQT = Complement[possibleQTerms, ResonantQTerm]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
We associate with each of them an undetermined coefficient according to\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coeffsQ = Table[\[CapitalGamma]\_j, {j, Length[NRQT]}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalGamma]\_1, \[CapitalGamma]\_2, \[CapitalGamma]\_3, 
      \[CapitalGamma]\_4, \[CapitalGamma]\_5, \[CapitalGamma]\_6, 
      \[CapitalGamma]\_7, \[CapitalGamma]\_8, \[CapitalGamma]\_9, 
      \[CapitalGamma]\_10, \[CapitalGamma]\_11, \[CapitalGamma]\_12}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Therefore, ",
  Cell[BoxData[
      \(TraditionalForm\`h\_1\)]],
  " has the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(hFormQ = {
        h\_1 -> \((
            Evaluate[coeffsQ . NRQT /. Thread[basicTerms -> {#1, #2, #3, #4}]]
                \ &)\)}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({h\_1 \[Rule] 
        \((#3\ \[CapitalGamma]\_1 + #3\^2\ \[CapitalGamma]\_2 + #1\ #3\ 
                \[CapitalGamma]\_3 + #1\^2\ \[CapitalGamma]\_4 + #4\ 
                \[CapitalGamma]\_5 + #3\ #4\ \[CapitalGamma]\_6 + #1\ #4\ 
                \[CapitalGamma]\_7 + #4\^2\ \[CapitalGamma]\_8 + #2\ 
                \[CapitalGamma]\_9 + #1\ #2\ \[CapitalGamma]\_10 + #2\ #4\ 
                \[CapitalGamma]\_11 + #2\^2\ \[CapitalGamma]\_12&)\)}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting for ",
  Cell[BoxData[
      \(TraditionalForm\`h\_1\)]],
  " in ",
  StyleBox["order2expr",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", equating the coefficients of the possible nonresonance terms to zero, \
and solving the resulting equations for the ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalGamma]\_i\)]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coeffsQRule = 
      \(Solve[Coefficient[\(order2expr /. gRuleQ\) /. hFormQ // Expand, 
                  NRQT] == 0 /. Thread[basicTerms -> 0] // Thread, coeffsQ]\)[
        \([1]\)]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalGamma]\_3 \[Rule] 
        \(-\(\[Delta]\/\(2\ \[Omega]\ \[CapitalOmega]\ 
                \((\(-\[Omega]\) + \[CapitalOmega])\)\ 
                \((\[Omega] + \[CapitalOmega])\)\)\)\), 
      \[CapitalGamma]\_4 \[Rule] \[Delta]\/\(2\ \[Omega]\^2\), 
      \[CapitalGamma]\_6 \[Rule] 
        \(-\(\[Delta]\/\(4\ \[Omega]\^2\ \((\[Omega] - \[CapitalOmega])\)\^2\ 
                \((\[Omega] + \[CapitalOmega])\)\^2\)\)\), 
      \[CapitalGamma]\_7 \[Rule] 
        \[Delta]\/\(2\ \[Omega]\ \[CapitalOmega]\ 
            \((\(-\[Omega]\) + \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\), 
      \[CapitalGamma]\_9 \[Rule] \(I\ \[Mu]\)\/\(2\ \[Omega]\), 
      \[CapitalGamma]\_10 \[Rule] \(-\(\[Delta]\/\[Omega]\^2\)\), 
      \[CapitalGamma]\_12 \[Rule] \(-\(\[Delta]\/\(6\ \[Omega]\^2\)\)\), 
      \[CapitalGamma]\_1 \[Rule] 
        \(-\(\(I\ \[Mu]\ \[CapitalOmega]\)\/\(2\ \[Omega]\ 
                \((\[Omega] - \[CapitalOmega])\)\^2\ 
                \((\[Omega] + \[CapitalOmega])\)\)\)\), 
      \[CapitalGamma]\_2 \[Rule] 
        \(-\(\[Delta]\/\(8\ \[Omega]\ \((\[Omega] - 2\ \[CapitalOmega])\)\ 
                \((\[Omega] - \[CapitalOmega])\)\^2\ 
                \((\[Omega] + \[CapitalOmega])\)\^2\)\)\), 
      \[CapitalGamma]\_5 \[Rule] 
        \(I\ \[Mu]\ \[CapitalOmega]\)\/\(2\ \[Omega]\ 
            \((\[Omega] - \[CapitalOmega])\)\ 
            \((\[Omega] + \[CapitalOmega])\)\^2\), 
      \[CapitalGamma]\_11 \[Rule] 
        \(-\(\[Delta]\/\(2\ \[Omega]\ \((\[Omega] - \[CapitalOmega])\)\ 
                \((\[Omega] + \[CapitalOmega])\)\ 
                \((2\ \[Omega] + \[CapitalOmega])\)\)\)\), 
      \[CapitalGamma]\_8 \[Rule] 
        \(-\(\[Delta]\/\(8\ \[Omega]\ \((\[Omega] - \[CapitalOmega])\)\^2\ 
                \((\[Omega] + \[CapitalOmega])\)\^2\ 
                \((\[Omega] + 2\ \[CapitalOmega])\)\)\)\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Substituting the ",
  StyleBox["coeffsQRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the ",
  StyleBox["hFormQ ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(hSolQ = \(h\_1\ @@\ basicTerms /. hFormQ\) /. coeffsQRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(-\(\(I\ \[Mu]\ \[CapitalOmega]\ z[t]\)\/\(2\ \[Omega]\ 
              \((\[Omega] - \[CapitalOmega])\)\^2\ 
              \((\[Omega] + \[CapitalOmega])\)\)\)\) - 
      \(\[Delta]\ z[t]\^2\)\/\(8\ \[Omega]\ 
          \((\[Omega] - 2\ \[CapitalOmega])\)\ 
          \((\[Omega] - \[CapitalOmega])\)\^2\ 
          \((\[Omega] + \[CapitalOmega])\)\^2\) - 
      \(\[Delta]\ z[t]\ \[Eta][t]\)\/\(2\ \[Omega]\ \[CapitalOmega]\ 
          \((\(-\[Omega]\) + \[CapitalOmega])\)\ 
          \((\[Omega] + \[CapitalOmega])\)\) + 
      \(\[Delta]\ \[Eta][t]\^2\)\/\(2\ \[Omega]\^2\) + 
      \(I\ \[Mu]\ \[CapitalOmega]\ z\&_[t]\)\/\(2\ \[Omega]\ 
          \((\[Omega] - \[CapitalOmega])\)\ 
          \((\[Omega] + \[CapitalOmega])\)\^2\) - 
      \(\[Delta]\ z[t]\ z\&_[t]\)\/\(4\ \[Omega]\^2\ 
          \((\[Omega] - \[CapitalOmega])\)\^2\ 
          \((\[Omega] + \[CapitalOmega])\)\^2\) + 
      \(\[Delta]\ \[Eta][t]\ z\&_[t]\)\/\(2\ \[Omega]\ \[CapitalOmega]\ 
          \((\(-\[Omega]\) + \[CapitalOmega])\)\ 
          \((\[Omega] + \[CapitalOmega])\)\) - 
      \(\[Delta]\ z\&_[t]\^2\)\/\(8\ \[Omega]\ 
          \((\[Omega] - \[CapitalOmega])\)\^2\ 
          \((\[Omega] + \[CapitalOmega])\)\^2\ 
          \((\[Omega] + 2\ \[CapitalOmega])\)\) + 
      \(I\ \[Mu]\ \[Eta]\&_[t]\)\/\(2\ \[Omega]\) - 
      \(\[Delta]\ \[Eta][t]\ \[Eta]\&_[t]\)\/\[Omega]\^2 - 
      \(\[Delta]\ z\&_[t]\ \[Eta]\&_[t]\)\/\(2\ \[Omega]\ 
          \((\[Omega] - \[CapitalOmega])\)\ \((\[Omega] + \[CapitalOmega])\)\ 
          \((2\ \[Omega] + \[CapitalOmega])\)\) - 
      \(\[Delta]\ \[Eta]\&_[t]\^2\)\/\(6\ \[Omega]\^2\)\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Hence, we can write the second-order solution in pure function form as\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(hRuleQ = {
        h\_1 -> \((
            Evaluate[hSolQ /. Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)\), 
        h\&_\_1 -> 
          \((Evaluate[
                \(hSolQ /. conjugateRule\) /. 
                  Thread[basicTerms -> {#1, #2, #3, #4}]]\ &)\)}; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["Third-Order Equations", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the ",
  StyleBox["hRuleL",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["hRuleQ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and ",
  StyleBox["gRuleQ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the left-hand side of the third-order equation, ",
  StyleBox["eqEps[[3]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(order3expr = 
      \(\(\(eqEps[\([3, 1]\)] /. hRuleL\) /. hRuleQ\) /. gRuleQ\) /. 
          \((gRuleQ /. conjugateRule)\) // Expand; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The nonhomogeneous terms in ",
  StyleBox["order3expr",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " are proportional to"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(possibleCTerms = 
      \(Outer[Times, possibleQTerms, basicTerms] // Flatten\) // Union\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({z[t]\^2, z[t]\^3, z[t]\ \[Eta][t], z[t]\^2\ \[Eta][t], \[Eta][t]\^2, 
      z[t]\ \[Eta][t]\^2, \[Eta][t]\^3, z[t]\ z\&_[t], z[t]\^2\ z\&_[t], 
      \[Eta][t]\ z\&_[t], z[t]\ \[Eta][t]\ z\&_[t], \[Eta][t]\^2\ z\&_[t], 
      z\&_[t]\^2, z[t]\ z\&_[t]\^2, \[Eta][t]\ z\&_[t]\^2, z\&_[t]\^3, 
      z[t]\ \[Eta]\&_[t], z[t]\^2\ \[Eta]\&_[t], \[Eta][t]\ \[Eta]\&_[t], 
      z[t]\ \[Eta][t]\ \[Eta]\&_[t], \[Eta][t]\^2\ \[Eta]\&_[t], 
      z\&_[t]\ \[Eta]\&_[t], z[t]\ z\&_[t]\ \[Eta]\&_[t], 
      \[Eta][t]\ z\&_[t]\ \[Eta]\&_[t], z\&_[t]\^2\ \[Eta]\&_[t], 
      \[Eta]\&_[t]\^2, z[t]\ \[Eta]\&_[t]\^2, \[Eta][t]\ \[Eta]\&_[t]\^2, 
      z\&_[t]\ \[Eta]\&_[t]\^2, \[Eta]\&_[t]\^3}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(possibleTerms = Join[possibleQTerms, possibleCTerms] // Union\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({z[t], z[t]\^2, z[t]\^3, \[Eta][t], z[t]\ \[Eta][t], 
      z[t]\^2\ \[Eta][t], \[Eta][t]\^2, z[t]\ \[Eta][t]\^2, \[Eta][t]\^3, 
      z\&_[t], z[t]\ z\&_[t], z[t]\^2\ z\&_[t], \[Eta][t]\ z\&_[t], 
      z[t]\ \[Eta][t]\ z\&_[t], \[Eta][t]\^2\ z\&_[t], z\&_[t]\^2, 
      z[t]\ z\&_[t]\^2, \[Eta][t]\ z\&_[t]\^2, z\&_[t]\^3, \[Eta]\&_[t], 
      z[t]\ \[Eta]\&_[t], z[t]\^2\ \[Eta]\&_[t], \[Eta][t]\ \[Eta]\&_[t], 
      z[t]\ \[Eta][t]\ \[Eta]\&_[t], \[Eta][t]\^2\ \[Eta]\&_[t], 
      z\&_[t]\ \[Eta]\&_[t], z[t]\ z\&_[t]\ \[Eta]\&_[t], 
      \[Eta][t]\ z\&_[t]\ \[Eta]\&_[t], z\&_[t]\^2\ \[Eta]\&_[t], 
      \[Eta]\&_[t]\^2, z[t]\ \[Eta]\&_[t]\^2, \[Eta][t]\ \[Eta]\&_[t]\^2, 
      z\&_[t]\ \[Eta]\&_[t]\^2, \[Eta]\&_[t]\^3}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["Next, we determine the resonance terms according to", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(ResonantCTerm = 
      \(\((\(\(\(E\^\(\(-I\)\ \[Omega]\ t\)\) possibleTerms /. form\) /. 
                  \[CapitalOmega] -> 2\ \[Omega]\) /. E\^\(_\ t\) -> 0)\)\ 
            possibleTerms // Union\) // Rest\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[Eta][t], z[t]\ \[Eta][t]\ z\&_[t], z[t]\ \[Eta]\&_[t], 
      \[Eta][t]\^2\ \[Eta]\&_[t]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Choosing ",
  Cell[BoxData[
      \(TraditionalForm\`g\_2\)]],
  " to eliminate the resonance terms from ",
  StyleBox["order3expr",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(gRuleC = 
      g\_2[t] -> 
        \(-Factor[
              Coefficient[order3expr /. h\_2 -> \((0&)\), ResonantCTerm] /. 
                Thread[basicTerms -> 0]] . ResonantCTerm\)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(g\_2[t] \[Rule] 
      \(-\(\(I\ \[Mu]\^2\ \[Eta][t]\)\/\(2\ \[Omega]\)\)\) + 
        \(I\ \((\(-5\)\ \[Delta]\^2\ \[Omega] + 6\ \[Alpha]\ \[Omega]\^3 - 
                2\ \[Delta]\^2\ \[CapitalOmega] + 
                3\ \[Alpha]\ \[Omega]\^2\ \[CapitalOmega])\)\ z[t]\ 
            \[Eta][t]\ z\&_[t]\)\/\(4\ \[Omega]\^3\ 
            \((\[Omega] - \[CapitalOmega])\)\^2\ 
            \((\[Omega] + \[CapitalOmega])\)\^2\ 
            \((2\ \[Omega] + \[CapitalOmega])\)\) - 
        \(\[Delta]\ \[Mu]\ 
            \((2\ \[Omega]\^3 + \[Omega]\^2\ \[CapitalOmega] - 
                6\ \[Omega]\ \[CapitalOmega]\^2 - \[CapitalOmega]\^3)\)\ 
            z[t]\ \[Eta]\&_[t]\)\/\(4\ \[Omega]\^2\ 
            \((\[Omega] - \[CapitalOmega])\)\^2\ \[CapitalOmega]\ 
            \((\[Omega] + \[CapitalOmega])\)\^2\) - 
        \(I\ \((10\ \[Delta]\^2 - 9\ \[Alpha]\ \[Omega]\^2)\)\ \[Eta][t]\^2\ 
            \[Eta]\&_[t]\)\/\(6\ \[Omega]\^3\)\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
The nonresonance terms are the complement of the resonance terms; that is,\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(NRCT = Complement[possibleTerms, ResonantCTerm]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
Again, we associate an undetermined coefficient with each of these terms as \
follows:\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(coeffsC = Table[\[CapitalLambda]\_j, {j, Length[NRCT]}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\[CapitalLambda]\_1, \[CapitalLambda]\_2, \[CapitalLambda]\_3, 
      \[CapitalLambda]\_4, \[CapitalLambda]\_5, \[CapitalLambda]\_6, 
      \[CapitalLambda]\_7, \[CapitalLambda]\_8, \[CapitalLambda]\_9, 
      \[CapitalLambda]\_10, \[CapitalLambda]\_11, \[CapitalLambda]\_12, 
      \[CapitalLambda]\_13, \[CapitalLambda]\_14, \[CapitalLambda]\_15, 
      \[CapitalLambda]\_16, \[CapitalLambda]\_17, \[CapitalLambda]\_18, 
      \[CapitalLambda]\_19, \[CapitalLambda]\_20, \[CapitalLambda]\_21, 
      \[CapitalLambda]\_22, \[CapitalLambda]\_23, \[CapitalLambda]\_24, 
      \[CapitalLambda]\_25, \[CapitalLambda]\_26, \[CapitalLambda]\_27, 
      \[CapitalLambda]\_28, \[CapitalLambda]\_29, \[CapitalLambda]\_30}\)], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Consequently, ",
  Cell[BoxData[
      \(TraditionalForm\`h\_2\)]],
  " has the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(hFormC = {
        h\_2 -> \((
            Evaluate[coeffsC . NRCT /. Thread[basicTerms -> {#1, #2, #3, #4}]]
                \ &)\)}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting for ",
  Cell[BoxData[
      \(TraditionalForm\`h\_2\)]],
  " into ",
  StyleBox["order3expr",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", equating the coefficient of each possible nonresonance term to zero, and \
solving the resulting algebraic equations for the ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalLambda]\_i\)]],
  ", we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(coeffsCRule = 
      \(Solve[Coefficient[\(order3expr /. gRuleC\) /. hFormC // Expand, 
                    NRCT] == 0 /. Thread[basicTerms -> 0] // Thread, coeffsC]
            \)[\([1]\)] // ExpandAll; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Substituting the ",
  StyleBox["coeffsCRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into the ",
  StyleBox["hFormC",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " yields"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(hSolC = \(h\_2\ @@\ basicTerms /. hFormC\) /. coeffsCRule; \)\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Combining the ",
  StyleBox["etaRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", ",
  StyleBox["gRuleQ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", and ",
  StyleBox["gRuleC ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "and letting"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(solForm = {\[Eta] -> \((A[#]\ E\^\(I\ \[Omega]\ #\)&)\), 
        \[Eta]\&_ -> \((A\&_[#]\ E\^\(\(-I\)\ \[Omega]\ #\)&)\), 
        z -> \((f\ E\^\(I\ \[CapitalOmega]\ #\)&)\), 
        z\&_ -> \((f\ E\^\(\(-I\)\ \[CapitalOmega]\ #\)&)\)}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["we obtain the modulation equation", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(moduEq = 
      \((\(2\ I\ \[Omega]\ \(E\^\(\(-I\)\ \[Omega]\ t\)\) 
                  \((\(\[Eta]\^\[Prime]\)[t] - 
                      \((\(\(\(\[Eta]\^\[Prime]\)[t] /. etaRule\) /. gRuleQ
                            \) /. gRuleC)\))\) /. solForm // Expand\) // 
            Collect[#, \[Epsilon]]&)\) == 0\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\[Epsilon]\ 
          \((2\ I\ \[Mu]\ \[Omega]\ A[t] + 
              \(E\^\(\(-2\)\ I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ f\ 
                  \[Delta]\ A\&_[t]\)\/\(2\ \[Omega]\ 
                  \((\[Omega] - \[CapitalOmega])\)\) + 
              \(E\^\(\(-2\)\ I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ f\ 
                  \[Delta]\ A\&_[t]\)\/\(2\ \[Omega]\ 
                  \((\[Omega] + \[CapitalOmega])\)\))\)\), "+", 
        \(\[Epsilon]\^2\ 
          \((\(-\[Mu]\^2\)\ A[t] - 
              \(5\ f\^2\ \[Delta]\^2\ A[t]\)\/\(2\ \[Omega]\ 
                  \((\[Omega] - \[CapitalOmega])\)\^2\ 
                  \((\[Omega] + \[CapitalOmega])\)\^2\ 
                  \((2\ \[Omega] + \[CapitalOmega])\)\) + 
              \(3\ f\^2\ \[Alpha]\ \[Omega]\ 
                  A[t]\)\/\(\((\[Omega] - \[CapitalOmega])\)\^2\ 
                  \((\[Omega] + \[CapitalOmega])\)\^2\ 
                  \((2\ \[Omega] + \[CapitalOmega])\)\) + 
              \(3\ f\^2\ \[Alpha]\ \[CapitalOmega]\ A[t]\)\/\(2\ 
                  \((\[Omega] - \[CapitalOmega])\)\^2\ 
                  \((\[Omega] + \[CapitalOmega])\)\^2\ 
                  \((2\ \[Omega] + \[CapitalOmega])\)\) - 
              \(f\^2\ \[Delta]\^2\ \[CapitalOmega]\ A[t]\)\/\(\[Omega]\^2\ 
                  \((\[Omega] - \[CapitalOmega])\)\^2\ 
                  \((\[Omega] + \[CapitalOmega])\)\^2\ 
                  \((2\ \[Omega] + \[CapitalOmega])\)\) + 
              \(I\ E\^\(\(-2\)\ I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ f\ 
                  \[Delta]\ \[Mu]\ \[Omega]\ A\&_[t]\)\/\(2\ 
                  \((\[Omega] - \[CapitalOmega])\)\^2\ 
                  \((\[Omega] + \[CapitalOmega])\)\^2\) + 
              \(I\ E\^\(\(-2\)\ I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ f\ 
                  \[Delta]\ \[Mu]\ \[Omega]\^2\ 
                  A\&_[t]\)\/\(\((\[Omega] - \[CapitalOmega])\)\^2\ 
                  \[CapitalOmega]\ \((\[Omega] + \[CapitalOmega])\)\^2\) - 
              \(3\ I\ E\^\(\(-2\)\ I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ f
                  \ \[Delta]\ \[Mu]\ \[CapitalOmega]\ 
                  A\&_[t]\)\/\(\((\[Omega] - \[CapitalOmega])\)\^2\ 
                  \((\[Omega] + \[CapitalOmega])\)\^2\) - 
              \(I\ E\^\(\(-2\)\ I\ t\ \[Omega] + I\ t\ \[CapitalOmega]\)\ f\ 
                  \[Delta]\ \[Mu]\ \[CapitalOmega]\^2\ A\&_[t]\)\/\(2\ 
                  \[Omega]\ \((\[Omega] - \[CapitalOmega])\)\^2\ 
                  \((\[Omega] + \[CapitalOmega])\)\^2\) + 
              3\ \[Alpha]\ A[t]\^2\ A\&_[t] - 
              \(10\ \[Delta]\^2\ A[t]\^2\ A\&_[t]\)\/\(3\ \[Omega]\^2\))\)\), 
        "+", 
        RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
          RowBox[{
            SuperscriptBox["A", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], "==", "0"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["or", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(moduEq /. 
        f -> 2  \[CapitalLambda]\ \((\[CapitalOmega]\^2 - \[Omega]\^2)\)\) /. 
      \[CapitalOmega] -> 2  \[Omega]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\[Epsilon]\ 
          \((2\ I\ \[Mu]\ \[Omega]\ A[t] - 
              2\ \[Delta]\ \[CapitalLambda]\ A\&_[t])\)\), "+", 
        \(\[Epsilon]\^2\ 
          \((6\ \[Alpha]\ \[CapitalLambda]\^2\ A[t] - \[Mu]\^2\ A[t] - 
              \(9\ \[Delta]\^2\ \[CapitalLambda]\^2\ A[t]\)\/\(2\ 
                  \[Omega]\^2\) - 
              \(14\ I\ \[Delta]\ \[CapitalLambda]\ \[Mu]\ A\&_[t]\)\/\(3\ 
                  \[Omega]\) + 3\ \[Alpha]\ A[t]\^2\ A\&_[t] - 
              \(10\ \[Delta]\^2\ A[t]\^2\ A\&_[t]\)\/\(3\ \[Omega]\^2\))\)\), 
        "+", 
        RowBox[{"2", " ", "I", " ", "\[Omega]", " ", 
          RowBox[{
            SuperscriptBox["A", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], "==", "0"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
which is in agreement with those obtained by using the method of multiple \
scales and the generalized method of averaging.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 712}},
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{703, 567},
WindowMargins->{{1, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingStartingPageNumber->75,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PrintingOptions->{"FirstPageHeader"->False,
"FacingPages"->True},
Magnification->1
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "ChapterTwo"->{
    Cell[3656, 109, 268, 6, 53, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[145830, 4228, 189, 4, 43, "Subsection",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[226501, 6676, 192, 4, 43, "Subsection",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[266926, 7768, 242, 8, 43, "Subsection",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[308752, 8753, 278, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}]},
  "ChapterTwo.2"->{
    Cell[3656, 109, 268, 6, 53, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[145830, 4228, 189, 4, 43, "Subsection",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[226501, 6676, 192, 4, 43, "Subsection",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[266926, 7768, 242, 8, 43, "Subsection",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[308752, 8753, 278, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}]},
  "ChapterTwo.2.1"->{
    Cell[3656, 109, 268, 6, 53, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[145830, 4228, 189, 4, 43, "Subsection",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[226501, 6676, 192, 4, 43, "Subsection",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[266926, 7768, 242, 8, 43, "Subsection",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
    Cell[308752, 8753, 278, 6, 46, "Section",
      Evaluatable->False,
      CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"ChapterTwo", 381898, 10891},
  {"ChapterTwo.2", 382620, 10907},
  {"ChapterTwo.2.1", 383344, 10923}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 125, 5, 195, "Title"],
Cell[1859, 58, 100, 3, 30, "Input"],
Cell[1962, 63, 221, 5, 52, "Text"],
Cell[2186, 70, 276, 6, 30, "Input"],
Cell[2465, 78, 1166, 27, 128, "Text"],

Cell[CellGroupData[{
Cell[3656, 109, 268, 6, 53, "Section",
  Evaluatable->False,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
Cell[3927, 117, 238, 8, 33, "Text"],
Cell[4168, 127, 145, 4, 31, "Input"],
Cell[4316, 133, 625, 23, 40, "Text"],

Cell[CellGroupData[{
Cell[4966, 160, 253, 6, 22, "Input"],
Cell[5222, 168, 1434, 31, 45, "Output"]
}, Open  ]],
Cell[6671, 202, 148, 4, 26, "Text"],

Cell[CellGroupData[{
Cell[6844, 210, 180, 5, 22, "Input"],
Cell[7027, 217, 1405, 35, 34, "Output"]
}, Open  ]],
Cell[8447, 255, 174, 5, 26, "Text"],

Cell[CellGroupData[{
Cell[8646, 264, 196, 5, 22, "Input"],
Cell[8845, 271, 289, 7, 31, "Output"]
}, Open  ]],
Cell[9149, 281, 1769, 48, 126, "Text"],
Cell[10921, 331, 365, 10, 40, "Text"],
Cell[11289, 343, 174, 5, 22, "Input"],

Cell[CellGroupData[{
Cell[11488, 352, 262, 7, 22, "Input"],
Cell[11753, 361, 318, 8, 22, "Output"]
}, Open  ]],
Cell[12086, 372, 399, 15, 26, "Text"],

Cell[CellGroupData[{
Cell[12510, 391, 232, 5, 22, "Input"],
Cell[12745, 398, 1350, 25, 47, "Output"]
}, Open  ]],
Cell[14110, 426, 218, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[14353, 438, 298, 7, 47, "Input"],
Cell[14654, 447, 1837, 32, 79, "Output"]
}, Open  ]],
Cell[16506, 482, 1192, 35, 69, "Text"],
Cell[17701, 519, 665, 22, 40, "Text"],

Cell[CellGroupData[{
Cell[18391, 545, 159, 5, 22, "Input"],
Cell[18553, 552, 1233, 27, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19823, 584, 180, 5, 22, "Input"],
Cell[20006, 591, 1212, 31, 34, "Output"]
}, Open  ]],
Cell[21233, 625, 395, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[21653, 645, 110, 3, 22, "Input"],
Cell[21766, 650, 1338, 24, 57, "Output"]
}, Open  ]],
Cell[23119, 677, 219, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[23363, 689, 226, 6, 22, "Input"],
Cell[23592, 697, 1563, 29, 57, "Output"]
}, Open  ]],
Cell[25170, 729, 169, 7, 26, "Text"],
Cell[25342, 738, 372, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[25739, 758, 258, 6, 22, "Input"],
Cell[26000, 766, 9954, 176, 312, "Output"]
}, Open  ]],
Cell[35969, 945, 207, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[36201, 957, 334, 7, 60, "Input"],
Cell[36538, 966, 12872, 206, 438, "Output"]
}, Open  ]],
Cell[49425, 1175, 1455, 41, 69, "Text"],
Cell[50883, 1218, 775, 13, 97, "Text"],
Cell[51661, 1233, 475, 11, 54, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[52173, 1249, 99, 2, 46, "Section"],

Cell[CellGroupData[{
Cell[52297, 1255, 88, 2, 43, "Subsection"],
Cell[52388, 1259, 235, 6, 26, "Text"],
Cell[52626, 1267, 112, 3, 22, "Input"],
Cell[52741, 1272, 456, 15, 22, "Input"],
Cell[53200, 1289, 117, 3, 22, "Input"],
Cell[53320, 1294, 222, 6, 26, "Text"],
Cell[53545, 1302, 119, 3, 22, "Input"],
Cell[53667, 1307, 292, 8, 26, "Text"],
Cell[53962, 1317, 313, 6, 35, "Input"],
Cell[54278, 1325, 251, 8, 26, "Text"],
Cell[54532, 1335, 317, 7, 34, "Input"],
Cell[54852, 1344, 173, 5, 26, "Text"],
Cell[55028, 1351, 622, 13, 79, "Input"],
Cell[55653, 1366, 491, 16, 40, "Text"],
Cell[56147, 1384, 226, 5, 34, "Input"],
Cell[56376, 1391, 241, 8, 26, "Text"],
Cell[56620, 1401, 177, 5, 22, "Input"],
Cell[56800, 1408, 318, 7, 40, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[57155, 1420, 112, 3, 43, "Subsection"],
Cell[57270, 1425, 566, 16, 54, "Text"],
Cell[57839, 1443, 178, 5, 22, "Input"],
Cell[58020, 1450, 664, 25, 40, "Text"],

Cell[CellGroupData[{
Cell[58709, 1479, 284, 7, 47, "Input"],
Cell[58996, 1488, 3054, 77, 45, "Output"]
}, Open  ]],
Cell[62065, 1568, 250, 9, 26, "Text"],
Cell[62318, 1579, 227, 6, 22, "Input"],
Cell[62548, 1587, 171, 5, 26, "Text"],
Cell[62722, 1594, 196, 5, 22, "Input"],
Cell[62921, 1601, 393, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[63339, 1621, 112, 3, 22, "Input"],
Cell[63454, 1626, 2961, 76, 43, "Output"]
}, Open  ]],
Cell[66430, 1705, 233, 9, 26, "Text"],
Cell[66666, 1716, 267, 7, 22, "Input"],
Cell[66936, 1725, 295, 13, 26, "Text"],

Cell[CellGroupData[{
Cell[67256, 1742, 154, 4, 34, "Input"],
Cell[67413, 1748, 1172, 31, 23, "Output"]
}, Open  ]],
Cell[68600, 1782, 252, 9, 26, "Text"],

Cell[CellGroupData[{
Cell[68877, 1795, 177, 6, 22, "Input"],
Cell[69057, 1803, 333, 10, 22, "Output"]
}, Open  ]],
Cell[69405, 1816, 421, 17, 26, "Text"],

Cell[CellGroupData[{
Cell[69851, 1837, 437, 13, 22, "Input"],
Cell[70291, 1852, 310, 10, 22, "Output"]
}, Open  ]],
Cell[70616, 1865, 156, 7, 26, "Text"],
Cell[70775, 1874, 220, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[71020, 1886, 215, 6, 34, "Input"],
Cell[71238, 1894, 494, 13, 23, "Output"]
}, Open  ]],
Cell[71747, 1910, 288, 11, 26, "Text"],

Cell[CellGroupData[{
Cell[72060, 1925, 253, 6, 47, "Input"],
Cell[72316, 1933, 327, 7, 31, "Output"]
}, Open  ]],
Cell[72658, 1943, 289, 11, 26, "Text"],
Cell[72950, 1956, 192, 6, 22, "Input"],
Cell[73145, 1964, 438, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[73608, 1984, 166, 4, 34, "Input"],
Cell[73777, 1990, 3381, 78, 90, "Output"]
}, Open  ]],
Cell[77173, 2071, 270, 9, 26, "Text"],
Cell[77446, 2082, 176, 5, 22, "Input"],
Cell[77625, 2089, 416, 14, 40, "Text"],
Cell[78044, 2105, 196, 6, 22, "Input"],

Cell[CellGroupData[{
Cell[78265, 2115, 221, 6, 34, "Input"],
Cell[78489, 2123, 734, 18, 29, "Output"]
}, Open  ]],
Cell[79238, 2144, 387, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[79650, 2164, 211, 6, 22, "Input"],
Cell[79864, 2172, 550, 14, 30, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[80463, 2192, 123, 2, 43, "Subsection"],
Cell[80589, 2196, 636, 20, 40, "Text"],
Cell[81228, 2218, 155, 4, 22, "Input"],

Cell[CellGroupData[{
Cell[81408, 2226, 264, 6, 47, "Input"],
Cell[81675, 2234, 3051, 77, 45, "Output"]
}, Open  ]],
Cell[84741, 2314, 135, 3, 26, "Text"],
Cell[84879, 2319, 207, 5, 22, "Input"],
Cell[85089, 2326, 171, 5, 26, "Text"],
Cell[85263, 2333, 210, 5, 22, "Input"],
Cell[85476, 2340, 389, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[85890, 2360, 125, 3, 22, "Input"],
Cell[86018, 2365, 5857, 165, 48, "Output"]
}, Open  ]],
Cell[91890, 2533, 216, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[92131, 2545, 203, 5, 22, "Input"],
Cell[92337, 2552, 310, 7, 31, "Output"]
}, Open  ]],
Cell[92662, 2562, 211, 8, 26, "Text"],
Cell[92876, 2572, 208, 6, 22, "Input"],

Cell[CellGroupData[{
Cell[93109, 2582, 324, 8, 35, "Input"],
Cell[93436, 2592, 371, 8, 22, "Output"]
}, Open  ]],
Cell[93822, 2603, 279, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[94126, 2619, 154, 4, 34, "Input"],
Cell[94283, 2625, 1892, 43, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[96212, 2673, 133, 3, 34, "Subsubsection"],
Cell[96348, 2678, 304, 10, 26, "Text"],
Cell[96655, 2690, 159, 4, 22, "Input"],
Cell[96817, 2696, 193, 6, 22, "Input"],
Cell[97013, 2704, 184, 7, 26, "Text"],

Cell[CellGroupData[{
Cell[97222, 2715, 176, 5, 22, "Input"],
Cell[97401, 2722, 333, 10, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[97771, 2737, 417, 12, 22, "Input"],
Cell[98191, 2751, 310, 10, 22, "Output"]
}, Open  ]],
Cell[98516, 2764, 89, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[98630, 2770, 122, 3, 22, "Input"],
Cell[98755, 2775, 315, 10, 24, "Output"]
}, Open  ]],
Cell[99085, 2788, 340, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[99450, 2804, 162, 4, 22, "Input"],
Cell[99615, 2810, 1147, 24, 35, "Output"]
}, Open  ]],
Cell[100777, 2837, 464, 13, 54, "Text"],

Cell[CellGroupData[{
Cell[101266, 2854, 414, 9, 72, "Input"],
Cell[101683, 2865, 1443, 25, 57, "Output"]
}, Open  ]],
Cell[103141, 2893, 201, 7, 26, "Text"],
Cell[103345, 2902, 153, 4, 22, "Input"],
Cell[103501, 2908, 398, 16, 26, "Text"],
Cell[103902, 2926, 142, 4, 22, "Input"],
Cell[104047, 2932, 206, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[104278, 2944, 290, 7, 47, "Input"],
Cell[104571, 2953, 851, 17, 44, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[105471, 2976, 193, 7, 36, "Subsubsection"],
Cell[105667, 2985, 310, 10, 26, "Text"],
Cell[105980, 2997, 186, 5, 31, "Input"],
Cell[106169, 3004, 193, 6, 22, "Input"],
Cell[106365, 3012, 206, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[106596, 3024, 176, 5, 22, "Input"],
Cell[106775, 3031, 333, 10, 22, "Output"]
}, Open  ]],
Cell[107123, 3044, 66, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[107214, 3050, 417, 12, 22, "Input"],
Cell[107634, 3064, 310, 10, 22, "Output"]
}, Open  ]],
Cell[107959, 3077, 89, 2, 26, "Text"],
Cell[108051, 3081, 128, 3, 22, "Input"],
Cell[108182, 3086, 340, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[108547, 3102, 167, 4, 34, "Input"],
Cell[108717, 3108, 1147, 24, 35, "Output"]
}, Open  ]],
Cell[109879, 3135, 375, 12, 40, "Text"],

Cell[CellGroupData[{
Cell[110279, 3151, 409, 9, 60, "Input"],
Cell[110691, 3162, 1443, 25, 57, "Output"]
}, Open  ]],
Cell[112149, 3190, 153, 4, 22, "Input"],
Cell[112305, 3196, 398, 16, 26, "Text"],
Cell[112706, 3214, 142, 4, 22, "Input"],
Cell[112851, 3220, 309, 9, 40, "Text"],

Cell[CellGroupData[{
Cell[113185, 3233, 305, 8, 59, "Input"],
Cell[113493, 3243, 861, 18, 29, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[114415, 3268, 130, 3, 43, "Subsection"],
Cell[114548, 3273, 504, 15, 40, "Text"],
Cell[115055, 3290, 150, 4, 22, "Input"],

Cell[CellGroupData[{
Cell[115230, 3298, 264, 6, 47, "Input"],
Cell[115497, 3306, 3643, 91, 57, "Output"]
}, Open  ]],
Cell[119155, 3400, 135, 3, 26, "Text"],
Cell[119293, 3405, 227, 6, 22, "Input"],
Cell[119523, 3413, 171, 5, 26, "Text"],
Cell[119697, 3420, 210, 5, 22, "Input"],
Cell[119910, 3427, 389, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[120324, 3447, 125, 3, 22, "Input"],
Cell[120452, 3452, 6777, 187, 48, "Output"]
}, Open  ]],
Cell[127244, 3642, 216, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[127485, 3654, 203, 5, 22, "Input"],
Cell[127691, 3661, 310, 7, 31, "Output"]
}, Open  ]],
Cell[128016, 3671, 185, 5, 22, "Input"],
Cell[128204, 3678, 232, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[128461, 3690, 324, 8, 35, "Input"],
Cell[128788, 3700, 371, 8, 22, "Output"]
}, Open  ]],
Cell[129174, 3711, 279, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[129478, 3727, 154, 4, 34, "Input"],
Cell[129635, 3733, 2265, 49, 47, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[131937, 3787, 185, 6, 34, "Subsubsection"],
Cell[132125, 3795, 304, 10, 26, "Text"],
Cell[132432, 3807, 156, 4, 22, "Input"],

Cell[CellGroupData[{
Cell[132613, 3815, 147, 4, 22, "Input"],
Cell[132763, 3821, 163, 4, 28, "Output"]
}, Open  ]],
Cell[132941, 3828, 190, 6, 22, "Input"],
Cell[133134, 3836, 309, 9, 40, "Text"],

Cell[CellGroupData[{
Cell[133468, 3849, 201, 5, 34, "Input"],
Cell[133672, 3856, 495, 13, 22, "Output"]
}, Open  ]],
Cell[134182, 3872, 66, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[134273, 3878, 606, 16, 34, "Input"],
Cell[134882, 3896, 397, 11, 29, "Output"]
}, Open  ]],
Cell[135294, 3910, 282, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[135601, 3926, 240, 7, 34, "Input"],
Cell[135844, 3935, 435, 12, 29, "Output"]
}, Open  ]],
Cell[136294, 3950, 89, 2, 26, "Text"],
Cell[136386, 3954, 130, 3, 22, "Input"],
Cell[136519, 3959, 209, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[136753, 3971, 182, 4, 34, "Input"],
Cell[136938, 3977, 1123, 23, 35, "Output"]
}, Open  ]],
Cell[138076, 4003, 264, 9, 26, "Text"],

Cell[CellGroupData[{
Cell[138365, 4016, 388, 9, 72, "Input"],
Cell[138756, 4027, 1472, 25, 57, "Output"]
}, Open  ]],
Cell[140243, 4055, 153, 4, 22, "Input"],
Cell[140399, 4061, 367, 16, 26, "Text"],
Cell[140769, 4079, 142, 4, 22, "Input"],
Cell[140914, 4085, 309, 9, 40, "Text"],

Cell[CellGroupData[{
Cell[141248, 4098, 402, 9, 60, "Input"],
Cell[141653, 4109, 884, 18, 29, "Output"]
}, Open  ]],
Cell[142552, 4130, 65, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[142642, 4136, 557, 15, 34, "Input"],
Cell[143202, 4153, 864, 19, 29, "Output"]
}, Open  ]],
Cell[144081, 4175, 452, 16, 40, "Text"],

Cell[CellGroupData[{
Cell[144558, 4195, 292, 6, 47, "Input"],
Cell[144853, 4203, 916, 18, 44, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[145830, 4228, 189, 4, 43, "Subsection",
  Evaluatable->False,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
Cell[146022, 4234, 573, 13, 69, "Text"],
Cell[146598, 4249, 120, 3, 22, "Input"],
Cell[146721, 4254, 350, 11, 40, "Text"],
Cell[147074, 4267, 150, 4, 22, "Input"],
Cell[147227, 4273, 443, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[147695, 4293, 177, 4, 22, "Input"],
Cell[147875, 4299, 655, 17, 22, "Output"]
}, Open  ]],
Cell[148545, 4319, 553, 16, 54, "Text"],
Cell[149101, 4337, 521, 14, 34, "Input"],
Cell[149625, 4353, 220, 10, 26, "Text"],
Cell[149848, 4365, 237, 6, 22, "Input"],
Cell[150088, 4373, 533, 20, 40, "Text"],
Cell[150624, 4395, 202, 5, 22, "Input"],
Cell[150829, 4402, 226, 8, 26, "Text"],
Cell[151058, 4412, 234, 5, 34, "Input"],
Cell[151295, 4419, 171, 5, 26, "Text"],

Cell[CellGroupData[{
Cell[151491, 4428, 172, 4, 34, "Input"],
Cell[151666, 4434, 566, 17, 22, "Output"]
}, Open  ]],
Cell[152247, 4454, 252, 7, 35, "Input"],
Cell[152502, 4463, 393, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[152920, 4483, 218, 5, 47, "Input"],
Cell[153141, 4490, 1819, 54, 34, "Output"],
Cell[154963, 4546, 2372, 70, 32, "Output"],
Cell[157338, 4618, 3258, 93, 32, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[160633, 4716, 108, 2, 34, "Subsubsection"],
Cell[160744, 4720, 397, 14, 26, "Text"],

Cell[CellGroupData[{
Cell[161166, 4738, 260, 6, 22, "Input"],
Cell[161429, 4746, 141, 4, 22, "Output"]
}, Open  ]],
Cell[161585, 4753, 196, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[161806, 4765, 126, 3, 22, "Input"],
Cell[161935, 4770, 132, 3, 22, "Output"]
}, Open  ]],
Cell[162082, 4776, 90, 2, 26, "Text"],
Cell[162175, 4780, 142, 4, 22, "Input"],
Cell[162320, 4786, 212, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[162557, 4798, 175, 5, 22, "Input"],
Cell[162735, 4805, 97, 3, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[162869, 4813, 193, 5, 22, "Input"],
Cell[163065, 4820, 102, 3, 22, "Output"]
}, Open  ]],
Cell[163182, 4826, 194, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[163401, 4838, 116, 3, 22, "Input"],
Cell[163520, 4843, 97, 3, 22, "Output"]
}, Open  ]],
Cell[163632, 4849, 218, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[163875, 4861, 200, 5, 22, "Input"],
Cell[164078, 4868, 317, 7, 22, "Output"]
}, Open  ]],
Cell[164410, 4878, 414, 15, 40, "Text"],

Cell[CellGroupData[{
Cell[164849, 4897, 316, 8, 60, "Input"],
Cell[165168, 4907, 561, 12, 31, "Output"]
}, Open  ]],
Cell[165744, 4922, 170, 5, 26, "Text"],
Cell[165917, 4929, 185, 5, 22, "Input"],

Cell[CellGroupData[{
Cell[166127, 4938, 423, 11, 47, "Input"],
Cell[166553, 4951, 800, 17, 33, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[167402, 4974, 94, 2, 34, "Subsubsection"],
Cell[167499, 4978, 336, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[167860, 4994, 154, 4, 34, "Input"],
Cell[168017, 5000, 3299, 71, 62, "Output"]
}, Open  ]],
Cell[171331, 5074, 218, 4, 40, "Text"],
Cell[171552, 5080, 156, 4, 22, "Input"],
Cell[171711, 5086, 181, 5, 26, "Text"],
Cell[171895, 5093, 177, 5, 22, "Input"],
Cell[172075, 5100, 629, 21, 40, "Text"],

Cell[CellGroupData[{
Cell[172729, 5125, 186, 5, 22, "Input"],
Cell[172918, 5132, 760, 21, 22, "Output"]
}, Open  ]],
Cell[173693, 5156, 463, 16, 40, "Text"],

Cell[CellGroupData[{
Cell[174181, 5176, 433, 12, 22, "Input"],
Cell[174617, 5190, 472, 12, 29, "Output"]
}, Open  ]],
Cell[175104, 5205, 89, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[175218, 5211, 114, 3, 22, "Input"],
Cell[175335, 5216, 485, 13, 29, "Output"]
}, Open  ]],
Cell[175835, 5232, 871, 30, 54, "Text"],

Cell[CellGroupData[{
Cell[176731, 5266, 147, 4, 22, "Input"],
Cell[176881, 5272, 163, 4, 28, "Output"]
}, Open  ]],
Cell[177059, 5279, 82, 2, 26, "Text"],
Cell[177144, 5283, 179, 5, 22, "Input"],
Cell[177326, 5290, 293, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[177644, 5306, 155, 4, 34, "Input"],
Cell[177802, 5312, 934, 24, 29, "Output"]
}, Open  ]],
Cell[178751, 5339, 220, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[178996, 5351, 157, 4, 34, "Input"],
Cell[179156, 5357, 2246, 45, 69, "Output"]
}, Open  ]],
Cell[181417, 5405, 1070, 25, 97, "Text"],
Cell[182490, 5432, 214, 6, 42, "Text"],
Cell[182707, 5440, 411, 11, 40, "Text"],
Cell[183121, 5453, 327, 7, 22, "Input"],
Cell[183451, 5462, 253, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[183729, 5474, 241, 6, 34, "Input"],
Cell[183973, 5482, 1032, 18, 51, "Output"]
}, Open  ]],
Cell[185020, 5503, 215, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[185260, 5515, 150, 4, 22, "Input"],
Cell[185413, 5521, 394, 7, 22, "Output"]
}, Open  ]],
Cell[185822, 5531, 174, 7, 26, "Text"],

Cell[CellGroupData[{
Cell[186021, 5542, 147, 4, 22, "Input"],
Cell[186171, 5548, 408, 7, 22, "Output"]
}, Open  ]],
Cell[186594, 5558, 219, 8, 26, "Text"],
Cell[186816, 5568, 299, 7, 34, "Input"],
Cell[187118, 5577, 609, 22, 26, "Text"],
Cell[187730, 5601, 323, 7, 47, "Input"],
Cell[188056, 5610, 445, 14, 40, "Text"],

Cell[CellGroupData[{
Cell[188526, 5628, 199, 5, 34, "Input"],
Cell[188728, 5635, 3052, 53, 126, "Output"]
}, Open  ]],
Cell[191795, 5691, 336, 11, 40, "Text"],
Cell[192134, 5704, 122, 3, 22, "Input"],
Cell[192259, 5709, 125, 3, 22, "Input"],
Cell[192387, 5714, 500, 19, 40, "Text"],

Cell[CellGroupData[{
Cell[192912, 5737, 300, 8, 47, "Input"],
Cell[193215, 5747, 3907, 66, 150, "Output"]
}, Open  ]],
Cell[197137, 5816, 181, 5, 42, "Text"],
Cell[197321, 5823, 1144, 30, 97, "Text"],

Cell[CellGroupData[{
Cell[198490, 5857, 208, 6, 34, "Input"],
Cell[198701, 5865, 1026, 18, 51, "Output"]
}, Open  ]],
Cell[199742, 5886, 114, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[199881, 5892, 316, 7, 47, "Input"],
Cell[200200, 5901, 232, 5, 22, "Output"]
}, Open  ]],
Cell[200447, 5909, 318, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[200790, 5925, 145, 4, 22, "Input"],
Cell[200938, 5931, 703, 11, 38, "Output"]
}, Open  ]],
Cell[201656, 5945, 171, 5, 26, "Text"],

Cell[CellGroupData[{
Cell[201852, 5954, 137, 3, 22, "Input"],
Cell[201992, 5959, 121, 3, 22, "Output"]
}, Open  ]],
Cell[202128, 5965, 172, 5, 26, "Text"],

Cell[CellGroupData[{
Cell[202325, 5974, 158, 4, 22, "Input"],
Cell[202486, 5980, 390, 7, 22, "Output"]
}, Open  ]],
Cell[202891, 5990, 313, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[203229, 6006, 181, 5, 22, "Input"],
Cell[203413, 6013, 177, 4, 28, "Output"]
}, Open  ]],
Cell[203605, 6020, 78, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[203708, 6026, 109, 3, 22, "Input"],
Cell[203820, 6031, 85, 3, 22, "Output"]
}, Open  ]],
Cell[203920, 6037, 321, 12, 26, "Text"],
Cell[204244, 6051, 487, 20, 26, "Text"],
Cell[204734, 6073, 508, 10, 85, "Input"],
Cell[205245, 6085, 443, 16, 40, "Text"],

Cell[CellGroupData[{
Cell[205713, 6105, 255, 6, 47, "Input"],
Cell[205971, 6113, 2395, 44, 81, "Output"]
}, Open  ]],
Cell[208381, 6160, 309, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[208715, 6176, 161, 5, 22, "Input"],
Cell[208879, 6183, 2411, 49, 94, "Output"]
}, Open  ]],
Cell[211305, 6235, 464, 16, 40, "Text"],

Cell[CellGroupData[{
Cell[211794, 6255, 205, 5, 34, "Input"],
Cell[212002, 6262, 222, 5, 28, "Output"]
}, Open  ]],
Cell[212239, 6270, 308, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[212572, 6286, 130, 3, 22, "Input"],
Cell[212705, 6291, 241, 5, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[212983, 6301, 125, 3, 22, "Input"],
Cell[213111, 6306, 405, 8, 28, "Output"]
}, Open  ]],
Cell[213531, 6317, 442, 17, 26, "Text"],

Cell[CellGroupData[{
Cell[213998, 6338, 296, 8, 47, "Input"],
Cell[214297, 6348, 4269, 73, 160, "Output"]
}, Open  ]],
Cell[218581, 6424, 117, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[218723, 6430, 159, 4, 22, "Input"],
Cell[218885, 6436, 82, 3, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[219004, 6444, 159, 4, 22, "Input"],
Cell[219166, 6450, 82, 3, 22, "Output"]
}, Open  ]],
Cell[219263, 6456, 221, 6, 40, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[219521, 6467, 93, 2, 34, "Subsubsection"],
Cell[219617, 6471, 262, 9, 26, "Text"],
Cell[219882, 6482, 144, 4, 22, "Input"],
Cell[220029, 6488, 454, 13, 40, "Text"],

Cell[CellGroupData[{
Cell[220508, 6505, 272, 7, 34, "Input"],
Cell[220783, 6514, 2377, 55, 51, "Output"]
}, Open  ]],
Cell[223175, 6572, 361, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[223561, 6588, 569, 15, 34, "Input"],
Cell[224133, 6605, 740, 17, 29, "Output"]
}, Open  ]],
Cell[224888, 6625, 444, 16, 40, "Text"],

Cell[CellGroupData[{
Cell[225357, 6645, 282, 6, 34, "Input"],
Cell[225642, 6653, 798, 16, 44, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[226501, 6676, 192, 4, 43, "Subsection",
  Evaluatable->False,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
Cell[226696, 6682, 282, 9, 26, "Text"],
Cell[226981, 6693, 203, 5, 22, "Input"],
Cell[227187, 6700, 235, 6, 22, "Input"],
Cell[227425, 6708, 182, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[227632, 6720, 217, 5, 31, "Input"],
Cell[227852, 6727, 782, 15, 54, "Output"]
}, Open  ]],
Cell[228649, 6745, 286, 8, 40, "Text"],
Cell[228938, 6755, 514, 13, 22, "Input"],
Cell[229455, 6770, 182, 7, 26, "Text"],
Cell[229640, 6779, 308, 8, 35, "Input"],
Cell[229951, 6789, 538, 20, 40, "Text"],
Cell[230492, 6811, 202, 5, 22, "Input"],
Cell[230697, 6818, 131, 3, 26, "Text"],
Cell[230831, 6823, 207, 5, 22, "Input"],
Cell[231041, 6830, 171, 5, 26, "Text"],
Cell[231215, 6837, 224, 5, 22, "Input"],
Cell[231442, 6844, 389, 16, 26, "Text"],

Cell[CellGroupData[{
Cell[231856, 6864, 125, 3, 22, "Input"],
Cell[231984, 6869, 7858, 211, 59, "Output"]
}, Open  ]],
Cell[239857, 7083, 262, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[240144, 7095, 339, 7, 60, "Input"],
Cell[240486, 7104, 345, 7, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[240868, 7116, 277, 7, 35, "Input"],
Cell[241148, 7125, 817, 16, 54, "Output"]
}, Open  ]],
Cell[241980, 7144, 248, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[242253, 7156, 159, 4, 34, "Input"],
Cell[242415, 7162, 4356, 76, 157, "Output"]
}, Open  ]],
Cell[246786, 7241, 295, 11, 26, "Text"],

Cell[CellGroupData[{
Cell[247106, 7256, 176, 5, 22, "Input"],
Cell[247285, 7263, 638, 15, 31, "Output"]
}, Open  ]],
Cell[247938, 7281, 65, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[248028, 7287, 627, 16, 34, "Input"],
Cell[248658, 7305, 496, 13, 29, "Output"]
}, Open  ]],
Cell[249169, 7321, 214, 8, 26, "Text"],
Cell[249386, 7331, 275, 8, 34, "Input"],
Cell[249664, 7341, 589, 19, 55, "Text"],

Cell[CellGroupData[{
Cell[250278, 7364, 507, 10, 72, "Input"],
Cell[250788, 7376, 4623, 79, 207, "Output"]
}, Open  ]],
Cell[255426, 7458, 369, 11, 40, "Text"],
Cell[255798, 7471, 146, 4, 22, "Input"],
Cell[255947, 7477, 255, 9, 26, "Text"],

Cell[CellGroupData[{
Cell[256227, 7490, 355, 7, 60, "Input"],
Cell[256585, 7499, 4624, 79, 207, "Output"]
}, Open  ]],
Cell[261224, 7581, 103, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[261352, 7587, 103, 3, 22, "Input"],
Cell[261458, 7592, 101, 3, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[261596, 7600, 95, 3, 22, "Input"],
Cell[261694, 7605, 85, 3, 22, "Output"]
}, Open  ]],
Cell[261794, 7611, 243, 8, 26, "Text"],
Cell[262040, 7621, 273, 7, 35, "Input"],
Cell[262316, 7630, 264, 9, 26, "Text"],
Cell[262583, 7641, 148, 4, 22, "Input"],
Cell[262734, 7647, 295, 11, 26, "Text"],

Cell[CellGroupData[{
Cell[263054, 7662, 1249, 28, 85, "Input"],
Cell[264306, 7692, 1244, 25, 58, "Output"]
}, Open  ]],
Cell[265565, 7720, 65, 2, 26, "Text"],
Cell[265633, 7724, 173, 5, 22, "Input"],

Cell[CellGroupData[{
Cell[265831, 7733, 163, 4, 22, "Input"],
Cell[265997, 7739, 740, 17, 29, "Output"]
}, Open  ]],
Cell[266752, 7759, 137, 4, 26, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[266926, 7768, 242, 8, 43, "Subsection",
  Evaluatable->False,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
Cell[267171, 7778, 1222, 37, 83, "Text"],
Cell[268396, 7817, 11731, 226, 1012, "Input"],

Cell[CellGroupData[{
Cell[280152, 8047, 184, 4, 34, "Subsubsection"],
Cell[280339, 8053, 159, 4, 22, "Input"],
Cell[280501, 8059, 169, 5, 22, "Input"],

Cell[CellGroupData[{
Cell[280695, 8068, 120, 3, 22, "Input"],
Cell[280818, 8073, 547, 9, 20, "Print"],
Cell[281368, 8084, 486, 11, 29, "Print"],
Cell[281857, 8097, 354, 6, 29, "Print"],
Cell[282214, 8105, 492, 11, 27, "Print"],
Cell[282709, 8118, 117, 3, 22, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[282875, 8127, 204, 5, 34, "Subsubsection"],
Cell[283082, 8134, 153, 4, 22, "Input"],
Cell[283238, 8140, 169, 5, 22, "Input"],

Cell[CellGroupData[{
Cell[283432, 8149, 120, 3, 22, "Input"],
Cell[283555, 8154, 547, 9, 20, "Print"],
Cell[284105, 8165, 2366, 43, 83, "Print"],
Cell[286474, 8210, 231, 5, 29, "Print"],
Cell[286708, 8217, 354, 6, 29, "Print"],
Cell[287065, 8225, 922, 19, 39, "Print"],
Cell[287990, 8246, 117, 3, 22, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[288156, 8255, 204, 5, 34, "Subsubsection"],
Cell[288363, 8262, 156, 4, 22, "Input"],
Cell[288522, 8268, 173, 5, 22, "Input"],

Cell[CellGroupData[{
Cell[288720, 8277, 120, 3, 22, "Input"],
Cell[288843, 8282, 547, 9, 20, "Print"],
Cell[289393, 8293, 1910, 35, 63, "Print"],
Cell[291306, 8330, 231, 5, 29, "Print"],
Cell[291540, 8337, 354, 6, 29, "Print"],
Cell[291897, 8345, 829, 17, 29, "Print"],
Cell[292729, 8364, 117, 3, 22, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[292895, 8373, 204, 5, 34, "Subsubsection"],
Cell[293102, 8380, 153, 4, 22, "Input"],
Cell[293258, 8386, 169, 5, 22, "Input"],

Cell[CellGroupData[{
Cell[293452, 8395, 120, 3, 22, "Input"],
Cell[293575, 8400, 547, 9, 20, "Print"],
Cell[294125, 8411, 2468, 44, 85, "Print"],
Cell[296596, 8457, 231, 5, 29, "Print"],
Cell[296830, 8464, 354, 6, 29, "Print"],
Cell[297187, 8472, 923, 19, 39, "Print"],
Cell[298113, 8493, 117, 3, 22, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[298279, 8502, 204, 5, 34, "Subsubsection"],
Cell[298486, 8509, 156, 4, 22, "Input"],
Cell[298645, 8515, 173, 5, 22, "Input"],

Cell[CellGroupData[{
Cell[298843, 8524, 120, 3, 22, "Input"],
Cell[298966, 8529, 547, 9, 20, "Print"],
Cell[299516, 8540, 1910, 35, 63, "Print"],
Cell[301429, 8577, 231, 5, 29, "Print"],
Cell[301663, 8584, 354, 6, 29, "Print"],
Cell[302020, 8592, 827, 17, 27, "Print"],
Cell[302850, 8611, 117, 3, 22, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[303016, 8620, 181, 4, 34, "Subsubsection"],
Cell[303200, 8626, 153, 4, 22, "Input"],
Cell[303356, 8632, 147, 4, 22, "Input"],

Cell[CellGroupData[{
Cell[303528, 8640, 120, 3, 22, "Input"],
Cell[303651, 8645, 547, 9, 20, "Print"],
Cell[304201, 8656, 2370, 42, 85, "Print"],
Cell[306574, 8700, 231, 5, 29, "Print"],
Cell[306808, 8707, 354, 6, 29, "Print"],
Cell[307165, 8715, 1395, 25, 49, "Print"],
Cell[308563, 8742, 116, 3, 22, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[308752, 8753, 278, 6, 46, "Section",
  Evaluatable->False,
  CellTags->{"ChapterTwo", "ChapterTwo.2", "ChapterTwo.2.1"}],
Cell[309033, 8761, 467, 11, 54, "Text"],
Cell[309503, 8774, 112, 3, 22, "Input"],
Cell[309618, 8779, 328, 8, 22, "Input"],
Cell[309949, 8789, 432, 11, 22, "Input"],
Cell[310384, 8802, 273, 8, 26, "Text"],
Cell[310660, 8812, 367, 8, 83, "Input"],
Cell[311030, 8822, 209, 8, 26, "Text"],
Cell[311242, 8832, 147, 4, 22, "Input"],

Cell[CellGroupData[{
Cell[311414, 8840, 440, 12, 34, "Input"],
Cell[311857, 8854, 593, 15, 33, "Output"]
}, Open  ]],
Cell[312465, 8872, 265, 10, 26, "Text"],

Cell[CellGroupData[{
Cell[312755, 8886, 327, 8, 47, "Input"],
Cell[313085, 8896, 860, 21, 33, "Output"]
}, Open  ]],
Cell[313960, 8920, 803, 32, 40, "Text"],
Cell[314766, 8954, 670, 25, 40, "Text"],
Cell[315439, 8981, 267, 7, 34, "Input"],
Cell[315709, 8990, 468, 15, 40, "Text"],
Cell[316180, 9007, 254, 6, 34, "Input"],
Cell[316437, 9015, 325, 12, 26, "Text"],
Cell[316765, 9029, 172, 5, 22, "Input"],
Cell[316940, 9036, 324, 9, 40, "Text"],
Cell[317267, 9047, 191, 4, 34, "Input"],
Cell[317461, 9053, 189, 4, 22, "Input"],

Cell[CellGroupData[{
Cell[317675, 9061, 182, 5, 22, "Input"],
Cell[317860, 9068, 187, 4, 28, "Output"]
}, Open  ]],
Cell[318062, 9075, 191, 7, 26, "Text"],
Cell[318256, 9084, 156, 4, 22, "Input"],

Cell[CellGroupData[{
Cell[318437, 9092, 147, 4, 22, "Input"],
Cell[318587, 9098, 163, 4, 28, "Output"]
}, Open  ]],
Cell[318765, 9105, 191, 6, 22, "Input"],
Cell[318959, 9113, 196, 6, 22, "Input"],
Cell[319158, 9121, 242, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[319425, 9133, 332, 8, 60, "Input"],
Cell[319760, 9143, 539, 11, 48, "Output"]
}, Open  ]],
Cell[320314, 9157, 106, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[320445, 9163, 221, 6, 34, "Input"],
Cell[320669, 9171, 2081, 40, 120, "Output"]
}, Open  ]],
Cell[322765, 9214, 379, 10, 40, "Text"],

Cell[CellGroupData[{
Cell[323169, 9228, 222, 5, 34, "Input"],
Cell[323394, 9235, 1450, 26, 93, "Output"]
}, Open  ]],
Cell[324859, 9264, 231, 6, 40, "Text"],

Cell[CellGroupData[{
Cell[325115, 9274, 187, 5, 22, "Input"],
Cell[325305, 9281, 1750, 32, 129, "Output"]
}, Open  ]],
Cell[327070, 9316, 730, 25, 55, "Text"],

Cell[CellGroupData[{
Cell[327825, 9345, 622, 13, 98, "Input"],
Cell[328450, 9360, 2623, 47, 123, "Output"]
}, Open  ]],
Cell[331088, 9410, 110, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[331223, 9416, 240, 6, 47, "Input"],
Cell[331466, 9424, 2322, 40, 149, "Output"]
}, Open  ]],
Cell[333803, 9467, 384, 13, 40, "Text"],

Cell[CellGroupData[{
Cell[334212, 9484, 266, 7, 47, "Input"],
Cell[334481, 9493, 117, 3, 22, "Output"]
}, Open  ]],
Cell[334613, 9499, 608, 20, 40, "Text"],

Cell[CellGroupData[{
Cell[335246, 9523, 420, 9, 72, "Input"],
Cell[335669, 9534, 863, 16, 50, "Output"]
}, Open  ]],
Cell[336547, 9553, 112, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[336684, 9559, 311, 8, 47, "Input"],
Cell[336998, 9569, 1702, 30, 93, "Output"]
}, Open  ]],
Cell[338715, 9602, 120, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[338860, 9608, 240, 6, 47, "Input"],
Cell[339103, 9616, 1701, 34, 88, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[340853, 9656, 96, 2, 46, "Section"],
Cell[340952, 9660, 457, 11, 55, "Text"],
Cell[341412, 9673, 295, 6, 45, "Input"],
Cell[341710, 9681, 277, 7, 22, "Input"],

Cell[CellGroupData[{
Cell[342012, 9692, 307, 7, 22, "Input"],
Cell[342322, 9701, 1328, 28, 70, "Output"]
}, Open  ]],
Cell[343665, 9732, 159, 5, 26, "Text"],
Cell[343827, 9739, 141, 4, 22, "Input"],

Cell[CellGroupData[{
Cell[343993, 9747, 464, 13, 48, "Input"],
Cell[344460, 9762, 618, 13, 57, "Output"]
}, Open  ]],
Cell[345093, 9778, 109, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[345227, 9784, 256, 6, 22, "Input"],
Cell[345486, 9792, 564, 15, 22, "Output"]
}, Open  ]],
Cell[346065, 9810, 110, 2, 26, "Text"],
Cell[346178, 9814, 244, 5, 34, "Input"],
Cell[346425, 9821, 624, 23, 40, "Text"],
Cell[347052, 9846, 259, 6, 34, "Input"],
Cell[347314, 9854, 225, 8, 26, "Text"],
Cell[347542, 9864, 167, 5, 22, "Input"],

Cell[CellGroupData[{
Cell[347734, 9873, 89, 2, 43, "Subsection"],
Cell[347826, 9877, 119, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[347970, 9883, 142, 4, 22, "Input"],
Cell[348115, 9889, 168, 4, 22, "Output"]
}, Open  ]],
Cell[348298, 9896, 418, 12, 48, "Input"],
Cell[348719, 9910, 525, 20, 40, "Text"],

Cell[CellGroupData[{
Cell[349269, 9934, 210, 5, 34, "Input"],
Cell[349482, 9941, 180, 5, 20, "Message"],
Cell[349665, 9948, 305, 7, 29, "Output"]
}, Open  ]],
Cell[349985, 9958, 290, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[350300, 9974, 185, 5, 22, "Input"],
Cell[350488, 9981, 206, 5, 29, "Output"]
}, Open  ]],
Cell[350709, 9989, 135, 4, 26, "Text"],

Cell[CellGroupData[{
Cell[350869, 9997, 343, 9, 35, "Input"],
Cell[351215, 10008, 408, 9, 30, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[351672, 10023, 90, 2, 43, "Subsection"],
Cell[351765, 10027, 335, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[352125, 10043, 130, 3, 22, "Input"],
Cell[352258, 10048, 4147, 81, 164, "Output"]
}, Open  ]],
Cell[356420, 10132, 586, 17, 55, "Text"],

Cell[CellGroupData[{
Cell[357031, 10153, 206, 6, 34, "Input"],
Cell[357240, 10161, 314, 6, 34, "Output"]
}, Open  ]],
Cell[357569, 10170, 211, 8, 26, "Text"],
Cell[357783, 10180, 284, 6, 22, "Input"],
Cell[358070, 10188, 111, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[358206, 10194, 293, 6, 34, "Input"],
Cell[358502, 10202, 112, 3, 22, "Output"]
}, Open  ]],
Cell[358629, 10208, 286, 11, 26, "Text"],

Cell[CellGroupData[{
Cell[358940, 10223, 245, 6, 47, "Input"],
Cell[359188, 10231, 381, 9, 29, "Output"]
}, Open  ]],
Cell[359584, 10243, 145, 4, 26, "Text"],
Cell[359732, 10249, 134, 3, 22, "Input"],
Cell[359869, 10254, 142, 4, 26, "Text"],

Cell[CellGroupData[{
Cell[360036, 10262, 134, 3, 22, "Input"],
Cell[360173, 10267, 348, 7, 22, "Output"]
}, Open  ]],
Cell[360536, 10277, 160, 7, 26, "Text"],

Cell[CellGroupData[{
Cell[360721, 10288, 213, 6, 22, "Input"],
Cell[360937, 10296, 532, 10, 34, "Output"]
}, Open  ]],
Cell[361484, 10309, 447, 15, 40, "Text"],

Cell[CellGroupData[{
Cell[361956, 10328, 263, 6, 47, "Input"],
Cell[362222, 10336, 1966, 37, 102, "Output"]
}, Open  ]],
Cell[364203, 10376, 290, 12, 26, "Text"],

Cell[CellGroupData[{
Cell[364518, 10392, 137, 3, 22, "Input"],
Cell[364658, 10397, 1697, 32, 86, "Output"]
}, Open  ]],
Cell[366370, 10432, 141, 4, 26, "Text"],
Cell[366514, 10438, 352, 10, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[366903, 10453, 90, 2, 43, "Subsection"],
Cell[366996, 10457, 514, 20, 26, "Text"],
Cell[367513, 10479, 219, 5, 34, "Input"],
Cell[367735, 10486, 217, 8, 26, "Text"],

Cell[CellGroupData[{
Cell[367977, 10498, 171, 5, 22, "Input"],
Cell[368151, 10505, 764, 12, 59, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[368952, 10522, 144, 4, 22, "Input"],
Cell[369099, 10528, 811, 13, 59, "Output"]
}, Open  ]],
Cell[369925, 10544, 114, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[370064, 10550, 291, 6, 34, "Input"],
Cell[370358, 10558, 173, 4, 22, "Output"]
}, Open  ]],
Cell[370546, 10565, 281, 11, 26, "Text"],

Cell[CellGroupData[{
Cell[370852, 10580, 262, 7, 47, "Input"],
Cell[371117, 10589, 1025, 19, 58, "Output"]
}, Open  ]],
Cell[372157, 10611, 145, 4, 26, "Text"],
Cell[372305, 10617, 133, 3, 22, "Input"],
Cell[372441, 10622, 157, 5, 26, "Text"],

Cell[CellGroupData[{
Cell[372623, 10631, 135, 3, 22, "Input"],
Cell[372761, 10636, 798, 13, 33, "Output"]
}, Open  ]],
Cell[373574, 10652, 163, 7, 26, "Text"],
Cell[373740, 10661, 219, 6, 22, "Input"],
Cell[373962, 10669, 459, 15, 40, "Text"],
Cell[374424, 10686, 288, 6, 47, "Input"],
Cell[374715, 10694, 290, 12, 26, "Text"],
Cell[375008, 10708, 146, 4, 22, "Input"],
Cell[375157, 10714, 372, 16, 26, "Text"],
Cell[375532, 10732, 324, 6, 22, "Input"],
Cell[375859, 10740, 96, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[375980, 10746, 390, 8, 47, "Input"],
Cell[376373, 10756, 2949, 54, 135, "Output"]
}, Open  ]],
Cell[379337, 10813, 65, 2, 26, "Text"],

Cell[CellGroupData[{
Cell[379427, 10819, 208, 5, 22, "Input"],
Cell[379638, 10826, 855, 20, 70, "Output"]
}, Open  ]],
Cell[380508, 10849, 194, 5, 26, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

